/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.change.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import yem.wm.base.com.change.common.enums.BillStatusEnum;
import yem.wm.base.com.change.common.enums.EnableStatusEnum;
import yem.wm.base.com.change.utils.ChangsUtils;

public class BillTypeHelper {
    public static boolean checkBillType(String formId, Long billtypeId) {
        if (ChangsUtils.isNull(billtypeId)) {
            return false;
        }
        List<Long> billTypeList = BillTypeHelper.getAllBillTypes(formId);
        return billTypeList != null && billTypeList.contains(billtypeId);
    }

    public static Long getDefaultBillType(String formId) {
        DynamicObject dym;
        if (ChangsUtils.isNull(formId)) {
            return null;
        }
        Long billType = null;
        Map map = BillTypeServiceHelper.getBillTypeObject((String)formId);
        if (ChangsUtils.isNull(map)) {
            return null;
        }
        Iterator var3 = map.values().iterator();
        do {
            if (var3.hasNext()) continue;
            return billType;
        } while (!(dym = (DynamicObject)var3.next()).getBoolean("isdefault"));
        return (Long)dym.getPkValue();
    }

    public static List<Long> getAllBillTypes(String formId) {
        if (ChangsUtils.isNull(formId)) {
            return null;
        }
        new ArrayList();
        Map map = BillTypeServiceHelper.getBillTypeObject((String)formId);
        if (ChangsUtils.isNull(map)) {
            return null;
        }
        List<Long> billTypeList = map.values().stream().map(dym -> dym.getLong("id")).collect(Collectors.toList());
        return billTypeList;
    }

    public static Object getBillTypeParameter(String formId, long billTypeId, String paramFormId, String propertyName) {
        if (!(ChangsUtils.isNull(formId) || ChangsUtils.isNull(billTypeId) || ChangsUtils.isNull(paramFormId) || ChangsUtils.isNull(propertyName))) {
            DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
            return !ChangsUtils.isNull(billTypeParam) ? billTypeParam.get(propertyName) : null;
        }
        return null;
    }

    public static Map<Object, DynamicObject> getBillTypesByEntity(String formid) {
        QFilter qFilter1 = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter qFilter2 = new QFilter("billformid", "=", (Object)formid);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map billTypes = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"billformid,number,name", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, (String)"isdefault desc");
        return ChangsUtils.isNull(billTypes) ? null : billTypes;
    }

    public static DynamicObject getBillTypeByEntity(String formid) {
        Map<Object, DynamicObject> billTypes = BillTypeHelper.getBillTypesByEntity(formid);
        return billTypes != null && !billTypes.isEmpty() ? (DynamicObject)billTypes.values().toArray()[0] : null;
    }
}

