/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.component.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;
import yem.wm.base.com.component.utils.ComponentUtil;

public class ComponentBillPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String billKey = dataEntity.getDynamicObjectType().getName();
        DynamicObject template = ComponentUtil.loadTemplate(billKey);
        QFilter filter = null;
        long pkId = dataEntity.getLong("id");
        if (YEM.isNotEmpty((Object)pkId)) {
            filter = new QFilter("yem_parentid", "=", (Object)String.valueOf(pkId));
        }
        this.loadComponents(template, view, filter);
        model.setValue("yem_billcompconfig", (Object)template);
        model.setDataChanged(false);
    }

    private void loadComponents(DynamicObject template, IFormView view, QFilter filter) {
        if (template != null) {
            String pageId = view.getPageId();
            IPageCache pageCache = view.getPageCache();
            OperationStatus opStatus = view.getFormShowParameter().getStatus();
            DynamicObjectCollection dynamicObjectCollection = template.getDynamicObjectCollection("yem_com_djzj_zjxx");
            Map<String, DynamicObject> collect = dynamicObjectCollection.stream().collect(Collectors.toMap(s -> s.getDynamicObject("yem_component").getString("number"), s -> s, (s1, s2) -> s1));
            for (Map.Entry<String, DynamicObject> stringStringEntry : collect.entrySet()) {
                String compKey = stringStringEntry.getKey();
                DynamicObject compConfigObj = stringStringEntry.getValue();
                String targetKey = compConfigObj.getString("yem_targetcontainer");
                boolean isShowComp = compConfigObj.getBoolean("yem_isshowcomp");
                DynamicObject compObj = compConfigObj.getDynamicObject("yem_component");
                boolean isCompEnable = compObj != null && compObj.getBoolean("enable");
                view.setVisible(Boolean.valueOf(isCompEnable && isShowComp), new String[]{targetKey});
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setStatus(opStatus);
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey(targetKey);
                showParameter.setFormId(compKey);
                showParameter.setCustomParam("parentPageId", (Object)pageId);
                this.setBillPkId(showParameter, compKey, filter);
                view.showForm((FormShowParameter)showParameter);
                pageCache.put("comp_" + compKey, showParameter.getPageId());
            }
        }
    }

    private void setBillPkId(BillShowParameter showParameter, String compKey, QFilter filter) {
        DynamicObject object;
        if (filter != null && (object = BusinessDataServiceHelper.loadSingle((String)compKey, (QFilter[])filter.toArray())) != null) {
            showParameter.setPkId((Object)object.getLong("id"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        if (!evt.isCancel()) {
            String operateKey = ((AbstractOperate)evt.getSource()).getOperateKey();
            IFormView view = this.getView();
            switch (operateKey) {
                case "delete": {
                    break;
                }
                case "submit": {
                    IDataModel model = this.getModel();
                    DynamicObject template = (DynamicObject)model.getValue("yem_billcompconfig");
                    if (this.doOperation("validate_legal", template, view)) break;
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IFormView view = this.getView();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (operateKey) {
                case "delete": {
                    break;
                }
                default: {
                    IDataModel model = this.getModel();
                    DynamicObject template = (DynamicObject)model.getValue("yem_billcompconfig");
                    this.doOperation(operateKey, template, view);
                }
            }
        }
    }

    private boolean doOperation(String opKey, DynamicObject template, IFormView view) {
        boolean success = true;
        ArrayList operateInfos = new ArrayList();
        IPageCache pageCache = view.getPageCache();
        List<String> collect = ComponentUtil.getCompKeys(template);
        for (String compKey : collect) {
            String compPageId = pageCache.get("comp_" + compKey);
            if (!YEM.isNotEmpty((Object)compPageId)) continue;
            DynamicObject dataEntity = view.getModel().getDataEntity(true);
            IFormView compView = view.getView(compPageId);
            String entityKey = compView.getEntityId();
            Map<String, String> opreateMap = this.getOpreateMap(entityKey);
            if (null == opreateMap.get(opKey)) {
                opKey = "donothing";
            }
            IDataModel compModel = compView.getModel();
            compModel.setValue("yem_parentid", (Object)dataEntity.getString("id"));
            compModel.setValue("yem_pentitykey", (Object)dataEntity.getDataEntityType().getName());
            view.sendFormAction(compView);
            OperateOption option = YEM.getOptionNoMsg();
            option.setVariableValue("currDoOperationKey", opKey);
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult compOpResult = compView.invokeOperation(opKey, option);
            view.sendFormAction(compView);
            if (compOpResult == null || compOpResult.isSuccess()) continue;
            List allErrorOrValidateInfo = compOpResult.getAllErrorOrValidateInfo();
            operateInfos.addAll(allErrorOrValidateInfo);
            success = false;
        }
        if (!success) {
            OperationResult result = new OperationResult();
            result.setSuccess(false);
            for (IOperateInfo operateInfo : operateInfos) {
                result.addErrorInfo((OperateErrorInfo)operateInfo);
            }
            view.showOperationResult(result);
        }
        return success;
    }

    private Map<String, String> getOpreateMap(String entityKey) {
        HashMap<String, String> opreateMap = new HashMap<String, String>(8);
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityKey);
        if (dataEntityOperate.isEmpty()) {
            return opreateMap;
        }
        for (Map operate : dataEntityOperate) {
            String key = (String)operate.get("key");
            Object name = operate.get("name");
            LocaleString localeString = name != null ? (name instanceof Map ? LocaleString.fromMap((Map)((Map)name)) : new LocaleString(name.toString())) : new LocaleString("\u672a\u547d\u540d\u64cd\u4f5c");
            opreateMap.put(key, localeString.getLocaleValue());
        }
        return opreateMap;
    }
}

