/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.isv.dynamic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.designer.ctbotp.CtRuleCacheHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.ctbotp.CtRuleTreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.utils.SystemParamUtil;

public class CovertRuleFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public void afterBindData(EventObject e) {
        this.checkYemIsv(this.getModel());
    }

    private void checkYemIsv(IDataModel model) {
        boolean isvCheck = (Boolean)SystemParamUtil.getAppParam((String)"yem_com", (String)"yem_isvcheck");
        if (isvCheck) {
            String fid = (String)model.getValue("fid");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("number", "=", (Object)fid));
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            DynamicObject wmtranrule = BusinessDataServiceHelper.loadSingle((String)"yem_com_wmtranrule", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (wmtranrule != null) {
                Label label = (Label)this.getView().getControl("lblisv");
                label.setText("\u672c\u89c4\u5219\u7531\u3010\u5916\u8d38\u6807\u51c6\u4ea7\u54c1\u3011\u53d1\u5e03\uff0c\u8bf7\u52ff\u76f4\u63a5\u6539\u52a8\uff1b\u53ef\u4ee5\u6269\u5c55\u4e00\u4e2a\u65b0\u5206\u652f\u540e\u4fee\u6539");
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.removeAction("setFormStatus");
                clientViewProxy.addAction("setFormStatus", (Object)BillOperationStatus.EDIT.getValue());
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldmappolicy");
                entryGrid.setColumnProperty("fclearsourcefield", "ln", (Object)false);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"lblisv"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"fautosave"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"fbillpush"});
            }
        }
    }

    public void registerListener(EventObject e) {
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"tbar_treeview", "tbar_main"});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.checkYemIsv(this.getModel());
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        boolean isvCheck = (Boolean)SystemParamUtil.getAppParam((String)"yem_com", (String)"yem_isvcreate");
        if (isvCheck) {
            switch (itemKey) {
                case "btnsave": {
                    this.createTable();
                    break;
                }
                case "btndelete": {
                    this.deleteTable();
                }
            }
        }
    }

    private void deleteTable() {
        CtRuleTreeNode rootRuleNode = CtRuleCacheHelper.getRootRuleNode((AbstractFormPlugin)this);
        List ctRuleTreeNodes = rootRuleNode.mergeAllChildren();
        List<String> deleteRuleIds = ctRuleTreeNodes.stream().filter(CtRuleTreeNode::isDeleted).map(CtRuleTreeNode::getId).collect(Collectors.toList());
        if (deleteRuleIds.size() > 0) {
            DeleteServiceHelper.delete((String)"yem_com_wmtranrule", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)deleteRuleIds.toArray(new String[0]))});
        }
    }

    private void createTable() {
        CtRuleTreeNode rootRuleNode = CtRuleCacheHelper.getRootRuleNode((AbstractFormPlugin)this);
        List ctRuleTreeNodes = rootRuleNode.mergeAllChildren();
        Map<String, String> ruleId = ctRuleTreeNodes.stream().collect(Collectors.toMap(CtRuleTreeNode::getId, CtRuleTreeNode::getName));
        if (ruleId.size() > 0) {
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
            DynamicObject[] com_wmtranrule = BusinessDataServiceHelper.load((String)"yem_com_wmtranrule", (String)"id,number,name,enable,status,yem_issys", (QFilter[])new QFilter[]{new QFilter("number", "in", ruleId.keySet())});
            List rulenumber = Arrays.stream(com_wmtranrule).map(x -> x.getString("number")).collect(Collectors.toList());
            for (DynamicObject wmtranrule : com_wmtranrule) {
                String number = wmtranrule.getString("number");
                if (wmtranrule.getString("name").equals(ruleId.get(number))) continue;
                wmtranrule.set("name", (Object)ruleId.get(number));
                saveList.add(wmtranrule);
            }
            for (String rule : ruleId.keySet()) {
                if (rulenumber.contains(rule)) continue;
                DynamicObject addNew = BusinessDataServiceHelper.newDynamicObject((String)"yem_com_wmtranrule");
                addNew.set("number", (Object)rule);
                addNew.set("name", (Object)ruleId.get(rule));
                addNew.set("status", (Object)"C");
                addNew.set("enable", (Object)"1");
                addNew.set("yem_issys", (Object)true);
                saveList.add(addNew);
            }
            if (saveList.size() > 0) {
                OperationServiceHelper.executeOperate((String)"save", (String)"yem_com_wmtranrule", (DynamicObject[])saveList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
        }
    }
}

