/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.isv.dynamic;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.SystemParamUtil;

public class FormDesignerExtFormPlugin
extends AbstractFormPlugin {
    public static final String FormId = "yem_com_wmisvappinfo";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkYemIsv();
    }

    private boolean checkYemIsv() {
        Map formmeta;
        boolean isvCheck = (Boolean)SystemParamUtil.getAppParam((String)"yem_com", (String)"yem_isvcheck");
        if (!isvCheck) {
            return false;
        }
        String id = this.getPageCache().get("id");
        Map designerMetadata = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
        if (designerMetadata != null && (formmeta = (Map)designerMetadata.get("formmeta")) != null) {
            String isv = (String)formmeta.get("Isv");
            String bizappId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
            if (StringUtils.isBlank((CharSequence)bizappId)) {
                bizappId = this.getAppIdByFormId(id);
            }
            String appNumber = AppReader.getAppNumberById((String)bizappId);
            List<String> wmIsvAppNumbers = this.getWmIsvAppNumbers();
            if ("yem".equals(isv) && wmIsvAppNumbers.contains(appNumber)) {
                this.getView().showErrorNotification(String.format("\u5f53\u524d\u8d44\u6e90\u4e3a\u3010\u5916\u8d38\u6807\u51c6\u4ea7\u54c1\u3011\u5e94\u7528\u3010%s\u3011\uff0c\u8bf7\u8fdb\u5165\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\uff0c\u5c06\u8d44\u6e90\u6269\u5c55\u540e\u518d\u8fdb\u884c\u7f16\u8f91\u3002", appNumber));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"save"});
                return true;
            }
        }
        return false;
    }

    private List<String> getWmIsvAppNumbers() {
        ArrayList<String> appNumbers = new ArrayList<String>();
        Map bills = BusinessDataServiceHelper.loadFromCache((String)FormId, (QFilter[])FormDesignerExtFormPlugin.getCommonStatusFilter().toArray());
        for (DynamicObject bill : bills.values()) {
            String appNumber = bill.getString("number");
            appNumbers.add(appNumber);
        }
        return appNumbers;
    }

    private String getAppIdByFormId(String id) {
        String sql = String.format("select fbizappid from t_meta_formdesign where fid = '%s'", id);
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            String id1 = "";
            if (rs.next()) {
                id1 = rs.getString(1);
            }
            return id1;
        });
    }

    public static QFilter getCommonStatusFilter() {
        QFilter fs = new QFilter("status", "=", (Object)"C");
        fs.and("enable", "=", (Object)"1");
        return fs;
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "save": {
                this.checkYemIsv(evt);
                break;
            }
        }
    }

    private void checkYemIsv(BeforeClickEvent evt) {
        boolean yemIsv = this.checkYemIsv();
        if (yemIsv) {
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }
}

