/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.writebackctrl.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.YEM;

public class ComWriteBackCtrlBillPlugin
extends AbstractBillPlugIn
implements Plugin,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_upassoname"});
        this.addClickListeners(new String[]{"yem_downassoname"});
        this.addClickListeners(new String[]{"yem_upverificationfid"});
        this.addClickListeners(new String[]{"yem_upreversefileid"});
        this.addClickListeners(new String[]{"yem_downreverseid"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = changeData.getRowIndex();
        switch (key) {
            case "yem_sourcebill": 
            case "yem_targetbill": {
                DynamicObject entityObj = (DynamicObject)this.getModel().getValue(key);
                if (entityObj != null) {
                    this.fillEntityCombo(entityObj.getString("number"), "yem_sourcebill".equals(key) ? "yem_upstreamentry" : "yem_downstreamentry");
                }
                model.deleteEntryData("yem_com_djfx_fxxx");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String name = c.getKey().toLowerCase();
        IDataModel model = this.getModel();
        DynamicObject sourceBill = (DynamicObject)model.getValue("yem_sourcebill");
        DynamicObject targetBill = (DynamicObject)model.getValue("yem_targetbill");
        switch (name) {
            case "yem_upassoname": {
                String upstreamentry = (String)model.getValue("yem_upstreamentry");
                this.showTargetPropForm(sourceBill, upstreamentry, name);
                break;
            }
            case "yem_downassoname": {
                String downstreamentry = (String)model.getValue("yem_downstreamentry");
                this.showTargetPropForm(targetBill, downstreamentry, name);
                break;
            }
            case "yem_upreversefileid": 
            case "yem_upverificationfid": {
                this.showEntityParam(sourceBill, name);
                break;
            }
            case "yem_downreverseid": {
                this.showEntityParam(targetBill, name);
            }
        }
    }

    private void showEntityParam(DynamicObject sourceBill, String name) {
        if (sourceBill != null) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setFormId("yem_com_reversecolsdata");
            fsp.setCustomParam("entityKey", (Object)sourceBill.getString("number"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, name));
            this.getView().showForm(fsp);
        } else {
            this.getView().showTipNotification(String.format("\u8bf7\u5148\u9009\u62e9%s\u540e\uff0c\u518d\u7ee7\u7eed\u64cd\u4f5c\u3002", "yem_upreversefileid".equals(name) ? "\u4e0a\u6e38\u6e90\u5355" : "\u4e0b\u6e38\u76ee\u6807\u5355"));
        }
    }

    private void showTargetPropForm(DynamicObject sourceBill, String upstreamentry, String name) {
        if (sourceBill != null && YEM.isNotEmpty((Object)upstreamentry)) {
            String entityName = sourceBill.getString("number");
            FormShowParameter fsp = new FormShowParameter();
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setFormId("yem_com_rbrfieldselection");
            fsp.setCustomParam("entityKey", (Object)entityName);
            fsp.setCustomParam("targetEntryKey", (Object)upstreamentry);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, name));
            this.getView().showForm(fsp);
        } else {
            this.getView().showTipNotification(String.format("\u8bf7\u5148\u9009\u62e9%s\u4ee5\u53ca\u5bf9\u5e94\u5206\u5f55\u5b9e\u4f53\uff01", "yem_upreversefileid".equals(name) ? "\u4e0a\u6e38\u6e90\u5355" : "\u4e0b\u6e38\u76ee\u6807\u5355"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection returnData = (DynamicObjectCollection)e.getReturnData();
        IDataModel model = this.getModel();
        switch (actionId) {
            case "yem_upassoname": 
            case "yem_downassoname": {
                if (returnData == null) break;
                for (DynamicObject returnDatum : returnData) {
                    if ("yem_upassoname".equals(actionId)) {
                        model.setValue("yem_upassoname", (Object)returnDatum.getString("yem_name"));
                        model.setValue("yem_upassociatedid", (Object)returnDatum.getString("yem_number"));
                        continue;
                    }
                    model.setValue("yem_downassoname", (Object)returnDatum.getString("yem_name"));
                    model.setValue("yem_downassociatedid", (Object)returnDatum.getString("yem_number"));
                }
                break;
            }
            case "yem_upreversefileid": 
            case "yem_downreverseid": 
            case "yem_upverificationfid": {
                int rowIndex = model.getEntryCurrentRowIndex("yem_com_djfx_fxxx");
                if (returnData == null) break;
                for (DynamicObject returnDatum : returnData) {
                    if ("yem_upreversefileid".equals(actionId)) {
                        model.setValue("yem_upreversefileid", (Object)returnDatum.getString("yem_col"), rowIndex);
                        model.setValue("yem_upreversefilename", (Object)returnDatum.getString("yem_colno"), rowIndex);
                        continue;
                    }
                    if ("yem_downreverseid".equals(actionId)) {
                        model.setValue("yem_downreverseid", (Object)returnDatum.getString("yem_col"), rowIndex);
                        model.setValue("yem_downreversename", (Object)returnDatum.getString("yem_colno"), rowIndex);
                        continue;
                    }
                    model.setValue("yem_upverificationfid", (Object)returnDatum.getString("yem_col"), rowIndex);
                    model.setValue("yem_upverificationfield", (Object)returnDatum.getString("yem_colno"), rowIndex);
                }
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        String entityNumber;
        super.beforeBindData(e);
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue("yem_sourcebill");
        DynamicObject targetbill = (DynamicObject)this.getModel().getValue("yem_targetbill");
        if (entityObj != null) {
            entityNumber = entityObj.getString("number");
            this.fillEntityCombo(entityNumber, "yem_upstreamentry");
        }
        if (targetbill != null) {
            entityNumber = targetbill.getString("number");
            this.fillEntityCombo(entityNumber, "yem_downstreamentry");
        }
    }

    private void fillEntityCombo(String entityNumber, String propName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List<ComboItem> entryItems = this.buildEntryComboItems(mainType, propName);
        ComboEdit entryEditor = (ComboEdit)this.getView().getControl(propName);
        entryEditor.setComboItems(entryItems);
    }

    private List<ComboItem> buildEntryComboItems(MainEntityType mainType, String entryKey) {
        ArrayList<ComboItem> entryItems = new ArrayList<ComboItem>();
        String currLCId = Lang.get().toString();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        entryItems.add(blankItem);
        if (mainType != null) {
            Map entitys = mainType.getAllEntities();
            ComboItem headItem = new ComboItem();
            headItem.setValue(mainType.getName());
            headItem.setCaption(new LocaleString(currLCId, "\u5355\u636e\u5934"));
            entryItems.add(headItem);
            for (EntityType entity : entitys.values()) {
                if (entity instanceof LinkEntryType || !(entity instanceof EntryType)) continue;
                ComboItem entryItem = new ComboItem();
                entryItem.setValue(entity.getName());
                entryItem.setCaption(entity.getDisplayName());
                entryItems.add(entryItem);
            }
        }
        return entryItems;
    }
}

