/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.writebackctrl.form;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import yem.base.common.utils.YEM;

public class ReverseColsFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        String entityNumber = (String)showParameter.getCustomParam("entityKey");
        model.deleteEntryData("yem_entryentity");
        if (YEM.isNotEmpty((Object)entityNumber)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ArrayList<IDataEntityType> entryTypes = new ArrayList<IDataEntityType>();
            for (IDataEntityProperty property : mainType.getProperties()) {
                if (!(property instanceof EntryProp) || property instanceof LinkEntryProp) continue;
                entryTypes.add(((EntryProp)property).getItemType());
            }
            this.createBigDecimalPropData((IDataEntityType)mainType, model);
            for (IDataEntityType entryType : entryTypes) {
                this.createBigDecimalPropData(entryType, model);
            }
        }
    }

    private void createBigDecimalPropData(IDataEntityType subType, IDataModel model) {
        for (IDataEntityProperty property : subType.getProperties()) {
            String number = property.getName();
            if (number.isEmpty() || number.equals("seq") || !(property instanceof DecimalProp)) continue;
            String displayName = property.getDisplayName() == null ? "" : property.getDisplayName().getLocaleValue();
            String fullnumber = number;
            String fullname = displayName;
            IDataEntityType parent = property.getParent();
            if (parent instanceof SubEntryType) {
                IDataEntityType grandParent = parent.getParent();
                fullnumber = grandParent.getName() + "." + parent.getName() + "." + number;
                fullname = grandParent.getDisplayName().getLocaleValue() + "." + parent.getDisplayName().getLocaleValue() + "." + displayName;
            } else if (parent instanceof EntryType) {
                fullnumber = parent.getName() + "." + number;
                fullname = parent.getDisplayName().getLocaleValue() + "." + displayName;
            }
            int index = model.createNewEntryRow("yem_entryentity");
            model.setValue("yem_col", (Object)fullname, index);
            model.setValue("yem_colno", (Object)fullnumber, index);
            model.setValue("yem_checkbox", (Object)false, index);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.clickBtnOK();
                break;
            }
        }
    }

    private void clickBtnOK() {
        IFormView view = this.getView();
        EntryGrid entry = (EntryGrid)view.getControl("yem_entryentity");
        int[] selectRowIndexs = entry.getSelectRows();
        if (selectRowIndexs.length > 0) {
            DynamicObjectCollection selectRows = new DynamicObjectCollection();
            for (int i : selectRowIndexs) {
                selectRows.add((Object)this.getModel().getEntryRowEntity("yem_entryentity", i));
            }
            view.returnDataToParent((Object)selectRows);
            view.close();
        } else {
            view.showTipNotification("\u672a\u9009\u62e9\u6570\u636e\u3002");
        }
    }
}

