/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.writebackctrl.op;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.jetbrains.annotations.NotNull;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;

public class ComReverseValidator
extends AbstractValidator {
    /*
     * Could not resolve type clashes
     */
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            String operateKey = this.getOperateKey();
            if ("delete".equals(operateKey)) continue;
            DynamicObject billData = dataEntity.getDataEntity();
            String thisBillKey = billData.getDataEntityType().getName();
            billData = BusinessDataServiceHelper.loadSingle((Object)billData.getPkValue(), (String)thisBillKey);
            long thisBillId = billData.getLong("id");
            DynamicObject[] writeBackCtrls = ComReverseValidator.getWriteBackCtrl(thisBillKey, "yem_targetbill", null);
            ArrayList<String> errMsgs = new ArrayList<String>();
            for (DynamicObject reverseCtrl : writeBackCtrls) {
                String yemUpassociatedid;
                String yemUpstreamentry;
                DynamicObject yemSourcebill = reverseCtrl.getDynamicObject("yem_sourcebill");
                if (yemSourcebill == null) continue;
                String yemDownstreamentry = reverseCtrl.getString("yem_downstreamentry");
                String yemDownassociatedid = reverseCtrl.getString("yem_downassociatedid");
                HashMap<String, Map<String, BigDecimal>> conectData = new HashMap<String, Map<String, BigDecimal>>();
                DynamicObjectCollection yemComDjfxFxxx = reverseCtrl.getDynamicObjectCollection("yem_com_djfx_fxxx");
                Set reverseProp = yemComDjfxFxxx.stream().filter(s -> YEM.isNotEmpty((Object)s.getString("yem_upreversefilename"))).map(s -> s.getString("yem_upreversefilename")).collect(Collectors.toSet());
                Set<Object> thisBillFilterValue = this.totalThisBillValidInfo(thisBillKey, yemDownstreamentry, billData, yemDownassociatedid, yemComDjfxFxxx, conectData, "yem_downreversename");
                String sourceBillKey = yemSourcebill.getString("number");
                DynamicObject[] sourceBillData = this.getBillData(sourceBillKey, yemUpstreamentry = reverseCtrl.getString("yem_upstreamentry"), yemUpassociatedid = reverseCtrl.getString("yem_upassociatedid"), thisBillFilterValue, null);
                if (!YEM.isNotEmpty((Object)sourceBillData)) continue;
                QFilter reFilter = new QFilter("yem_com_djfx_fxxx.yem_upreversefilename", "in", reverseProp);
                DynamicObject[] sourceBillCtrls = ComReverseValidator.getWriteBackCtrl(yemSourcebill.getString("number"), "yem_sourcebill", reFilter);
                HashMap<String, HashMap<String, Map<String, BigDecimal>>> difSourceTotalData = new HashMap<String, HashMap<String, Map<String, BigDecimal>>>();
                HashMap sourceFilterData = new HashMap();
                for (DynamicObject sourceBillCtrl : sourceBillCtrls) {
                    HashMap<String, Map<String, BigDecimal>> totalSourceData = new HashMap<String, Map<String, BigDecimal>>();
                    String upstreamentry = sourceBillCtrl.getString("yem_upstreamentry");
                    String upassociatedid = sourceBillCtrl.getString("yem_upassociatedid");
                    DynamicObjectCollection collection = sourceBillCtrl.getDynamicObjectCollection("yem_com_djfx_fxxx");
                    DynamicObject yemTargetbill = sourceBillCtrl.getDynamicObject("yem_targetbill");
                    String tarBillKey = yemTargetbill.getString("number");
                    HashSet<Object> sourceFilterValues = new HashSet<Object>();
                    for (DynamicObject sourceBillDatum : sourceBillData) {
                        Set<Object> sourceFilterValue = this.totalThisBillValidInfo(sourceBillDatum.getDynamicObjectType().getName(), upstreamentry, sourceBillDatum, upassociatedid, collection, totalSourceData, "yem_verificationfield");
                        sourceFilterValues.addAll(sourceFilterValue);
                    }
                    sourceFilterData.put(tarBillKey, sourceFilterValues);
                    difSourceTotalData.put(tarBillKey, totalSourceData);
                }
                HashMap<String, HashMap<String, Map<String, BigDecimal>>> difTargetTotalData = new HashMap<String, HashMap<String, Map<String, BigDecimal>>>();
                for (DynamicObject sourceBillCtrl : sourceBillCtrls) {
                    DynamicObject yemTargetbill = sourceBillCtrl.getDynamicObject("yem_targetbill");
                    String tarBillKey = yemTargetbill.getString("number");
                    String downstreamentry = sourceBillCtrl.getString("yem_downstreamentry");
                    String downassociatedid = sourceBillCtrl.getString("yem_downassociatedid");
                    DynamicObjectCollection collection = sourceBillCtrl.getDynamicObjectCollection("yem_com_djfx_fxxx");
                    QFilter tarFilter = null;
                    if (thisBillKey.equals(tarBillKey) && YEM.isNotEmpty((Object)thisBillId)) {
                        tarFilter = new QFilter("id", "!=", (Object)thisBillId);
                    }
                    HashMap<String, Map<String, BigDecimal>> tarSourceData = new HashMap<String, Map<String, BigDecimal>>();
                    DynamicObject[] targetBillDatas = this.getBillData(tarBillKey, downstreamentry, downassociatedid, (Set)sourceFilterData.get(tarBillKey), tarFilter);
                    for (DynamicObject targetBillData : targetBillDatas) {
                        this.totalThisBillValidInfo(targetBillData.getDynamicObjectType().getName(), downstreamentry, targetBillData, downassociatedid, collection, tarSourceData, "yem_downreversename");
                    }
                    if (thisBillKey.equals(tarBillKey)) {
                        for (Map.Entry stringMapEntry : tarSourceData.entrySet()) {
                            String key = (String)stringMapEntry.getKey();
                            Map value = (Map)stringMapEntry.getValue();
                            Map stringBigDecimalMap = (Map)conectData.get(key);
                            for (Map.Entry stringBigDecimalEntry : value.entrySet()) {
                                String entryKey = (String)stringBigDecimalEntry.getKey();
                                BigDecimal decimal = (BigDecimal)stringBigDecimalEntry.getValue();
                                BigDecimal bigDecimal = (BigDecimal)stringBigDecimalMap.get(entryKey);
                                value.put(entryKey, bigDecimal.add(decimal));
                            }
                        }
                    }
                    difTargetTotalData.put(tarBillKey, tarSourceData);
                }
                for (Map.Entry stringMapEntry : difSourceTotalData.entrySet()) {
                    String key = (String)stringMapEntry.getKey();
                    Map value = (Map)stringMapEntry.getValue();
                    Map thisValue = (Map)difTargetTotalData.get(key);
                    for (Map.Entry mapEntry : value.entrySet()) {
                        String tarKey = (String)mapEntry.getKey();
                        Map stringBigDecimalMap = (Map)thisValue.get(tarKey);
                        Map tarValue = (Map)mapEntry.getValue();
                        for (Map.Entry stringBigDecimalEntry : tarValue.entrySet()) {
                            String entryKey = (String)stringBigDecimalEntry.getKey();
                            BigDecimal decimal = (BigDecimal)stringBigDecimalEntry.getValue();
                            BigDecimal bigDecimal = (BigDecimal)stringBigDecimalMap.get(entryKey);
                            if (bigDecimal.compareTo(decimal) >= 0) continue;
                            BigDecimal errTarDecimal = decimal.setScale(3, RoundingMode.HALF_UP);
                            BigDecimal errThisDecimal = bigDecimal.setScale(3, RoundingMode.HALF_UP);
                            errMsgs.add(String.format("\u6e90\u5355\u5bf9\u5e94\u7684\u6570\u91cf\uff1a%s\uff0c\u8d85\u8fc7\u9700\u6c42\u5df2\u6267\u884c\u6570\u91cf\uff1a%s", errTarDecimal, errThisDecimal));
                        }
                    }
                }
            }
            if (!YEM.isNotEmpty(errMsgs)) continue;
            this.addMessage(dataEntity, String.join((CharSequence)"\r\n", errMsgs));
            return;
        }
    }

    private DynamicObject[] getBillData(String sourceBillKey, String yemUpstreamentry, String yemUpassociatedid, Set<Object> thisBillFilterValue, QFilter filter) {
        String selectfieldsFast = sourceBillKey.equals(yemUpstreamentry) ? DynamicObjectUtil.getSelectfieldsFast((String)sourceBillKey, (String[])new String[0]) : DynamicObjectUtil.getSelectfieldsFast((String)sourceBillKey, (String[])new String[]{yemUpstreamentry});
        QFilter sourceFilter = new QFilter(yemUpassociatedid, "in", thisBillFilterValue);
        if (filter != null) {
            sourceFilter.and(filter);
        }
        return BusinessDataServiceHelper.load((String)sourceBillKey, (String)selectfieldsFast, (QFilter[])sourceFilter.toArray());
    }

    @NotNull
    private Set<Object> totalThisBillValidInfo(String entityName, String yemDownstreamentry, DynamicObject billData, String yemDownassociatedid, DynamicObjectCollection yemComDjfxFxxx, Map<String, Map<String, BigDecimal>> conectData, String reverseName) {
        Set<Object> collected;
        if (!entityName.equals(yemDownstreamentry)) {
            DynamicObjectCollection collection = billData.getDynamicObjectCollection(yemDownstreamentry);
            String associationKey = this.getTruePropKey(yemDownassociatedid);
            collected = collection.stream().map(s -> s.get(associationKey)).collect(Collectors.toSet());
            for (DynamicObject comDjfxFxxx : yemComDjfxFxxx) {
                String yemDownreversename = comDjfxFxxx.getString(reverseName);
                String propKey = this.getTruePropKey(yemDownreversename);
                Map<String, BigDecimal> collect = collection.stream().collect(Collectors.toMap(s1 -> s1.get(associationKey).toString(), s2 -> new BigDecimal(s2.get(propKey).toString())));
                conectData.put(yemDownassociatedid, collect);
            }
        } else {
            Object tarValue = billData.get(yemDownassociatedid);
            collected = Collections.singleton(new HashSet<Object>().add(tarValue));
            for (DynamicObject comDjfxFxxx : yemComDjfxFxxx) {
                String yemDownreversename = comDjfxFxxx.getString(reverseName);
                HashMap<String, BigDecimal> collect = new HashMap<String, BigDecimal>();
                collect.put(tarValue.toString(), new BigDecimal(billData.get(yemDownreversename).toString()));
                conectData.put(yemDownassociatedid, collect);
            }
        }
        return collected;
    }

    private String getTruePropKey(String fullPropKey) {
        String[] split = fullPropKey.split("\\.");
        return split[split.length - 1];
    }

    protected static DynamicObject[] getWriteBackCtrl(String name, String type, QFilter otherFilter) {
        QFilter filter = new QFilter(type + ".number", "=", (Object)name);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        if (otherFilter != null) {
            filter.and(otherFilter);
        }
        String selectfieldsFast = DynamicObjectUtil.getSelectfieldsFast((String)"yem_com_writebackctrl", (String[])new String[]{"yem_com_djfx_fxxx"});
        return BusinessDataServiceHelper.load((String)name, (String)selectfieldsFast, (QFilter[])filter.toArray());
    }
}

