/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ocr.intel.voicedata.bill;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;
import yem.wm.ocr.common.VoiceOcrUtil;

public class FileUploadBillPlugin
extends AbstractBillPlugIn
implements ProgresssListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("yem_progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
        EntryGrid grid = (EntryGrid)this.getControl("yem_entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initProgress();
    }

    public void onProgress(ProgressEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String status = (String)model.getValue("yem_billstatus");
        if ("B".equals(status)) {
            Date submitdate = (Date)model.getValue("yem_submitdate");
            int percentInt = VoiceOcrUtil.getPercentInt((Date)new Date(), (Date)submitdate);
            evt.setProgress(percentInt);
        } else {
            ProgressBar progressBar = (ProgressBar)view.getControl("yem_progressbarap");
            progressBar.stop();
        }
        view.invokeOperation("refresh");
    }

    private void initProgress() {
        IDataModel model = this.getModel();
        String status = (String)model.getValue("yem_billstatus");
        ProgressBar progressBar = (ProgressBar)this.getControl("yem_progressbarap");
        if ("B".equals(status)) {
            Date now = new Date();
            Date submitdate = (Date)model.getValue("yem_submitdate");
            BigDecimal passSeconds = VoiceOcrUtil.getPassSeconds((Date)now, (Date)submitdate);
            boolean overTime = passSeconds.compareTo(VoiceOcrUtil.overSeconds) > 0;
            boolean finish = true;
            DynamicObjectCollection entry = model.getEntryEntity("yem_entryentity");
            for (DynamicObject row : entry) {
                String rowStatus = row.getString("yem_status");
                if (!"B".equals(rowStatus)) continue;
                if (overTime) {
                    row.set("yem_status", (Object)"E");
                    continue;
                }
                finish = false;
            }
            if (finish) {
                progressBar.stop();
                model.setValue("yem_billstatus", (Object)(overTime ? "E" : "C"));
                this.getView().invokeOperation("save", YEM.getOptionNoMsg());
            } else {
                int percentInt = VoiceOcrUtil.getPercentInt((Date)now, (Date)submitdate);
                progressBar.setPercent(percentInt);
                progressBar.start();
            }
        } else {
            progressBar.stop();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyclick) {
        String name = hyclick.getFieldName();
        int rowindex = hyclick.getRowIndex();
        switch (name) {
            case "yem_status": {
                IDataModel model = this.getModel();
                long pkId = (Long)model.getValue("yem_ocrdataid", rowindex);
                if (pkId <= 0L) break;
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("yem_ocr_voicedata");
                showParameter.setPkId((Object)pkId);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (operateKey) {
                case "pdfsplitpic": {
                    this.pdfSplit2Pic();
                    break;
                }
                case "submitocr": {
                    this.submitOcr();
                    this.initProgress();
                    break;
                }
            }
        }
    }

    private void submitOcr() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("yem_entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length > 0) {
            DynamicObject dataEntity = model.getDataEntity(true);
            boolean submit = false;
            ArrayList<String> msg = new ArrayList<String>();
            for (int selectRow : selectRows) {
                DynamicObject row = model.getEntryRowEntity("yem_entryentity", selectRow);
                String status = row.getString("yem_status");
                if (!"B".equals(status) && !"C".equals(status)) {
                    DynamicObject bill;
                    long ocrDataId = row.getLong("yem_ocrdataid");
                    if (ocrDataId > 0L) {
                        bill = BusinessDataServiceHelper.loadSingle((Object)ocrDataId, (String)"yem_ocr_voicedata");
                    } else {
                        bill = BusinessDataServiceHelper.newDynamicObject((String)"yem_ocr_voicedata");
                        bill.set("yem_creater", (Object)UserServiceHelper.getCurrentUser((String)"name"));
                        bill.set("yem_src", (Object)"B");
                        bill.set("yem_srcid", dataEntity.getPkValue());
                    }
                    bill.set("yem_picturefield", row.get("yem_picturefield"));
                    OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"yem_ocr_voicedata", (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)YEM.getOption());
                    if (result.isSuccess()) {
                        List successPkIds = result.getSuccessPkIds();
                        if (successPkIds.isEmpty()) continue;
                        model.setValue("yem_ocrdataid", successPkIds.get(0), selectRow);
                        model.setValue("yem_status", (Object)"B", selectRow);
                        submit = true;
                        continue;
                    }
                    msg.add(String.format("\u7b2c%s\u884c\u9644\u4ef6\u63d0\u4ea4\u8bc6\u522b\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", selectRow + 1, YEM.getOpMsg((OperationResult)result)));
                    continue;
                }
                msg.add(String.format("\u7b2c%s\u884c\u9644\u4ef6\u72b6\u6001\u4e3a\u8bc6\u522b\u4e2d\u6216\u8bc6\u522b\u5b8c\u6210\uff0c\u65e0\u6cd5\u518d\u6b21\u63d0\u4ea4\u8bc6\u522b\u3002", selectRow + 1));
            }
            if (!msg.isEmpty()) {
                view.showTipNotification(String.join((CharSequence)"\r\n", msg));
            }
            if (submit) {
                model.setValue("yem_billstatus", (Object)"B");
                model.setValue("yem_submitdate", (Object)new Date());
            }
            view.invokeOperation("save", YEM.getOptionNoMsg());
            view.invokeOperation("refresh");
        } else {
            view.showTipNotification("\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002");
        }
    }

    private void pdfSplit2Pic() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        OperationResult result = view.invokeOperation("save", YEM.getOptionNoMsg());
        if (result.isSuccess()) {
            DynamicObject dataEntity = model.getDataEntity(true);
            Object pkValue = dataEntity.getPkValue();
            String selectFields = DynamicObjectUtil.getSelectfieldsFast((String)"bos_attachment", (String[])new String[0]);
            String billKey = "yem_ocr_fileupload";
            QFilter qFilterID = new QFilter("FInterID", "=", (Object)String.valueOf(pkValue));
            QFilter qFilterBillKey = new QFilter("fbilltype", "=", (Object)billKey);
            QFilter qFilterSrcPanel = new QFilter("fattachmentpanel", "=", (Object)"yem_srcattachmentpanel");
            QFilter qFilterPicPanel = new QFilter("fattachmentpanel", "=", (Object)"yem_picattachmentpanel");
            DynamicObject[] atts = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectFields, (QFilter[])new QFilter[]{qFilterID, qFilterBillKey, qFilterSrcPanel});
            int delAtts = DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{qFilterID, qFilterBillKey, qFilterPicPanel});
            model.deleteEntryData("yem_entryentity");
            if (atts.length == 0) {
                view.showMessage("\u672a\u67e5\u8be2\u5230\u9644\u4ef6\u3002");
            } else {
                block9: for (DynamicObject att : atts) {
                    String fileName = att.getString("FAttachmentName");
                    String extName = att.getString("FExtName");
                    String fileId = att.getString("ffileid");
                    switch (extName) {
                        case "pdf": 
                        case ".pdf": {
                            try {
                                FileService service = FileServiceFactory.getAttachmentFileService();
                                InputStream inputStream = service.getInputStream(fileId);
                                List newAtts = VoiceOcrUtil.pdf2Image((DynamicObject)att, (String)billKey, (Object)pkValue, (String)"yem_picattachmentpanel", (InputStream)inputStream);
                                SaveServiceHelper.save((DynamicObject[])newAtts.toArray(new DynamicObject[0]));
                                for (DynamicObject newAtt : newAtts) {
                                    this.addEntryOcrData(newAtt, true, "");
                                }
                                continue block9;
                            }
                            catch (IOException ex) {
                                String msg = String.format("\u9644\u4ef6\u3010%s\u3011\u8f6c\u6362\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", fileName, YEM.exceptionToStr((Exception)ex));
                                this.addEntryOcrData(att, false, msg);
                                continue block9;
                            }
                        }
                        default: {
                            this.copy2AttPanel(att, billKey, pkValue, "yem_picattachmentpanel");
                            this.addEntryOcrData(att, true, "");
                        }
                    }
                }
                view.invokeOperation("save", YEM.getOptionNoMsg());
                view.invokeOperation("refresh");
            }
        } else {
            view.showMessage("\u81ea\u52a8\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + YEM.getOpMsg((OperationResult)result));
        }
    }

    private void addEntryOcrData(DynamicObject newAtt, boolean success, String msg) {
        IDataModel model = this.getModel();
        int index = model.createNewEntryRow("yem_entryentity");
        model.setValue("yem_status", (Object)(success ? "A" : "Z"), index);
        model.setValue("yem_convertresult", (Object)(success ? "\u8f6c\u6362\u6210\u529f" : "\u8f6c\u6362\u5931\u8d25"), index);
        model.setValue("yem_convertresult_tag", (Object)msg, index);
        model.setValue("yem_filename", newAtt.get("FAttachmentName"), index);
        model.setValue("yem_picturefield", newAtt.get("ffileid"), index);
        model.setValue("yem_fileid", newAtt.get("ffileid"), index);
    }

    private void copy2AttPanel(DynamicObject att, String billKey, Object billId, String attachmentKey) {
        DynamicObject bos_attachment = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)att, (DynamicObject)bos_attachment);
        Date today = new Date();
        long attId = ORM.create().genLongId("bos_attachment");
        bos_attachment.set("id", (Object)attId);
        bos_attachment.set("FNUMBER", (Object)("rc-upload-" + attId));
        bos_attachment.set("FBillType", (Object)billKey);
        bos_attachment.set("FInterID", billId);
        bos_attachment.set("FModifyTime", (Object)today);
        bos_attachment.set("fcreatetime", (Object)today);
        bos_attachment.set("fattachmentpanel", (Object)attachmentKey);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bos_attachment});
    }
}

