/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ocr.intel.voicedata.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;

public class JsonBillViewEdit
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData(false);
    }

    private void initData(boolean dataChanged) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String jsonStr = (String)model.getValue("yem_json_tag");
        String prettyTag = this.getPrettyTag(jsonStr);
        CodeEdit codeEdit = (CodeEdit)view.getControl("yem_sourceedit");
        codeEdit.setText(prettyTag);
        model.deleteEntryData("yem_treeentryentity");
        try {
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            this.createTreeRow(jsonObject, new EntryIndex(0, -1, -1));
        }
        catch (Exception e) {
            int index = model.createNewEntryRow("yem_treeentryentity");
            model.setValue("yem_fieldkey", (Object)"json", index);
            model.setValue("yem_fieldvalue_tag", (Object)prettyTag, index);
        }
        model.setDataChanged(dataChanged);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("yem_treeentryentity");
        treeEntryGrid.setCollapse(false);
    }

    private void createTreeRow(JSONObject jsonObject, EntryIndex ei) {
        IDataModel model = this.getModel();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                JSONObject jsonObj = (JSONObject)value;
                ei.currIndex = ei.level == 0 ? model.createNewEntryRow("yem_treeentryentity") : model.insertEntryRow("yem_treeentryentity", ei.currIndex);
                model.setValue("yem_fieldkey", (Object)key, ei.currIndex);
                model.setValue("yem_valuetype", (Object)value.getClass().getSimpleName(), ei.currIndex);
                this.createTreeRow(jsonObj, new EntryIndex(ei.level + 1, ei.currIndex, ei.currIndex));
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                ei.currIndex = ei.level == 0 ? model.createNewEntryRow("yem_treeentryentity") : model.insertEntryRow("yem_treeentryentity", ei.currIndex);
                model.setValue("yem_fieldkey", (Object)key, ei.currIndex);
                model.setValue("yem_valuetype", (Object)value.getClass().getSimpleName(), ei.currIndex);
                if (jsonArray.isEmpty()) continue;
                this.createTreeRow(jsonArray.getJSONObject(0), new EntryIndex(ei.level + 1, ei.currIndex, ei.currIndex));
                continue;
            }
            ei.currIndex = ei.level == 0 ? model.createNewEntryRow("yem_treeentryentity") : model.insertEntryRow("yem_treeentryentity", ei.insertIndex);
            model.setValue("yem_fieldkey", (Object)key, ei.currIndex);
            if (value != null) {
                model.setValue("yem_fieldvalue", value, ei.currIndex);
                model.setValue("yem_fieldvalue_tag", value, ei.currIndex);
                model.setValue("yem_valuetype", (Object)value.getClass().getSimpleName(), ei.currIndex);
                continue;
            }
            model.setValue("yem_valuetype", (Object)"null", ei.currIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "yem_json_tag": {
                this.initData(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "pdfsplitpic": {
                this.pdfSplit2Pic();
                break;
            }
        }
    }

    private void pdfSplit2Pic() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        OperationResult result = view.invokeOperation("save", YEM.getOptionNoMsg());
        if (result.isSuccess()) {
            DynamicObject dataEntity = model.getDataEntity(true);
            Object pkValue = dataEntity.getPkValue();
            String selectFields = DynamicObjectUtil.getSelectfieldsFast((String)"bos_attachment", (String[])new String[0]);
            QFilter qFilterID = new QFilter("FInterID", "=", (Object)String.valueOf(pkValue));
            QFilter qFilterBillKey = new QFilter("fbilltype", "=", (Object)"yem_jsonbillview");
            QFilter qFilterPanel = new QFilter("fattachmentpanel", "=", (Object)"yem_picattachmentpanel");
            DynamicObject[] atts = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectFields, (QFilter[])new QFilter[]{qFilterID, qFilterBillKey});
            int delAtts = DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{qFilterID, qFilterBillKey, qFilterPanel});
            if (atts.length == 0) {
                view.showMessage("\u672a\u67e5\u8be2\u5230\u9644\u4ef6\u3002");
            } else {
                DynamicObject att = atts[0];
                String fileId = att.getString("ffileid");
                try {
                    FileService service = FileServiceFactory.getAttachmentFileService();
                    InputStream inputStream = service.getInputStream(fileId);
                    JsonBillViewEdit.splitPdf2Images("yem_jsonbillview", pkValue, "yem_picattachmentpanel", inputStream);
                }
                catch (IOException ex) {
                    view.showMessage("\u9644\u4ef6\u8f6c\u6362\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + YEM.exceptionToStr((Exception)ex));
                }
                view.invokeOperation("refresh");
            }
        } else {
            view.showMessage("\u81ea\u52a8\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + YEM.getOpMsg((OperationResult)result));
        }
    }

    public static void splitPdf2Images(String billKey, Object billId, String attachmentKey, InputStream input) throws IOException {
        try (PDDocument document = PDDocument.load((InputStream)input);){
            PDFRenderer renderer = new PDFRenderer(document);
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage bufferedImage = renderer.renderImageWithDPI(i, 300.0f);
                String fileName = String.format("page_%s.png", i + 1);
                ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteOutputStream);
                ByteArrayInputStream byteInputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                int available = byteInputStream.available();
                String path = "/" + fileName;
                FileService service = FileServiceFactory.getAttachmentFileService();
                FileItem fileItem = new FileItem(fileName, path, (InputStream)byteInputStream);
                fileItem.setCreateNewFileWhenExists(true);
                String fileId = service.upload(fileItem);
                JsonBillViewEdit.saveAttachment(billKey, billId, attachmentKey, fileName, fileId, available);
            }
        }
    }

    public static void splitPdf2Pages(String billKey, Object billId, String attachmentKey, InputStream input) throws IOException {
        try (PDDocument document = PDDocument.load((InputStream)input);){
            int totalPages = document.getNumberOfPages();
            for (int i = 0; i < totalPages; ++i) {
                PDDocument singlePageDoc = new PDDocument();
                singlePageDoc.addPage(document.getPage(i));
                String fileName = String.format("page_%s.pdf", i + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                singlePageDoc.save((OutputStream)byteArrayOutputStream);
                ByteArrayInputStream byteInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                int available = byteInputStream.available();
                String path = "/" + fileName;
                FileService service = FileServiceFactory.getAttachmentFileService();
                FileItem fileItem = new FileItem(fileName, path, (InputStream)byteInputStream);
                fileItem.setCreateNewFileWhenExists(true);
                String fileId = service.upload(fileItem);
                JsonBillViewEdit.saveAttachment(billKey, billId, attachmentKey, fileName, fileId, available);
                singlePageDoc.close();
            }
        }
    }

    private static void saveAttachment(String billKey, Object billId, String attachmentKey, String fileName, String fileId, int available) throws UnsupportedEncodingException {
        DynamicObject bos_attachment = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        Date today = new Date();
        long attId = ORM.create().genLongId("bos_attachment");
        String extName = (fileName = URLDecoder.decode(fileName, "utf-8")) != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
        bos_attachment.set("id", (Object)attId);
        bos_attachment.set("FNUMBER", (Object)("rc-upload-" + attId));
        bos_attachment.set("FBillType", (Object)billKey);
        bos_attachment.set("FInterID", billId);
        bos_attachment.set("FModifyTime", (Object)today);
        bos_attachment.set("fcreatetime", (Object)today);
        bos_attachment.set("FaliasFileName", (Object)fileName);
        bos_attachment.set("FAttachmentName", (Object)fileName);
        bos_attachment.set("FExtName", (Object)extName);
        bos_attachment.set("FATTACHMENTSIZE", (Object)available);
        bos_attachment.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
        bos_attachment.set("fattachmentpanel", (Object)attachmentKey);
        bos_attachment.set("fdescription", (Object)"");
        bos_attachment.set("FFileId", (Object)fileId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bos_attachment});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getPrettyTag(String encryptData) {
        String str;
        block11: {
            block10: {
                Object obj = null;
                try {
                    if (encryptData != null) {
                        if (encryptData.startsWith("{")) {
                            obj = JSONObject.parseObject((String)encryptData, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
                        } else if (encryptData.startsWith("[")) {
                            obj = JSONObject.parseArray((String)encryptData);
                        }
                    }
                    if (obj == null) break block10;
                }
                catch (Exception exception) {
                    str = obj != null ? JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}) : this.s(encryptData);
                    catch (Throwable throwable) {
                        if (obj != null) {
                            str = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
                        } else {
                            str = this.s(encryptData);
                        }
                        throw throwable;
                    }
                }
                str = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
                break block11;
            }
            str = this.s(encryptData);
        }
        return this.subStringAndConcatTip(str);
    }

    private String subStringAndConcatTip(String param) {
        if (YEM.isNotEmpty((Object)param) && param.length() > 102400) {
            param = param.substring(0, 102400);
            StringBuilder sb = new StringBuilder();
            sb.append(param).append("\n\n\n\n\u8bf7\u6ce8\u610f\uff1a\u56e0\u5185\u5bb9\u592a\u957f\uff0c\u540e\u7eed\u90e8\u5206\u88ab\u81ea\u52a8\u622a\u65ad\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53bb\u540e\u53f0\u67e5\u770b...");
            return sb.toString();
        }
        return param;
    }

    private String s(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    static class EntryIndex {
        int level;
        int currIndex;
        int insertIndex;

        public EntryIndex(int level, int currIndex, int insertIndex) {
            this.level = level;
            this.currIndex = currIndex;
            this.insertIndex = insertIndex;
        }
    }
}

