/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ocr.intel.voicedata.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.Markdown;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.de.service.ServiceFactory;
import yem.base.common.utils.YEM;
import yem.wm.ocr.common.VoiceOcrUtil;
import yem.wm.ocr.intel.recognize.service.IOCRExtPlugIn;
import yem.wm.ocr.intel.voicedata.utils.VoiceDataUtils;

public class VoiceDataBillPlugin
extends AbstractBillPlugIn
implements ProgresssListener,
UploadListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("yem_progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
        this.addItemClickListeners(new String[]{"yem_toolbarap"});
        Button upload = (Button)this.getControl("yem_upload");
        upload.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getShowParameter();
    }

    private void getShowParameter() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        Map data = fsp.getCustomParams();
        Map params = (Map)data.get("params");
        if (params != null) {
            if (params.containsKey("yem_recognize")) {
                DynamicObject yem_recognize = BusinessDataServiceHelper.loadSingle(params.get("yem_recognize"), (String)"yem_ocr_recognize");
                model.setValue("yem_recognize", (Object)yem_recognize);
                view.updateView("yem_recognize");
                model.setValue("yem_customplugin", (Object)yem_recognize.getString("yem_customplugin"));
                view.updateView("yem_recognize");
                model.setValue("yem_associated", params.get("fromid"));
                view.updateView("yem_associated");
                view.setEnable(Boolean.valueOf(false), new String[]{"yem_recognize", "yem_associated"});
                if (yem_recognize != null) {
                    model.setValue("yem_idbatch", (Object)yem_recognize.getBoolean("yem_idbatch"));
                    view.updateView("yem_idbatch");
                }
            }
            if (params.containsKey("ShowType")) {
                String ShowType2 = params.get("ShowType").toString();
                if ("list".equals(ShowType2)) {
                    model.setValue("yem_src", (Object)"D");
                    view.updateView("yem_src");
                } else {
                    model.setValue("yem_src", (Object)"C");
                    view.updateView("yem_src");
                }
            }
            if (params.containsKey("fromid")) {
                model.setValue("yem_srcfromid", params.get("fromid"));
                view.updateView("yem_srcfromid");
            }
            if (params.containsKey("id")) {
                model.setValue("yem_srcid", params.get("id"));
                view.updateView("yem_srcid");
            }
        }
    }

    public void afterBindData(EventObject e) {
        String yem_status;
        super.afterBindData(e);
        this.initData();
        IFormView view = this.getView();
        String yem_src = (String)this.getModel().getValue("yem_src");
        if ("A".equals(yem_src) || "B".equals(yem_src)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"yem_returndata"});
        }
        if ("A".equals(yem_status = (String)this.getModel().getValue("yem_status")) || "B".equals(yem_status)) {
            view.setEnable(Boolean.valueOf(false), new String[]{"yem_identification"});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initProgress();
    }

    private void initData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String jsonStr = (String)model.getValue("yem_json_tag");
        String markdownStr = (String)model.getValue("yem_markdown_tag");
        String prettyTag = this.getPrettyTag(jsonStr);
        CodeEdit codeEdit = (CodeEdit)view.getControl("yem_sourceedit");
        codeEdit.setText(prettyTag);
        Markdown markdown = (Markdown)view.getControl("yem_markdownap");
        markdown.setText(markdownStr);
    }

    public void onProgress(ProgressEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String status = (String)model.getValue("yem_status");
        if ("B".equals(status)) {
            Date submitdate = (Date)model.getValue("yem_submitdate");
            int percentInt = VoiceOcrUtil.getPercentInt((Date)new Date(), (Date)submitdate);
            evt.setProgress(percentInt);
        } else {
            ProgressBar progressBar = (ProgressBar)view.getControl("yem_progressbarap");
            progressBar.stop();
        }
        view.invokeOperation("refresh");
    }

    private void initProgress() {
        IDataModel model = this.getModel();
        String status = (String)model.getValue("yem_status");
        ProgressBar progressBar = (ProgressBar)this.getControl("yem_progressbarap");
        if ("B".equals(status)) {
            Date now = new Date();
            Date submitdate = (Date)model.getValue("yem_submitdate");
            BigDecimal passSeconds = VoiceOcrUtil.getPassSeconds((Date)now, (Date)submitdate);
            if (passSeconds.compareTo(VoiceOcrUtil.overSeconds) > 0) {
                progressBar.stop();
                model.setValue("yem_status", (Object)"E");
                this.getView().invokeOperation("save", YEM.getOptionNoMsg());
            } else {
                int percentInt = VoiceOcrUtil.getPercentInt((Date)now, (Date)submitdate);
                progressBar.setPercent(percentInt);
                progressBar.start();
            }
        } else {
            progressBar.stop();
        }
    }

    private void createJsonTree(String jsonStr) {
        IDataModel model = this.getModel();
        model.deleteEntryData("yem_treeentryentity");
        try {
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            this.createTreeRow(jsonObject, new EntryIndex(0, -1, -1));
        }
        catch (Exception e) {
            int index = model.createNewEntryRow("yem_treeentryentity");
            model.setValue("yem_fieldkey", (Object)"json", index);
            model.setValue("yem_fieldvalue_tag", (Object)jsonStr, index);
        }
        model.setDataChanged(false);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("yem_treeentryentity");
        treeEntryGrid.setCollapse(false);
    }

    private void createTreeRow(JSONObject jsonObject, EntryIndex ei) {
        IDataModel model = this.getModel();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                JSONObject jsonObj = (JSONObject)value;
                ei.currIndex = ei.level == 0 ? model.createNewEntryRow("yem_treeentryentity") : model.insertEntryRow("yem_treeentryentity", ei.currIndex);
                model.setValue("yem_fieldkey", (Object)key, ei.currIndex);
                model.setValue("yem_valuetype", (Object)value.getClass().getSimpleName(), ei.currIndex);
                this.createTreeRow(jsonObj, new EntryIndex(ei.level + 1, ei.currIndex, ei.currIndex));
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                ei.currIndex = ei.level == 0 ? model.createNewEntryRow("yem_treeentryentity") : model.insertEntryRow("yem_treeentryentity", ei.currIndex);
                model.setValue("yem_fieldkey", (Object)key, ei.currIndex);
                model.setValue("yem_valuetype", (Object)value.getClass().getSimpleName(), ei.currIndex);
                if (jsonArray.isEmpty()) continue;
                this.createTreeRow(jsonArray.getJSONObject(0), new EntryIndex(ei.level + 1, ei.currIndex, ei.currIndex));
                continue;
            }
            ei.currIndex = ei.level == 0 ? model.createNewEntryRow("yem_treeentryentity") : model.insertEntryRow("yem_treeentryentity", ei.insertIndex);
            model.setValue("yem_fieldkey", (Object)key, ei.currIndex);
            if (value != null) {
                model.setValue("yem_fieldvalue", value, ei.currIndex);
                model.setValue("yem_fieldvalue_tag", value, ei.currIndex);
                model.setValue("yem_valuetype", (Object)value.getClass().getSimpleName(), ei.currIndex);
                continue;
            }
            model.setValue("yem_valuetype", (Object)"null", ei.currIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        switch (key = e.getProperty().getName()) {
            case "yem_json_tag": 
            case "yem_markdown_tag": {
                this.initData();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "yem_test": {
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        switch (operateKey) {
            case "identification": 
            case "submit": 
            case "submit_ocr": 
            case "submit_markdown": 
            case "submit_pdf": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.initProgress();
                break;
            }
            case "voicedata_m": {
                int rowInd = this.getModel().getEntryCurrentRowIndex("yem_tree");
                Boolean physical = (Boolean)this.getModel().getValue("yem_physical", rowInd);
                if (!physical.booleanValue()) {
                    this.fieldSelect();
                    break;
                }
                view.showErrorNotification("\u5f53\u524d\u884c\u4e3a\u5b9e\u4f53\u884c\uff0c\u65e0\u6cd5\u7f16\u8f91\uff01");
                break;
            }
            case "voicedata_c": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("yem_tree");
                Boolean yem_physical = (Boolean)this.getModel().getValue("yem_physical", rowIndex);
                if (!yem_physical.booleanValue()) {
                    this.getModel().setValue("yem_actualvalue", (Object)"", rowIndex);
                    break;
                }
                view.showErrorNotification("\u5f53\u524d\u884c\u4e3a\u5b9e\u4f53\u884c\uff0c\u65e0\u6cd5\u6e05\u7a7a\uff01");
                break;
            }
            case "returndata": {
                String yem_status = dataEntity.getString("yem_status");
                if (!"C".equals(yem_status)) {
                    view.showErrorNotification("\u5f53\u524d\u5355\u636e\u672a\u8bc6\u522b\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                    break;
                }
                String yem_src = (String)this.getModel().getValue("yem_src");
                if ("A".equals(yem_src) || "B".equals(yem_src)) {
                    view.showErrorNotification("\u624b\u5de5\u65b0\u589e\u7684\u8bc6\u522b\u8bb0\u5f55\uff0c\u65e0\u6cd5\u8fd4\u56de\u6570\u636e\uff01");
                    break;
                }
                if ("C".equals(yem_src)) {
                    this.returnData(e);
                    view.showSuccessNotification("\u64cd\u4f5c\u6210\u529f");
                    break;
                }
                if (!"D".equals(yem_src)) break;
                this.returnDataList(e);
                view.showSuccessNotification("\u64cd\u4f5c\u6210\u529f");
                break;
            }
        }
    }

    private void returnData(AfterDoOperationEventArgs e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String yem_customplugin = dataEntity.getString("yem_customplugin");
        HashMap<Long, String> mapHead = new HashMap<Long, String>();
        HashMap<Long, String> mapentry = new HashMap<Long, String>();
        HashMap<Long, Integer> mapRow = new HashMap<Long, Integer>();
        String pageId = VoiceDataUtils.getPageId(this.getView());
        if (yem_customplugin.length() > 0) {
            IOCRExtPlugIn service = (IOCRExtPlugIn)ServiceFactory.getService((String)yem_customplugin);
            service.setModelValue(view, model, pageId, dataEntity);
        } else {
            DynamicObjectCollection yem_tree = dataEntity.getDynamicObjectCollection("yem_tree");
            if (pageId != null) {
                IFormView pageview = view.getView(pageId);
                IDataModel pageModel = pageview.getModel();
                for (DynamicObject tree : yem_tree) {
                    long id = tree.getLong("id");
                    long pid = tree.getLong("pid");
                    boolean yem_physical = tree.getBoolean("yem_physical");
                    String yem_valueentity = tree.getString("yem_valueentity");
                    String yem_valuefiledtype = tree.getString("yem_valuefiledtype");
                    if (!yem_physical) continue;
                    if ("A".equals(yem_valuefiledtype)) {
                        mapHead.put(id, yem_valueentity);
                        continue;
                    }
                    if ("B".equals(yem_valuefiledtype)) {
                        mapentry.put(id, yem_valueentity);
                        pageModel.deleteEntryData(yem_valueentity);
                        continue;
                    }
                    if (!"entry".equals(yem_valuefiledtype)) continue;
                    int row = pageModel.createNewEntryRow((String)mapentry.get(pid));
                    mapRow.put(id, row);
                }
                pageModel.setValue("yem_voicedataid", dataEntity.getPkValue());
                pageModel.setValue("yem_voicedatafrom", (Object)dataEntity.getDynamicObjectType().getName());
                pageModel.setValue("yem_voicedatano", (Object)dataEntity.getString("billno"));
                for (DynamicObject tree : yem_tree) {
                    String getentryvalue;
                    long pid = tree.getLong("pid");
                    boolean yem_physical = tree.getBoolean("yem_physical");
                    String yem_valueentity = tree.getString("yem_valueentity");
                    String yem_valuefiledtype = tree.getString("yem_valuefiledtype");
                    String yem_actualvalue = tree.getString("yem_actualvalue");
                    String yem_identifierbasic = tree.getString("yem_identifierbasic");
                    String yem_valueypename = tree.getString("yem_valueypename");
                    String yem_defaultvalue = tree.getString("yem_defaultvalue");
                    if (!yem_physical && mapHead.containsKey(pid)) {
                        VoiceDataUtils.setBillDynamicobject(dataEntity.getString("yem_associated.number"), pageModel, yem_valuefiledtype, yem_valueentity, yem_actualvalue, yem_identifierbasic, yem_valueypename, yem_defaultvalue);
                        continue;
                    }
                    if (yem_physical || !mapRow.containsKey(pid) || (getentryvalue = this.getentryvalue(yem_tree, pid)).length() <= 0) continue;
                    VoiceDataUtils.setBillDynamicobject(dataEntity.getString("yem_associated.number"), getentryvalue, pageModel, yem_valuefiledtype, yem_valueentity, yem_actualvalue, yem_identifierbasic, yem_valueypename, yem_defaultvalue, (Integer)mapRow.get(pid));
                }
                view.sendFormAction(pageview);
            } else {
                view.showErrorNotification("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7236\u9875\u9762\uff0c\u8fd4\u56de\u6570\u636e\u5931\u8d25\uff01");
            }
        }
    }

    private void returnDataList(AfterDoOperationEventArgs e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        boolean yem_idbatch = dataEntity.getBoolean("yem_idbatch");
        DynamicObject yem_recognize = dataEntity.getDynamicObject("yem_recognize");
        String yem_formid = yem_recognize.getString("yem_formid.number");
        long yemSrcid = dataEntity.getLong("yem_srcid");
        String yem_customplugin = dataEntity.getString("yem_customplugin");
        HashMap<Long, String> mapHead = new HashMap<Long, String>();
        HashMap<Long, String> mapentry = new HashMap<Long, String>();
        HashMap<Long, DynamicObject> mapRow = new HashMap<Long, DynamicObject>();
        if (yem_customplugin.length() > 0) {
            IOCRExtPlugIn service = (IOCRExtPlugIn)ServiceFactory.getService((String)yem_customplugin);
            service.setDateValue(view, dataEntity);
        } else {
            DynamicObjectCollection yem_tree = dataEntity.getDynamicObjectCollection("yem_tree");
            for (DynamicObject tree : yem_tree) {
                long id = tree.getLong("id");
                boolean yem_physical = tree.getBoolean("yem_physical");
                String yem_valueentity = tree.getString("yem_valueentity");
                String yem_valuefiledtype = tree.getString("yem_valuefiledtype");
                if (!yem_physical) continue;
                if ("A".equals(yem_valuefiledtype)) {
                    mapHead.put(id, yem_valueentity);
                    continue;
                }
                if ("B".equals(yem_valuefiledtype)) {
                    mapentry.put(id, yem_valueentity);
                    continue;
                }
                if (!"entry".equals(yem_valuefiledtype)) continue;
                mapRow.put(id, new DynamicObject());
            }
            if (yem_idbatch) {
                for (Iterator key : mapRow.keySet()) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)yem_formid);
                    dynamicObject.set("yem_voicedataid", dataEntity.getPkValue());
                    dynamicObject.set("yem_voicedatafrom", (Object)dataEntity.getDynamicObjectType().getName());
                    dynamicObject.set("yem_voicedatano", (Object)dataEntity.getString("billno"));
                    for (DynamicObject tree : yem_tree) {
                        long pid = tree.getLong("pid");
                        boolean yem_physical = tree.getBoolean("yem_physical");
                        String yem_valueentity = tree.getString("yem_valueentity");
                        String yem_valuefiledtype = tree.getString("yem_valuefiledtype");
                        String yem_actualvalue = tree.getString("yem_actualvalue");
                        String yem_identifierbasic = tree.getString("yem_identifierbasic");
                        String yem_valueypename = tree.getString("yem_valueypename");
                        String yem_defaultvalue = tree.getString("yem_defaultvalue");
                        if (pid != (Long)((Object)key) || yem_physical) continue;
                        VoiceDataUtils.setDynamicobject(dynamicObject, "", yem_valuefiledtype, yem_valueentity, yem_actualvalue, yem_identifierbasic, yem_valueypename, yem_defaultvalue);
                    }
                    OperationResult Operate = OperationServiceHelper.executeOperate((String)"save", (String)dynamicObject.getDynamicObjectType().getName(), (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
                    if (Operate.isSuccess()) continue;
                    String opMsg = YEM.getOpMsg((OperationResult)Operate);
                    view.showErrorNotification(opMsg);
                    return;
                }
            } else {
                String yem_valuefiledtype;
                String yem_valueentity;
                DynamicObject dynamicObject = null;
                if (yemSrcid > 0L) {
                    dynamicObject = BusinessDataServiceHelper.loadSingle((Object)yemSrcid, (String)dataEntity.getString("yem_srcfromid"));
                    for (Long key : mapentry.keySet()) {
                        dynamicObject.getDynamicObjectCollection((String)mapentry.get(key)).clear();
                    }
                } else {
                    dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)yem_formid);
                }
                for (DynamicObject tree : yem_tree) {
                    long id = tree.getLong("id");
                    boolean yem_physical = tree.getBoolean("yem_physical");
                    yem_valueentity = tree.getString("yem_valueentity");
                    yem_valuefiledtype = tree.getString("yem_valuefiledtype");
                    if (!"entry".equals(yem_valuefiledtype)) continue;
                    DynamicObject valueentitydynamicObject = dynamicObject.getDynamicObjectCollection(yem_valueentity).addNew();
                    mapRow.put(id, valueentitydynamicObject);
                }
                dynamicObject.set("yem_voicedataid", dataEntity.getPkValue());
                dynamicObject.set("yem_voicedatafrom", (Object)dataEntity.getDynamicObjectType().getName());
                dynamicObject.set("yem_voicedatano", (Object)dataEntity.getString("billno"));
                for (DynamicObject tree : yem_tree) {
                    String getentryvalue;
                    long pid = tree.getLong("pid");
                    boolean yem_physical = tree.getBoolean("yem_physical");
                    yem_valueentity = tree.getString("yem_valueentity");
                    yem_valuefiledtype = tree.getString("yem_valuefiledtype");
                    String yem_actualvalue = tree.getString("yem_actualvalue");
                    String yem_identifierbasic = tree.getString("yem_identifierbasic");
                    String yem_valueypename = tree.getString("yem_valueypename");
                    String yem_defaultvalue = tree.getString("yem_defaultvalue");
                    if (!yem_physical && mapHead.containsKey(pid)) {
                        VoiceDataUtils.setDynamicobject(dynamicObject, "", yem_valuefiledtype, yem_valueentity, yem_actualvalue, yem_identifierbasic, yem_valueypename, yem_defaultvalue);
                        continue;
                    }
                    if (yem_physical || !mapRow.containsKey(pid) || (getentryvalue = this.getentryvalue(yem_tree, pid)).length() <= 0) continue;
                    VoiceDataUtils.setDynamicobject((DynamicObject)mapRow.get(pid), getentryvalue, yem_valuefiledtype, yem_valueentity, yem_actualvalue, yem_identifierbasic, yem_valueypename, yem_defaultvalue);
                }
                OperationResult Operate = OperationServiceHelper.executeOperate((String)"save", (String)dynamicObject.getDynamicObjectType().getName(), (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
                if (!Operate.isSuccess()) {
                    String opMsg = YEM.getOpMsg((OperationResult)Operate);
                    view.showErrorNotification(opMsg);
                    return;
                }
            }
        }
    }

    public void upload(UploadEvent evt) {
        String callbackKey = evt.getCallbackKey();
        if ("yem_upload".equals(callbackKey)) {
            Object[] urls = evt.getUrls();
            Object[] names = evt.getNames();
            if (urls.length > 0) {
                String extName;
                String url = (String)urls[0];
                String name = (String)names[0];
                switch (extName = YEM.substringAfterLast((String)name, (String)".")) {
                    case "pdf": {
                        try {
                            String fileName = YEM.substringBeforeLast((String)name, (String)".") + ".png";
                            FileService service = FileServiceFactory.getAttachmentFileService();
                            InputStream inputStream = service.getInputStream(url);
                            ByteArrayInputStream byteArrayInputStream = VoiceOcrUtil.pdf2Image((InputStream)inputStream);
                            String path = "/" + fileName;
                            Date today = new Date();
                            SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
                            String NewDateStr = df.format(today);
                            String attachmentPath = "/" + RequestContext.get().getTenantId() + "/" + RequestContext.get().getAccountId() + "/" + NewDateStr + "/attachments/" + fileName;
                            FileItem fileItem = new FileItem(fileName, attachmentPath, (InputStream)byteArrayInputStream);
                            fileItem.setCreateNewFileWhenExists(true);
                            String fileId = service.upload(fileItem);
                            this.getModel().setValue("yem_picturefield", (Object)fileId);
                        }
                        catch (IOException e) {
                            this.getView().showErrorNotification("pdf\u8f6c\u6362\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + YEM.exceptionToStr((Exception)e));
                        }
                        break;
                    }
                    default: {
                        this.getModel().setValue("yem_picturefield", (Object)url);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getPrettyTag(String encryptData) {
        String str;
        block11: {
            block10: {
                Object obj = null;
                try {
                    if (encryptData != null) {
                        if (encryptData.startsWith("{")) {
                            obj = JSONObject.parseObject((String)encryptData, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
                        } else if (encryptData.startsWith("[")) {
                            obj = JSONObject.parseArray((String)encryptData);
                        }
                    }
                    if (obj == null) break block10;
                }
                catch (Exception exception) {
                    str = obj != null ? JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}) : this.s(encryptData);
                    catch (Throwable throwable) {
                        if (obj != null) {
                            str = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
                        } else {
                            str = this.s(encryptData);
                        }
                        throw throwable;
                    }
                }
                str = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
                break block11;
            }
            str = this.s(encryptData);
        }
        return this.subStringAndConcatTip(str);
    }

    private String subStringAndConcatTip(String param) {
        if (YEM.isNotEmpty((Object)param) && param.length() > 102400) {
            param = param.substring(0, 102400);
            StringBuilder sb = new StringBuilder();
            sb.append(param).append("\n\n\n\n\u8bf7\u6ce8\u610f\uff1a\u56e0\u5185\u5bb9\u592a\u957f\uff0c\u540e\u7eed\u90e8\u5206\u88ab\u81ea\u52a8\u622a\u65ad\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53bb\u540e\u53f0\u67e5\u770b...");
            return sb.toString();
        }
        return param;
    }

    private String s(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    private void fieldSelect() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("yem_tree");
        DynamicObjectCollection yem_tree = dataEntity.getDynamicObjectCollection("yem_tree");
        if (yem_tree.size() >= rowIndex) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            DynamicObject tree = (DynamicObject)yem_tree.get(rowIndex);
            String yem_valuefiledtype = tree.getString("yem_valuefiledtype");
            String yem_valueypename = tree.getString("yem_valueypename");
            String yem_actualvalue = tree.getString("yem_actualvalue");
            customParams.put("yem_valuefiledtype", yem_valuefiledtype);
            customParams.put("yem_actualvalue", yem_actualvalue);
            if ("basedata".equals(yem_valuefiledtype) || "org".equals(yem_valuefiledtype)) {
                if ("org".equals(yem_valuefiledtype)) {
                    yem_valueypename = "bos_org";
                }
                customParams.put("yem_valueypename", yem_valueypename);
                this.showForm(customParams, "yem_ocr_baseselectedit", yem_valuefiledtype);
            } else if ("datetime".equals(yem_valuefiledtype) || "date".equals(yem_valuefiledtype)) {
                this.showForm(customParams, "yem_ocr_dateselect", yem_valuefiledtype);
            } else if ("enum".equals(yem_valuefiledtype)) {
                customParams.put("formId", dataEntity.getString("yem_associated.number"));
                customParams.put("yem_valueentity", tree.getString("yem_valueentity"));
                this.showForm(customParams, "yem_ocr_enumselectedit", yem_valuefiledtype);
            } else {
                this.showForm(customParams, "yem_ocr_textselectedit", yem_valuefiledtype);
            }
        }
    }

    private void showForm(Map<String, Object> customParams, String formId, String actionId) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParams(customParams);
        fsp.setFormId(formId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        view.showForm(fsp);
    }

    private void showFormList(Map<String, Object> customParams, String formId, String actionId) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ListShowParameter lsp = new ListShowParameter();
        lsp.setMultiSelect(true);
        lsp.setParentPageId(view.getPageId());
        lsp.setStatus(OperationStatus.VIEW);
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setLookUp(true);
        StyleCss css = new StyleCss();
        css.setHeight("580");
        css.setWidth("960");
        lsp.getOpenStyle().setInlineStyleCss(css);
        lsp.setBillFormId(formId);
        lsp.setFormId("bos_listf7");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        lsp.setCustomParams(customParams);
        ListFilterParameter lfp = new ListFilterParameter();
        view.showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        Object returnData = e.getReturnData();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("yem_tree");
        if (returnData != null) {
            if ("basedata".equals(key)) {
                Map map = (Map)returnData;
                if (map.containsKey("returnData")) {
                    model.setValue("yem_actualvalue", map.get("returnData"), rowIndex);
                }
                if (map.containsKey("yem_fieldattribute")) {
                    model.setValue("yem_identifierbasic", map.get("yem_fieldattribute"), rowIndex);
                }
            } else {
                model.setValue("yem_actualvalue", returnData, rowIndex);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        Map data = fsp.getCustomParams();
        IFormView parentView = view.getParentView();
        String yem_src = (String)this.getModel().getValue("yem_src");
        if (data.containsKey("params") && parentView != null && "C".equals(yem_src)) {
            Map params = (Map)data.get("params");
            Object id = params.get("id");
            if (parentView != null) {
                parentView.close();
                view.sendFormAction(parentView);
            }
        }
    }

    public String getentryvalue(DynamicObjectCollection yem_tree, long pid) {
        Long l;
        String value = "";
        HashMap<Long, String> mapentry = new HashMap<Long, String>();
        HashMap<Long, Long> mapRow = new HashMap<Long, Long>();
        for (DynamicObject tree : yem_tree) {
            long id = tree.getLong("id");
            long fid = tree.getLong("pid");
            String yem_valueentity = tree.getString("yem_valueentity");
            String yem_valuefiledtype = tree.getString("yem_valuefiledtype");
            if ("B".equals(yem_valuefiledtype)) {
                mapentry.put(id, yem_valueentity);
                continue;
            }
            if (!"entry".equals(yem_valuefiledtype)) continue;
            mapRow.put(id, fid);
        }
        if (mapRow.containsKey(pid) && mapentry.containsKey(l = (Long)mapRow.get(pid))) {
            value = (String)mapentry.get(l);
        }
        return value;
    }

    static class EntryIndex {
        int level;
        int currIndex;
        int insertIndex;

        public EntryIndex(int level, int currIndex, int insertIndex) {
            this.level = level;
            this.currIndex = currIndex;
            this.insertIndex = insertIndex;
        }
    }
}

