/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ocr.intel.voicedata.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;
import yem.wm.customs.common.utils.HttpHelper;
import yem.wm.ocr.intel.voicedata.utils.VoiceHttpHelpUtils;

public class VoiceOcrAlbabaTask
extends AbstractTask
implements Plugin {
    private static final String ocrUrl = "https://mid.wmyun.com/admin-api/system/ocr/";
    private static final String deepseekocrUrl = "https://mid.wmyun.com/admin-api/system/DeepSeekocr/";
    private static final String loginUrl = "https://mid.wmyun.com/admin-api/system/auth/login";
    private static final String username = "yemocr";
    private static final String password = "zbWB0aB^tjaSeak(";
    private static final String mag = "";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object pkId = map.get("pkId");
        String formid = (String)map.get("formid");
        HashMap<String, String> extNamemap = new HashMap<String, String>();
        extNamemap.put("bmp", "image/bmp");
        extNamemap.put("jpg", "image/jpeg");
        extNamemap.put("jpe", "image/jpeg");
        extNamemap.put("jpeg", "image/jpeg");
        extNamemap.put("png", "image/png");
        extNamemap.put("tif", "image/tiff");
        extNamemap.put("tiff", "image/tiff");
        extNamemap.put("webp", "image/webp");
        extNamemap.put("heic", "image/heic");
        if (YEM.isNotEmpty((Object)pkId)) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"yem_ocr_voicedata");
            String pictureUrl = bill.getString("yem_picturefield");
            try {
                String token = VoiceHttpHelpUtils.login(bill);
                if (YEM.isEmpty((Object)token)) {
                    this.setResult(bill, false, "token\u83b7\u53d6\u4e3a\u7a7a");
                } else {
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("Authorization", "Bearer " + token);
                    FileService service = FileServiceFactory.getAttachmentFileService();
                    String fileId = pictureUrl.contains("\\") || pictureUrl.contains("/") ? pictureUrl : (pictureUrl.contains(".") ? YEM.substringBeforeLast((String)pictureUrl, (String)".") : pictureUrl);
                    FileServiceExt fileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
                    String realPath = fileServiceExt.getRealPath(fileId);
                    String extName = realPath.substring(realPath.lastIndexOf(46) + 1);
                    String string = extName = YEM.isEmpty((Object)extName) ? "jpg" : extName;
                    if (!extNamemap.containsKey(extName)) {
                        this.setResult(bill, false, "\u5f53\u524d\u56fe\u7247\u683c\u5f0f\u4e0d\u652f\u6301\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\uff01");
                        return;
                    }
                    bill.set("yem_extname", (Object)extName);
                    InputStream inputStream = service.getInputStream(fileId);
                    String base64 = VoiceOcrAlbabaTask.inputStreamToBase64(inputStream);
                    JSONObject object = new JSONObject();
                    object.put("base64", (Object)("data:" + (String)extNamemap.get(extName) + ";base64," + base64));
                    object.put("msg", (Object)(map.get("yem_json").toString() + "\n" + map.get("yem_remark").toString()));
                    String params = object.toString();
                    String ocrResult = HttpHelper.httpPost((String)"https://mid.wmyun.com/admin-api/system/DeepSeekocr/yemalibabaocr", header, (String)params);
                    JSONObject resultObj = JSONObject.parseObject((String)ocrResult);
                    String code = resultObj.getString("code");
                    if ("0".equals(code)) {
                        DynamicObject yem_recognize;
                        String jsonStr = resultObj.getString("data");
                        bill.set("yem_json_tag", (Object)jsonStr);
                        this.setBill(bill, jsonStr);
                        if (bill != null && (yem_recognize = bill.getDynamicObject("yem_recognize")) != null) {
                            yem_recognize = BusinessDataServiceHelper.loadSingle((Object)yem_recognize.getPkValue(), (String)yem_recognize.getDynamicObjectType().getName());
                            bill = this.setTree(yem_recognize, bill, jsonStr);
                        }
                        Date submitdate = bill.getDate("yem_submitdate");
                        Date finishdate = new Date();
                        bill.set("yem_finishdate", (Object)finishdate);
                        bill.set("yem_seconds", (Object)((double)(finishdate.getTime() - submitdate.getTime()) / 1000.0));
                        this.setResult(bill, true, ocrResult);
                    } else {
                        this.setResult(bill, false, ocrResult);
                    }
                }
            }
            catch (Exception e) {
                this.setResult(bill, false, "\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u539f\u56e0\uff1a\r\n" + YEM.exceptionToStr((Exception)e));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        }
    }

    private void setBill(DynamicObject bill, String jsonStr) {
        try {
            JSONObject billObj = JSONObject.parseObject((String)jsonStr);
            bill.set("yem_payee", billObj.get((Object)"\u6536\u7968\u65b9\u540d\u79f0"));
            bill.set("yem_seller", billObj.get((Object)"\u5f00\u7968\u65b9\u540d\u79f0"));
            bill.set("yem_currency", billObj.get((Object)"\u5e01\u79cd"));
            bill.set("yem_bank", billObj.get((Object)"\u94f6\u884c"));
            bill.set("yem_accountname", billObj.get((Object)"\u8d26\u6237\u540d\u79f0"));
            bill.set("yem_accountno", billObj.get((Object)"\u8d26\u6237\u53f7\u7801"));
            bill.set("yem_swiftcode", billObj.get((Object)"Swift\u4ee3\u7801"));
            BigDecimal totalAmt_s = BigDecimal.ZERO;
            BigDecimal taxRate_s = BigDecimal.ZERO;
            JSONArray jsonArray = billObj.getJSONArray("\u5546\u54c1\u8d27\u7269\u9879\u76ee\u660e\u7ec6");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("yem_entryentity");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject row = jsonArray.getJSONObject(i);
                DynamicObject addNew = entry.addNew();
                BigDecimal taxRate = BigDecimalUtils.toBigDecimal((Object)row.get((Object)"\u7a0e\u7387"));
                BigDecimal amt = BigDecimalUtils.toBigDecimal((Object)row.get((Object)"\u603b\u4ef7"));
                addNew.set("yem_qty", row.get((Object)"\u6570\u91cf"));
                addNew.set("yem_unit", row.get((Object)"\u5355\u4f4d"));
                addNew.set("yem_material", row.get((Object)"\u8d27\u7269"));
                addNew.set("yem_price", row.get((Object)"\u5355\u4ef7"));
                addNew.set("yem_taxrate", row.get((Object)"\u7a0e\u7387"));
                addNew.set("yem_taxamt", row.get((Object)"\u603b\u4ef7"));
                totalAmt_s = BigDecimalUtils.add((BigDecimal)totalAmt_s, (BigDecimal)amt, (int)2);
                if (taxRate_s.compareTo(BigDecimal.ZERO) != 0) continue;
                taxRate_s = taxRate;
            }
            String taxAmtStr = billObj.getString("\u603b\u91d1\u989d");
            String amountStr = billObj.getString("\u4e0d\u542b\u7a0e\u91d1\u989d");
            String taxStr = billObj.getString("\u7a0e\u989d");
            BigDecimal taxAmt = BigDecimalUtils.toBigDecimal((Object)taxAmtStr);
            BigDecimal amount = BigDecimalUtils.toBigDecimal((Object)amountStr);
            BigDecimal tax = BigDecimalUtils.toBigDecimal((Object)taxStr);
            if (taxAmt.compareTo(BigDecimal.ZERO) == 0) {
                taxAmt = totalAmt_s;
                bill.set("yem_totaltaxamt", (Object)taxAmt);
            } else {
                bill.set("yem_totaltaxamt", (Object)taxAmtStr);
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal rate = BigDecimalUtils.div((BigDecimal)taxRate_s, (BigDecimal)new BigDecimal("100"), (int)10).add(BigDecimal.ONE);
                amount = BigDecimalUtils.div((BigDecimal)taxAmt, (BigDecimal)rate, (int)2);
                bill.set("yem_totalamt", (Object)amount);
            } else {
                bill.set("yem_totalamt", (Object)amountStr);
            }
            if (tax.compareTo(BigDecimal.ZERO) == 0 && taxAmt.compareTo(BigDecimal.ZERO) > 0) {
                tax = BigDecimalUtils.sub((BigDecimal)taxAmt, (BigDecimal)amount, (int)2);
                bill.set("yem_totaltax", (Object)tax);
            } else {
                bill.set("yem_totaltax", (Object)taxStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setResult(DynamicObject bill, boolean success, String msg) {
        String status = success ? "C" : "D";
        bill.set("yem_status", (Object)status);
        bill.set("yem_apiresult", (Object)(success ? "\u8bf7\u6c42\u6210\u529f\u3002" : "\u8bf7\u6c42\u5931\u8d25\u3002"));
        bill.set("yem_apiresult_tag", (Object)msg);
        if (!bill.getString("yem_apiresult_tag").isEmpty()) {
            bill.set("yem_apiresult_tag", (Object)(bill.getString("yem_apiresult_tag") + "Json\u8bc6\u522b\u7ed3\u679c\u4e3a\uff1a\r\n" + msg));
        } else {
            bill.set("yem_apiresult_tag", (Object)msg);
        }
        String src = bill.getString("yem_src");
        if ("B".equals(src)) {
            long srcId = bill.getLong("yem_srcid");
            long pkId = bill.getLong("id");
            QFilter qFilter = new QFilter("yem_ocrdataid", "=", (Object)pkId);
            String selectFields = DynamicObjectUtil.getSelectfieldsFast((String)"yem_ocr_fileuploadentryf7", (String[])new String[0]);
            DynamicObject srcBillRow = BusinessDataServiceHelper.loadSingle((String)"yem_ocr_fileuploadentryf7", (String)selectFields, (QFilter[])qFilter.toArray());
            if (srcBillRow != null) {
                srcBillRow.set("yem_status", (Object)status);
                if ("C".equals(status)) {
                    srcBillRow.set("yem_seconds", bill.get("yem_seconds"));
                }
                SaveServiceHelper.update((DynamicObject)srcBillRow);
            }
            boolean finish = true;
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcId, (String)"yem_ocr_fileupload");
            DynamicObjectCollection entry = srcBill.getDynamicObjectCollection("yem_entryentity");
            for (DynamicObject row : entry) {
                String rowStatus = row.getString("yem_status");
                if (!"B".equals(rowStatus)) continue;
                finish = false;
            }
            if (finish) {
                srcBill.set("yem_billstatus", (Object)"C");
            }
            SaveServiceHelper.update((DynamicObject)srcBill);
        }
    }

    public DynamicObject setTree(DynamicObject yem_recognize, DynamicObject bill, String jsonStr) {
        DynamicObjectCollection yem_ocr_sbmb_strq = yem_recognize.getDynamicObjectCollection("yem_ocr_sbmb_strq");
        DynamicObjectCollection yem_tree = bill.getDynamicObjectCollection("yem_tree");
        yem_tree.clear();
        boolean yem_idbatch = bill.getBoolean("yem_idbatch");
        if (yem_idbatch) {
            JSONArray jsonArray = JSON.parseArray((String)jsonStr);
            for (DynamicObject sbmbStrq : yem_ocr_sbmb_strq) {
                boolean yem_isdelete = sbmbStrq.getBoolean("yem_isdelete");
                boolean yem_splice = sbmbStrq.getBoolean("yem_splice");
                String yem_entitytype = sbmbStrq.getString("yem_entitytype");
                String yem_identifyentityname = sbmbStrq.getString("yem_identifyentityname");
                if (yem_isdelete || !yem_splice) continue;
                DynamicObject dynamicObject = yem_tree.addNew();
                dynamicObject.set("id", (Object)ID.genLongId());
                dynamicObject.set("yem_valueentity", (Object)sbmbStrq.getString("yem_entityformid"));
                dynamicObject.set("yem_valueentityfname", (Object)sbmbStrq.getString("yem_entityformname"));
                dynamicObject.set("yem_identifyname", (Object)yem_identifyentityname);
                dynamicObject.set("yem_valuefiledtype", (Object)yem_entitytype);
                dynamicObject.set("yem_physical", (Object)true);
                DynamicObjectCollection yem_ocr_sbmb_shzd = sbmbStrq.getDynamicObjectCollection("yem_ocr_sbmb_shzd");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    DynamicObject dynamicObject1 = yem_tree.addNew();
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    dynamicObject1.set("id", (Object)ID.genLongId());
                    dynamicObject1.set("pid", dynamicObject.get("id"));
                    dynamicObject1.set("yem_valueentity", (Object)sbmbStrq.getString("yem_entityformid"));
                    dynamicObject1.set("yem_valuefiledtype", (Object)"entry");
                    dynamicObject1.set("yem_physical", (Object)true);
                    for (DynamicObject sbmbShzd : yem_ocr_sbmb_shzd) {
                        boolean yem_subisdelete = sbmbShzd.getBoolean("yem_subisdelete");
                        boolean yem_subsplice = sbmbShzd.getBoolean("yem_subsplice");
                        String yem_identifyname = sbmbShzd.getString("yem_identifyname");
                        if (yem_subisdelete || !yem_subsplice) continue;
                        DynamicObject dynamicObject2 = yem_tree.addNew();
                        dynamicObject2.set("pid", dynamicObject1.get("id"));
                        dynamicObject2.set("yem_valueentity", (Object)sbmbShzd.getString("yem_erpfiledformid"));
                        dynamicObject2.set("yem_valueentityfname", (Object)sbmbShzd.getString("yem_erpfiledformname"));
                        dynamicObject2.set("yem_identifyname", (Object)yem_identifyname);
                        dynamicObject2.set("yem_valuefiledtype", (Object)sbmbShzd.getString("yem_filedtype"));
                        dynamicObject2.set("yem_identifierbasic", (Object)sbmbShzd.getString("yem_identifierbasic"));
                        dynamicObject2.set("yem_valueypename", (Object)sbmbShzd.getString("yem_filedtypename"));
                        dynamicObject2.set("yem_physical", (Object)false);
                        dynamicObject2.set("yem_fieldvalue", jsonObject.get((Object)yem_identifyname));
                        dynamicObject2.set("yem_actualvalue", jsonObject.get((Object)yem_identifyname));
                        dynamicObject2.set("yem_defaultvalue", (Object)sbmbShzd.getString("yem_defaultvalue"));
                    }
                }
            }
        } else {
            JSONObject billObj = JSONObject.parseObject((String)jsonStr);
            for (DynamicObject sbmbStrq : yem_ocr_sbmb_strq) {
                JSONArray jsonArray;
                boolean yem_isdelete = sbmbStrq.getBoolean("yem_isdelete");
                boolean yem_splice = sbmbStrq.getBoolean("yem_splice");
                String yem_entitytype = sbmbStrq.getString("yem_entitytype");
                String yem_identifyentityname = sbmbStrq.getString("yem_identifyentityname");
                if (yem_isdelete || !yem_splice) continue;
                DynamicObject dynamicObject = yem_tree.addNew();
                dynamicObject.set("id", (Object)ID.genLongId());
                dynamicObject.set("yem_valueentity", (Object)sbmbStrq.getString("yem_entityformid"));
                dynamicObject.set("yem_valueentityfname", (Object)sbmbStrq.getString("yem_entityformname"));
                dynamicObject.set("yem_identifyname", (Object)yem_identifyentityname);
                dynamicObject.set("yem_valuefiledtype", (Object)yem_entitytype);
                dynamicObject.set("yem_physical", (Object)true);
                DynamicObjectCollection yem_ocr_sbmb_shzd = sbmbStrq.getDynamicObjectCollection("yem_ocr_sbmb_shzd");
                if ("A".equals(yem_entitytype)) {
                    for (DynamicObject sbmbShzd : yem_ocr_sbmb_shzd) {
                        boolean yem_subisdelete = sbmbShzd.getBoolean("yem_subisdelete");
                        boolean yem_subsplice = sbmbShzd.getBoolean("yem_subsplice");
                        String yem_identifyname = sbmbShzd.getString("yem_identifyname");
                        if (yem_subisdelete || !yem_subsplice) continue;
                        DynamicObject dynamicObject1 = yem_tree.addNew();
                        dynamicObject1.set("pid", dynamicObject.get("id"));
                        dynamicObject1.set("yem_valueentity", (Object)sbmbShzd.getString("yem_erpfiledformid"));
                        dynamicObject1.set("yem_valueentityfname", (Object)sbmbShzd.getString("yem_erpfiledformname"));
                        dynamicObject1.set("yem_identifyname", (Object)yem_identifyname);
                        dynamicObject1.set("yem_valuefiledtype", (Object)sbmbShzd.getString("yem_filedtype"));
                        dynamicObject1.set("yem_valueypename", (Object)sbmbShzd.getString("yem_filedtypename"));
                        dynamicObject1.set("yem_physical", (Object)false);
                        dynamicObject1.set("yem_fieldvalue", billObj.get((Object)yem_identifyname));
                        dynamicObject1.set("yem_actualvalue", billObj.get((Object)yem_identifyname));
                        dynamicObject1.set("yem_identifierbasic", (Object)sbmbShzd.getString("yem_identifierbasic"));
                        dynamicObject1.set("yem_defaultvalue", (Object)sbmbShzd.getString("yem_defaultvalue"));
                    }
                }
                if (!"B".equals(yem_entitytype) || (jsonArray = billObj.getJSONArray(yem_identifyentityname)) == null) continue;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    DynamicObject dynamicObject1 = yem_tree.addNew();
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    dynamicObject1.set("id", (Object)ID.genLongId());
                    dynamicObject1.set("pid", dynamicObject.get("id"));
                    dynamicObject1.set("yem_valueentity", (Object)sbmbStrq.getString("yem_entityformid"));
                    dynamicObject1.set("yem_valuefiledtype", (Object)"entry");
                    dynamicObject1.set("yem_physical", (Object)true);
                    for (DynamicObject sbmbShzd : yem_ocr_sbmb_shzd) {
                        boolean yem_subisdelete = sbmbShzd.getBoolean("yem_subisdelete");
                        boolean yem_subsplice = sbmbShzd.getBoolean("yem_subsplice");
                        String yem_identifyname = sbmbShzd.getString("yem_identifyname");
                        if (yem_subisdelete || !yem_subsplice) continue;
                        DynamicObject dynamicObject2 = yem_tree.addNew();
                        dynamicObject2.set("pid", dynamicObject1.get("id"));
                        dynamicObject2.set("yem_valueentity", (Object)sbmbShzd.getString("yem_erpfiledformid"));
                        dynamicObject2.set("yem_valueentityfname", (Object)sbmbShzd.getString("yem_erpfiledformname"));
                        dynamicObject2.set("yem_identifyname", (Object)yem_identifyname);
                        dynamicObject2.set("yem_valuefiledtype", (Object)sbmbShzd.getString("yem_filedtype"));
                        dynamicObject2.set("yem_identifierbasic", (Object)sbmbShzd.getString("yem_identifierbasic"));
                        dynamicObject2.set("yem_valueypename", (Object)sbmbShzd.getString("yem_filedtypename"));
                        dynamicObject2.set("yem_physical", (Object)false);
                        dynamicObject2.set("yem_fieldvalue", jsonObject.get((Object)yem_identifyname));
                        dynamicObject2.set("yem_actualvalue", jsonObject.get((Object)yem_identifyname));
                        dynamicObject2.set("yem_defaultvalue", (Object)sbmbShzd.getString("yem_defaultvalue"));
                    }
                }
            }
        }
        return bill;
    }

    public static String inputStreamToBase64(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            byte[] bytes = outputStream.toByteArray();
            String string = Base64.getEncoder().encodeToString(bytes);
            return string;
        }
    }
}

