/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.conmmon.common;

import java.math.BigDecimal;
import java.text.NumberFormat;

public class BigDecimalUtils {
    public static BigDecimal zero = new BigDecimal("0.00");
    public static BigDecimal zero_point_six = new BigDecimal("0.6");
    public static BigDecimal one = new BigDecimal("1.00");
    public static BigDecimal one_handred = new BigDecimal("100");
    public static BigDecimal one_thousand = new BigDecimal("1000");
    public static BigDecimal one_million = new BigDecimal("1000000");
    public static BigDecimal one_handred_ten = new BigDecimal("110");
    public static BigDecimal ten_thousand = new BigDecimal("10000");

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return zero;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double) {
            return new BigDecimal((Double)obj);
        }
        if (obj.toString() == null) {
            return zero;
        }
        String str = obj.toString().trim();
        if (str.toLowerCase().indexOf("e") > -1) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                return zero;
            }
        }
        if (str.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        return zero;
    }

    public static BigDecimal div(Object a, Object b, int scale) {
        if (a == null) {
            a = zero;
        }
        if (b == null) {
            return zero;
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            BigDecimal aVal = (BigDecimal)a;
            BigDecimal bVal = (BigDecimal)b;
            return aVal.divide(bVal, scale, 4);
        }
        return zero;
    }

    public static BigDecimal div(BigDecimal aVal, BigDecimal bVal, int scale) {
        if (aVal == null) {
            aVal = zero;
        }
        if (bVal == null) {
            return zero;
        }
        if (bVal.compareTo(zero) == 0) {
            return zero;
        }
        BigDecimal ret = aVal.divide(bVal, scale, 4);
        return ret;
    }

    public static BigDecimal getIntDiv(BigDecimal aVal, BigDecimal bVal) {
        if (aVal == null) {
            aVal = zero;
        }
        if (bVal == null) {
            return zero;
        }
        if (bVal.compareTo(zero) == 0) {
            return zero;
        }
        BigDecimal ret = aVal.divide(bVal, 0, 0);
        return ret;
    }

    public static BigDecimal multiply(Object a, Object b, int scale) {
        if (a == null) {
            a = zero;
        }
        if (b == null) {
            b = zero;
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            BigDecimal aVal = (BigDecimal)a;
            BigDecimal bVal = (BigDecimal)b;
            return aVal.multiply(bVal).setScale(scale, 4);
        }
        return zero;
    }

    public static BigDecimal multiply(BigDecimal aVal, BigDecimal bVal, int scale) {
        if (aVal == null) {
            aVal = zero;
        }
        if (bVal == null) {
            bVal = zero;
        }
        BigDecimal ret = aVal.multiply(bVal).setScale(scale, 4);
        return ret;
    }

    public static BigDecimal add(Object a, Object b, int scale) {
        if (a == null) {
            a = zero;
        }
        if (b == null) {
            b = zero;
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            BigDecimal aVal = (BigDecimal)a;
            BigDecimal bVal = (BigDecimal)b;
            return aVal.add(bVal).setScale(scale, 4);
        }
        return zero;
    }

    public static BigDecimal add(BigDecimal aVal, BigDecimal bVal, int scale) {
        if (aVal == null) {
            aVal = zero;
        }
        if (bVal == null) {
            bVal = zero;
        }
        BigDecimal ret = aVal.add(bVal);
        ret = ret.setScale(scale, 4);
        return ret;
    }

    public static BigDecimal sub(Object a, Object b, int scale) {
        if (a == null) {
            a = zero;
        }
        if (b == null) {
            b = zero;
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            BigDecimal aVal = (BigDecimal)a;
            BigDecimal bVal = (BigDecimal)b;
            return aVal.subtract(bVal).setScale(scale, 4);
        }
        return zero;
    }

    public static BigDecimal sub(BigDecimal aVal, BigDecimal bVal, int scale) {
        if (aVal == null) {
            aVal = zero;
        }
        if (bVal == null) {
            bVal = zero;
        }
        BigDecimal ret = aVal.subtract(bVal);
        ret = ret.setScale(scale, 4);
        return ret;
    }

    public static BigDecimal addOne(Object a, int scale) {
        return BigDecimalUtils.add(a, (Object)one, scale);
    }

    public static BigDecimal subOne(Object a, int scale) {
        return BigDecimalUtils.sub(a, (Object)one, scale);
    }

    public static String digitCapital(double n) {
        String p;
        String[] fraction = new String[]{"\u89d2", "\u5206"};
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] unit = new String[][]{{"\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String head = n < 0.0 ? "\u8d1f" : "";
        n = Math.abs(n);
        String s = "";
        BigDecimal bigDecimal = new BigDecimal(Double.valueOf(n).toString());
        String nStr = bigDecimal.toPlainString();
        String[] split = nStr.split("\\.");
        if (split.length > 1) {
            String decimalStr = split[1];
            if (decimalStr.length() > 2) {
                decimalStr = decimalStr.substring(0, 2);
            }
            Integer integer = Integer.valueOf(decimalStr);
            p = "";
            for (int i = 0; i < decimalStr.length() && i < fraction.length; ++i) {
                p = digit[integer % 10] + fraction[decimalStr.length() - i - 1] + p;
                integer = integer / 10;
            }
            s = p.replaceAll("(\u96f6.)+", "") + s;
        }
        if (s.length() < 1) {
            s = "\u6574";
        }
        int integerPart = (int)Math.floor(n);
        for (int i = 0; i < unit[0].length && integerPart > 0; ++i) {
            p = "";
            for (int j = 0; j < unit[1].length && n > 0.0; ++j) {
                p = digit[integerPart % 10] + unit[1][j] + p;
                integerPart /= 10;
            }
            s = p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6") + unit[0][i] + s;
        }
        return head + s.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceFirst("(\u96f6.)+", "").replaceAll("(\u96f6.)+", "\u96f6").replaceAll("^\u6574$", "\u96f6\u5143\u6574");
    }

    public static BigDecimal ceil(double aVal, int scale) {
        aVal = Math.ceil(aVal);
        BigDecimal aVal1 = BigDecimal.valueOf(aVal);
        aVal1 = aVal1.setScale(scale, 4);
        return aVal1;
    }

    public static BigDecimal floor(double aVal, int scale) {
        aVal = Math.floor(aVal);
        BigDecimal aVal1 = BigDecimal.valueOf(aVal);
        aVal1 = aVal1.setScale(scale, 4);
        return aVal1;
    }

    public static BigDecimal toBigDecimal(Object obj, int scale) {
        BigDecimal aVal1 = BigDecimalUtils.toBigDecimal(obj);
        aVal1 = aVal1.setScale(scale, 4);
        return aVal1;
    }

    public static String formatDouble(Object d) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(20);
        nf.setGroupingUsed(false);
        return nf.format(d);
    }
}

