/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.conmmon.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_yyyyMMdd = "yyyyMMdd";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue() + 1;
        return days;
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat(FORMAT_YMD).format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat(FORMAT_YMDHMS).parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static String formatString(Date date, String forPattern) {
        return new DateTime((Object)date).toString(DateTimeFormat.forPattern((String)forPattern));
    }

    public static int getDay(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(8));
    }

    public static int getMonth(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(5, 7));
    }

    public static int getYear(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(0, 4));
    }

    public static Map<String, Date> getWeekDate() {
        HashMap<String, Date> weekDate = new HashMap<String, Date>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        weekDate.put("beginDate", cal.getTime());
        cal.add(7, 6);
        weekDate.put("endDate", cal.getTime());
        return weekDate;
    }

    public static Date getMinMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtils.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1 != null && cal2 != null && cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameMonth(Date d1, Date d2) {
        return DateUtils.isSameDay(DateUtils.getMinMonthDate(d1), DateUtils.getMinMonthDate(d1));
    }

    public static void main(String[] args) {
        System.out.println(new LocalDate().toString(DATE_FORMATTER));
        System.out.println(DateUtils.getDataFormat(new Date(), true));
        System.out.println(DateUtils.getDataFormat(new Date(), false));
        System.out.println(DateUtils.getNextDay(new Date(), -1));
    }

    public static Date getTimesmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getTimesmorning(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getYesterdaymorning() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(DateUtils.getTimesmorning().getTime() - 86400000L);
        return cal.getTime();
    }

    public static Date getWeekFromNow() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(DateUtils.getTimesmorning().getTime() - 604800000L);
        return cal.getTime();
    }

    public static Date getTimesnight() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 24);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getTimesnight(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 24);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getTimesWeekmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getTimesWeeknight() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getTimesWeekmorning());
        cal.add(7, 7);
        return cal.getTime();
    }

    public static Date getTimesMonthmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getTimesMonthnight() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 24);
        return cal.getTime();
    }

    public static Date getNextMonthnight() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        cal.add(2, 1);
        return cal.getTime();
    }

    public static Date getCurrentQuarterEndTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getCurrentQuarterStartTime());
        cal.add(2, 3);
        return cal.getTime();
    }

    public static Date getCurrentQuarterStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        SimpleDateFormat longSdf = new SimpleDateFormat(FORMAT_YMDHMS);
        SimpleDateFormat shortSdf = new SimpleDateFormat(FORMAT_YMD);
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 4);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date formatDate(String date, String format) {
        SimpleDateFormat dt = new SimpleDateFormat(format);
        try {
            return dt.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date formatDateLocale(String date, String format) {
        SimpleDateFormat dt = new SimpleDateFormat(format, Locale.CANADA);
        try {
            return dt.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getData(Date date, String format) {
        SimpleDateFormat dt = new SimpleDateFormat(format);
        return dt.format(date);
    }

    public static String DateFormat(String timeString) {
        SimpleDateFormat sfEnd = new SimpleDateFormat(FORMAT_YMD);
        SimpleDateFormat sfStart = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
        try {
            String format = sfEnd.format(sfStart.parse(timeString));
            Date time = DateUtils.formatDate(format, FORMAT_YMD);
            timeString = DateUtils.formatString(time, FORMAT_YMD);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return timeString;
    }

    public static int getDistanceDays(Date one, Date two) {
        int days = 0;
        long time1 = one.getTime();
        long time2 = two.getTime();
        long diff = time2 - time1;
        days = (int)(diff / 86400000L);
        return days;
    }

    public static Date addDay(Date dDate, long iNbDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        cal.add(5, (int)iNbDay);
        Date result = cal.getTime();
        return result;
    }

    public static boolean isweekday(Date dDate) {
        QFilter qFilter1 = new QFilter("tpv_holidaydate", "=", (Object)dDate);
        DynamicObject tpv_holiday = BusinessDataServiceHelper.loadSingle((String)"tpv_holiday", (String)"id,billno,tpv_holidaydate", (QFilter[])new QFilter[]{qFilter1});
        return tpv_holiday != null;
    }

    public static Date getweekday(Date dDate, int addday) {
        int iNbDay = Math.abs(addday);
        for (int days = 1; days < iNbDay + 1; ++days) {
            Date weekdate = DateUtils.addDays(dDate, addday >= 0 ? days : -days);
            if (!DateUtils.isweekday(weekdate)) continue;
            ++iNbDay;
        }
        return DateUtils.addDays(dDate, addday >= 0 ? iNbDay : -iNbDay);
    }

    public static Date getCurrentFirstOfYear() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return DateUtils.getFirstOfYear(currentYear);
    }

    public static Date getCurrentLastOfYear() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return DateUtils.getLastOfYear(currentYear);
    }

    public static Date getFirstOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static Date getLastOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        return calendar.getTime();
    }
}

