/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.conmmon.common;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;
import yem.wm.conmmon.common.HttpService;

public class FileUploadService {
    private static final FileUploadService service = new FileUploadService();
    private static final String BOUNDARY = "----WebKitFormBoundaryBHp47SjGMxpHX0X6--";

    private FileUploadService() {
    }

    public static FileUploadService getService() {
        return service;
    }

    public String postFile(String url, Map<String, Object> param, File file, String accessToken) throws Exception {
        HttpPost httppost = new HttpPost(url);
        httppost.addHeader("api", "true");
        httppost.addHeader("accessToken", accessToken);
        httppost.addHeader("Content-Type", "multipart/form-data; boundary=----WebKitFormBoundaryBHp47SjGMxpHX0X6--");
        MultipartEntity entry = this.getMutipartEntry(param, file);
        httppost.setEntity((HttpEntity)entry);
        return HttpService.getService().doExecuteByHttpClient((HttpUriRequest)httppost, new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                HttpEntity entity = response.getEntity();
                String rtn = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject json = JSONObject.parseObject((String)rtn);
                String url = json.getString("url");
                return url;
            }
        });
    }

    private MultipartEntity getMutipartEntry(Map<String, Object> param, File file) throws UnsupportedEncodingException, FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, BOUNDARY, Charset.forName("UTF-8"));
        multipartEntity.addPart("file", (ContentBody)new InputStreamBody((InputStream)new FileInputStream(file), file.getName()));
        if (param != null) {
            for (String key : param.keySet()) {
                FormBodyPart field = new FormBodyPart(key, (ContentBody)new StringBody((String)param.get(key)));
                multipartEntity.addPart(field);
            }
        }
        return multipartEntity;
    }
}

