/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.conmmon.common;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;

public class GraphUtils {
    public static List<Map<String, BigDecimal>> mockData(int i) {
        ArrayList<Map<String, BigDecimal>> data = new ArrayList<Map<String, BigDecimal>>();
        Random random = new Random();
        for (int month = 1; month <= 12; ++month) {
            HashMap<String, BigDecimal> monthData = new HashMap<String, BigDecimal>();
            for (int j = 0; j < i; ++j) {
                monthData.put("\u7269\u6599" + (j + 1), BigDecimal.valueOf(random.nextInt(1000)));
            }
            data.add(monthData);
        }
        return data;
    }

    public static void handleDrawChart(PointLineChart chart, LinkedHashMap<String, Map<String, BigDecimal>> line, LinkedHashMap<String, Map<String, BigDecimal>> bar, String xName, String yName, Collection<String> xValue) {
        chart.clearData();
        GraphUtils.drawXAxis(chart, xName, xValue);
        GraphUtils.drawYAxis(chart, yName);
        GraphUtils.drawSeries(chart, line, ChartType.line);
        GraphUtils.drawSeries(chart, bar, ChartType.bar);
        chart.setLegendPropValue("right", (Object)"8%");
        chart.setLegendPropValue("top", (Object)"8%");
        chart.setMargin(Position.bottom, "50px");
        chart.setMargin(Position.top, "100px");
        chart.setMargin(Position.right, "100px");
        chart.setMargin(Position.left, "50px");
        HashMap<String, Object> textStyle = new HashMap<String, Object>();
        textStyle.put("fontSize", 16);
        textStyle.put("color", "#000000");
        chart.setLegendPropValue("textStyle", textStyle);
        chart.refresh();
    }

    public static void drawXAxis(PointLineChart chart, String name, Collection<String> xOrder) {
        Axis axis = chart.createXAxis(name, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(true));
        axisTick.put("grid", (Constable)Position.left);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Object> nametextstyle = new HashMap<String, Object>();
        nametextstyle.put("color", "#000000");
        nametextstyle.put("fontSize", 15);
        axis.setPropValue("nameTextStyle", nametextstyle);
        axis.setPropValue("nameLocation", (Object)"end");
        axis.setPropValue("position", (Object)"bottom");
        HashMap<String, String> textstyle = new HashMap<String, String>();
        textstyle.put("color", "#000000");
        textstyle.put("fontSize", "16");
        HashMap<String, HashMap<String, String>> axislabel = new HashMap<String, HashMap<String, String>>();
        axislabel.put("textStyle", textstyle);
        axis.setPropValue("axisLabel", axislabel);
        axis.setCategorys(new ArrayList<String>(xOrder));
    }

    public static void drawYAxis(PointLineChart chart, String name) {
        Axis axis = chart.createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", true);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        chart.setShowTooltip(true);
        HashMap<String, Object> yAxisnametextstyle = new HashMap<String, Object>();
        yAxisnametextstyle.put("color", "#000000");
        yAxisnametextstyle.put("fontSize", 15);
        axis.setPropValue("nameTextStyle", yAxisnametextstyle);
    }

    private static void drawSeries(PointLineChart chart, LinkedHashMap<String, Map<String, BigDecimal>> data, ChartType type) {
        Map<String, String> keyColorMap = GraphUtils.generateColorMap(data.values());
        Map<String, LinkedHashMap<String, BigDecimal>> transform = GraphUtils.transformData(data);
        for (Map.Entry<String, LinkedHashMap<String, BigDecimal>> e : transform.entrySet()) {
            String name = e.getKey();
            Map v = e.getValue();
            ArrayList<ItemValue> values = new ArrayList<ItemValue>();
            for (Map.Entry vE : v.entrySet()) {
                values.add(new ItemValue((String)vE.getKey(), (Number)v.getOrDefault(vE.getKey(), BigDecimal.ZERO), keyColorMap.get(name)));
            }
            if (ChartType.bar.equals((Object)type)) {
                BarSeries barSeries = chart.createBarSeries(name);
                barSeries.setBarWidth("16");
                barSeries.setData(values.toArray(new ItemValue[0]));
            }
            if (!ChartType.line.equals((Object)type)) continue;
            LineSeries lineSeries = chart.createLineSeries(name);
            lineSeries.setData(values.toArray(new ItemValue[0]));
        }
    }

    private static Map<String, LinkedHashMap<String, BigDecimal>> transformData(LinkedHashMap<String, Map<String, BigDecimal>> data) {
        LinkedHashMap<String, LinkedHashMap<String, BigDecimal>> transform = new LinkedHashMap<String, LinkedHashMap<String, BigDecimal>>();
        for (Map.Entry<String, Map<String, BigDecimal>> monthEntry : data.entrySet()) {
            String month = monthEntry.getKey();
            Map<String, BigDecimal> nameAmountMap = monthEntry.getValue();
            for (Map.Entry<String, BigDecimal> nameEntry : nameAmountMap.entrySet()) {
                String name = nameEntry.getKey();
                BigDecimal amount = nameEntry.getValue();
                LinkedHashMap monthAmountMap = transform.computeIfAbsent(name, k -> new LinkedHashMap());
                monthAmountMap.put(month, amount);
            }
        }
        return transform;
    }

    public static Map<String, String> generateColorMap(Collection<Map<String, BigDecimal>> data) {
        Set keys = data.stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toSet());
        List<String> colors = GraphUtils.getRandomColors(keys.size());
        HashMap<String, String> keyColorMap = new HashMap<String, String>();
        int colorIndex = 0;
        for (String key : keys) {
            keyColorMap.put(key, colors.get(colorIndex));
            ++colorIndex;
        }
        return keyColorMap;
    }

    public static List<String> getRandomColors(int size) {
        List<String> PRESET_COLORS = Arrays.asList("#60a5fa", "#ef4444", "#22c55e", "#f43f5e", "#f97316", "#22c55e", "#8b5cf6");
        if (size <= 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            result.add(PRESET_COLORS.get(i % PRESET_COLORS.size()));
        }
        return result;
    }
}

