/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.conmmon.common;

import java.util.concurrent.TimeUnit;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClientFactory {
    private static CloseableHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloseableHttpClient getHttpClient() throws InstantiationException, IllegalAccessException {
        if (httpClient != null) return httpClient;
        Class<HttpClientFactory> clazz = HttpClientFactory.class;
        synchronized (HttpClientFactory.class) {
            if (httpClient != null) return httpClient;
            httpClient = HttpClientFactory.create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClient;
        }
    }

    private static CloseableHttpClient create() {
        ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    return Long.parseLong(value) * 1000L;
                }
                return 60000L;
            }
        };
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(500);
        connectionManager.setDefaultMaxPerRoute(50);
        IdleConnectionMonitorThread thread = new IdleConnectionMonitorThread((HttpClientConnectionManager)connectionManager);
        thread.start();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy(myStrategy).setDefaultRequestConfig(RequestConfig.custom().setStaleConnectionCheckEnabled(true).build()).build();
        BasicHttpParams params = new BasicHttpParams();
        Integer CONNECTION_TIMEOUT = 2000;
        Integer SO_TIMEOUT = 2000;
        Long CONN_MANAGER_TIMEOUT = 500L;
        params.setIntParameter("http.connection.timeout", CONNECTION_TIMEOUT.intValue());
        params.setIntParameter("http.socket.timeout", SO_TIMEOUT.intValue());
        params.setLongParameter("http.conn-manager.timeout", CONN_MANAGER_TIMEOUT.longValue());
        params.setBooleanParameter("http.connection.stalecheck", true);
        return httpClient;
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

