/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lc.bill.creditrt.dynamic;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CreditCallBackFromPlugin
extends AbstractFormPlugin {
    public static final String KEY_FILED_HTH = "yem_contract";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        ((TextEdit)this.getControl(KEY_FILED_HTH)).addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getEntryEntity("yem_materialinfo").getDynamicObjectType().getProperties();
        DynamicObjectCollection entryEntity = parentModel.getEntryEntity("yem_materialinfo");
        model.setValue("yem_tradenature", parentModel.getValue("yem_tradenature"));
        model.setValue("yem_amount", parentModel.getValue("yem_amount"));
        model.setValue("yem_exrate", parentModel.getValue("yem_exrate"));
        for (int i = 0; i < entryEntity.size(); ++i) {
            int index = model.createNewEntryRow("yem_materialinfo");
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if ("id".equals(name) || "seq".equals(name)) continue;
                model.setValue(name, ((DynamicObject)entryEntity.get(i)).get(name), index);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if ("yem_contractamountsn".equals(name) && newValue != null) {
            int index = this.getModel().getEntryCurrentRowIndex("yem_materialinfo");
            BigDecimal exrate = BigDecimal.ONE;
            if (exrate != null && exrate instanceof BigDecimal) {
                exrate = (BigDecimal)model.getValue("yem_exrate");
                model.setValue("yem_contractamountsne", (Object)((BigDecimal)newValue).multiply(exrate), index);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntity = model.getEntryEntity("yem_materialinfo");
        switch (key) {
            case "btnok": {
                BigDecimal decimal = entryEntity.stream().map(x -> x.getBigDecimal("yem_contractamountsn")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                if (decimal.compareTo(dataEntity.getBigDecimal("yem_amount")) < 0) {
                    this.getView().showTipNotification("\u5408\u540c\u5360\u7528\u91d1\u989d\u5408\u8ba1\u4e0d\u5f97\u5c0f\u4e8e\u6536\u8bc1\u91d1\u989d!");
                    return;
                }
                this.btnOk();
                break;
            }
            case "yem_contract": {
                DynamicObject tradenature = dataEntity.getDynamicObject("yem_tradenature");
                if (tradenature == null) {
                    this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u8d38\u6613\u6027\u8d28!");
                    return;
                }
                this.showBillList("yem_cng_expcontract", tradenature);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (actionId.equals(KEY_FILED_HTH) && returnData != null && !returnData.isEmpty()) {
            int index = this.getModel().getEntryCurrentRowIndex("yem_materialinfo");
            Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
            DynamicObject selectedBill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"yem_cng_expcontract");
            this.getModel().setValue(KEY_FILED_HTH, (Object)returnData.get(0).getBillNo(), index);
            this.getModel().setValue("yem_ctfromcurr", (Object)selectedBill.getDynamicObject("yem_fromcurr"), index);
            this.getModel().setValue("yem_ctexrate", (Object)selectedBill.getBigDecimal("yem_exrate"), index);
            this.getModel().setValue("yem_customer", (Object)selectedBill.getDynamicObject("yem_customer"), index);
            this.getModel().setValue("yem_contractamountsn", (Object)selectedBill.getBigDecimal("yem_amounttax"), index);
            this.getModel().setValue("yem_contractamountsne", (Object)selectedBill.getBigDecimal("yem_amounttaxbase"), index);
            this.getModel().setValue("yem_constractid", (Object)selectedBill.getLong("id"), index);
        }
    }

    private void showBillList(String keyFiled, DynamicObject tradeType) {
        ListShowParameter listParam = new ListShowParameter();
        listParam.setBillFormId(keyFiled);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)keyFiled);
        listParam.setFormId(formConfig.getF7ListFormId());
        ListFilterParameter parameter = new ListFilterParameter();
        List qFilters = parameter.getQFilters();
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilters.add(new QFilter("yem_tradeproperty.id", "=", tradeType.getPkValue()));
        listParam.setListFilterParameter(parameter);
        listParam.setParentPageId(this.getView().getPageId());
        listParam.setMultiSelect(false);
        listParam.setStatus(OperationStatus.VIEW);
        listParam.getOpenStyle().setShowType(ShowType.Modal);
        listParam.getOpenStyle().setCacheId(listParam.getPageId());
        listParam.setLookUp(true);
        listParam.setCaption(EntityMetadataCache.getDataEntityType((String)keyFiled).getDisplayName().getLocaleValue());
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setWidth("1200px");
        inlineStyleCss.setHeight("600px");
        listParam.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), KEY_FILED_HTH);
        listParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listParam);
    }

    private void btnOk() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("yem_materialinfo");
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        parentModel.deleteEntryData("yem_materialinfo");
        for (int i = 0; i < entryEntity.size(); ++i) {
            int index = parentModel.createNewEntryRow("yem_materialinfo");
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if ("id".equals(name) || "seq".equals(name)) continue;
                parentModel.setValue(name, ((DynamicObject)entryEntity.get(i)).get(name), index);
            }
        }
        view.sendFormAction(parentView);
        view.close();
    }
}

