/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.contemp.dynamic;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BaseDataSelectFormPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    String entryKey = "yem_entryentity";

    public void initialize() {
        this.addClickListeners(new String[]{"yem_btnok"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.entryKey);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        String billkey = (String)this.getView().getFormShowParameter().getCustomParams().get("comboProp");
        if (StringUtils.isNotEmpty((CharSequence)billkey)) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)billkey, (String)"id,name,number", null);
            int[] rowIndexs = model.batchCreateNewEntryRow(this.entryKey, bills.length);
            int i = 0;
            for (DynamicObject bill : bills) {
                LocaleString locStr = new LocaleString();
                locStr.setLocaleValue_zh_CN(bill.getLocaleString("name").getLocaleValue_zh_CN());
                locStr.setLocaleValue_en(bill.getLocaleString("name").getLocaleValue_en());
                model.setValue("yem_fcaption", (Object)locStr, rowIndexs[i]);
                model.setValue("yem_fvalue", (Object)bill.getString("number"), rowIndexs[i]);
                model.setValue("yem_baseid", (Object)bill.getString("id"), rowIndexs[i]);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("yem_btnok".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (int rowIndex : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(this.entryKey, rowIndex);
            list.add(entryRowEntity);
        }
        this.getView().returnDataToParent(list);
        this.getView().close();
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.returnData();
        this.getView().close();
    }
}

