/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.contemp.form;

import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.SystemParamUtil;
import yem.wm.cn.weboffice.contemp.utils.ContractTemplateUtil;

public class ContractTempBillPlugin
extends AbstractBillPlugIn {
    private final Boolean appParam = (Boolean)SystemParamUtil.getAppParam((String)"yem_cn", (String)"yem_template");

    public void afterBindData(EventObject e) {
        if (this.appParam != null && this.appParam.booleanValue()) {
            DynamicObjectCollection cn_dynacfieldentry = this.getModel().getEntryEntity("yem_cn_dynacfieldentry");
            for (int rowIndex = 0; rowIndex < cn_dynacfieldentry.size(); ++rowIndex) {
                ContractTemplateUtil.setLockContent(rowIndex, this.getView());
            }
            DynamicObjectCollection cn_termsentry = this.getModel().getEntryEntity("yem_cn_termsentry");
            for (int rowIndex = 0; rowIndex < cn_termsentry.size(); ++rowIndex) {
                ContractTemplateUtil.changeColourSetting(rowIndex, this.getView());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.appParam != null && this.appParam.booleanValue()) {
            String name = e.getProperty().getName();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            switch (name) {
                case "yem_template": {
                    ContractTemplateUtil.updateTemplateColor("#FFFFFF", this.getView(), this.getModel());
                    DynamicObject[] cn_clausecontrast = BusinessDataServiceHelper.load((String)"yem_cn_clausecontrast", (String)"id,yem_billkey,yem_fieldkey,yem_clausekey,yem_fieldtype,yem_format", (QFilter[])new QFilter[]{new QFilter("yem_billkey.number", "=", (Object)this.getView().getEntityId())});
                    Map<String, DynamicObject> map = Stream.of(cn_clausecontrast).collect(Collectors.toMap(x -> x.getString("yem_clausekey"), y -> y));
                    ContractTemplateUtil.buildDynamicEntry(map, this.getView(), this.getView());
                    ContractTemplateUtil.bringOutContractTerm(this.getModel(), this.getView(), this.getView());
                    ContractTemplateUtil.updateTemplateColor("#e5e5e5", this.getView(), this.getModel());
                    break;
                }
                case "yem_updateafter": {
                    ContractTemplateUtil.changAdjustTrue(rowIndex, this.getModel());
                    String updateafter = (String)this.getModel().getValue("yem_updateafter", rowIndex);
                    this.getModel().setValue("yem_updateafter_tag", (Object)updateafter, rowIndex);
                    ContractTemplateUtil.updateBeforeValue(rowIndex, updateafter, this.getView(), this.getView());
                    break;
                }
                case "yem_updateafter_tag": {
                    String updateafter_tag = (String)this.getModel().getValue("yem_updateafter_tag", rowIndex);
                    this.getModel().setValue("yem_updateafter", (Object)updateafter_tag, rowIndex);
                    break;
                }
                case "yem_change": {
                    ContractTemplateUtil.changeColourSetting(rowIndex, this.getView());
                    break;
                }
                case "yem_contentvalue": {
                    ContractTemplateUtil.updateAfterValue(rowIndex, this.getView(), this.getView());
                    break;
                }
                case "yem_fieldtypef7": {
                    ContractTemplateUtil.setLockContent(rowIndex, this.getView());
                }
            }
            DynamicObjectCollection entryRows = this.getView().getModel().getEntryEntity("yem_cn_outfiledentry");
            for (DynamicObject entity : entryRows) {
                String yem_bill = entity.getString("yem_bill");
                if (!yem_bill.equals(name)) continue;
                ContractTemplateUtil.getFieldValue2UpdateAfter(this.getView(), this.getView());
            }
        }
    }

    public void registerListener(EventObject e) {
        ((TextEdit)this.getControl("yem_contentbutton")).addButtonClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"yem_advcontoolbarap5"});
    }

    public void click(EventObject e) {
        String key = ((Control)e.getSource()).getKey();
        if ("yem_contentbutton".equals(key)) {
            ContractTemplateUtil.skipControlForm(this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("yem_contrast".equals(itemKey)) {
            ContractTemplateUtil.showForm(itemKey, this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key = e.getActionId();
        Object returnData = e.getReturnData();
        int index = this.getModel().getEntryCurrentRowIndex("yem_cn_dynacfieldentry");
        switch (key) {
            case "yem_cn_basedata": {
                ContractTemplateUtil.backBasedValue(returnData, index, this.getView(), this.getView());
                break;
            }
            case "md_forexquote_date": {
                ContractTemplateUtil.backDateValue(returnData, index, this.getView(), this.getView());
                break;
            }
            case "yem_cn_comboitemssel": {
                ContractTemplateUtil.backPullDownValue(returnData, index, this.getView(), this.getView());
                break;
            }
        }
    }
}

