/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.contemp.form;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.RefBillEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.de.utils.F7Helper;
import yem.wm.base.com.change.business.ChangeModelHelper;
import yem.wm.cn.weboffice.contemp.utils.NumberChineseUtil;

public class ContractTemplateBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "yem_department": {
                this.setDeptF7Filter(e);
                break;
            }
            case "yem_termname": {
                this.setTermF7Filter(e);
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("yem_cn_htmb_httk");
        for (DynamicObject entity : entryRows) {
            entity.set("yem_clausescontent", (Object)entity.getString("yem_contentbefore"));
            entity.set("yem_clausescontent_tag", (Object)entity.getString("yem_contentbefore_tag"));
        }
    }

    private void setTermF7Filter(BeforeF7SelectEvent e) {
        String tradetype = (String)this.getModel().getValue("yem_tradetype");
        if (StringUtils.isNotEmpty((CharSequence)tradetype)) {
            F7Helper.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("yem_foreigntrade", "=", (Object)tradetype));
        }
    }

    public void setDeptF7Filter(BeforeF7SelectEvent e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            QFilter qFilter = new QFilter("structure.fullname", "like", (Object)("%" + org.getString("name") + "%"));
            F7Helper.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
        }
    }

    public void registerListener(EventObject e) {
        ((BasedataEdit)this.getControl("yem_department")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((RefBillEdit)this.getControl("yem_termname")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "yem_termname": {
                this.setTermData(rowIndex);
                break;
            }
            case "yem_clausetype": {
                this.setNewTermBillno();
                break;
            }
            case "yem_contentbefore": 
            case "yem_clausescontent": {
                this.setIsChange(rowIndex);
                this.setLargeText("yem_clausescontent", "yem_clausescontent_tag", rowIndex);
                break;
            }
            case "yem_clausescontent_tag": {
                this.setLargeText("yem_clausescontent_tag", "yem_clausescontent", rowIndex);
                break;
            }
            case "yem_contentbefore_tag": {
                this.setLargeText("yem_contentbefore_tag", "yem_contentbefore", rowIndex);
                break;
            }
        }
    }

    private void setLargeText(String changeKey, String setKey, int rowIndex) {
        String yem_clausescontent = (String)this.getModel().getValue(changeKey, rowIndex);
        this.getModel().setValue(setKey, (Object)yem_clausescontent, rowIndex);
    }

    private void setIsChange(int rowIndex) {
        String clausescontent;
        String contentbefore = (String)this.getModel().getValue("yem_contentbefore", rowIndex);
        Boolean isadjust = !StringUtils.equals((CharSequence)contentbefore, (CharSequence)(clausescontent = (String)this.getModel().getValue("yem_clausescontent", rowIndex)));
        this.getModel().setValue("yem_adjust", (Object)isadjust, rowIndex);
    }

    private void setTermData(int index) {
        DynamicObject termname = (DynamicObject)this.getModel().getValue("yem_termname", index);
        if (termname != null) {
            termname = BusinessDataServiceHelper.loadSingleFromCache((Object)termname.getPkValue(), (String)termname.getDynamicObjectType().getName());
            this.getModel().setValue("yem_clausetype", (Object)termname.getDynamicObject("yem_clausetype"), index);
            String yem_clauseschina = termname.getString("yem_clacontchina");
            this.getModel().setValue("yem_clausescontent", (Object)yem_clauseschina, index);
            this.getModel().setValue("yem_clausescontent_tag", (Object)yem_clauseschina, index);
            this.getModel().setValue("yem_contentbefore", (Object)yem_clauseschina, index);
            this.getModel().setValue("yem_contentbefore_tag", (Object)yem_clauseschina, index);
            LocaleString locStr = new LocaleString();
            locStr.setLocaleValue_zh_CN(termname.getString("yem_clausechina"));
            this.getModel().setValue("yem_clausename", (Object)locStr, index);
        }
    }

    private void setNewTermBillno() {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("yem_cn_htmb_httk");
        for (int i = 0; i < entryRows.size(); ++i) {
            DynamicObject entity = (DynamicObject)entryRows.get(i);
            DynamicObject clausetype = entity.getDynamicObject("yem_clausetype");
            if (clausetype == null) continue;
            if (i == 0) {
                this.getModel().setValue("yem_termbillno", (Object)("\u4e8c\u3001" + clausetype.getString("yem_clausename")), i);
                continue;
            }
            DynamicObject entity1 = (DynamicObject)entryRows.get(i - 1);
            String yem_termbillno = entity1.getString("yem_termbillno");
            if (!StringUtils.isNotEmpty((CharSequence)yem_termbillno)) continue;
            String termbillno = yem_termbillno.split("\u3001")[0];
            int num = NumberChineseUtil.chineseToNumber(termbillno) + 1;
            String format = NumberChineseUtil.format(num, false, false);
            this.getModel().setValue("yem_termbillno", (Object)(format + "\u3001" + clausetype.getString("yem_clausename")), i);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "yem_httk_del": 
            case "yem_httk_up": 
            case "yem_httk_dwn": {
                this.setNewTermBillno();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        String billstatus;
        String name = this.getView().getEntityId();
        if (!ChangeModelHelper.getChangeModel4SrcBill((String)name) && ChangeModelHelper.getChangeModel4XBill((String)name) && "A".equals(billstatus = (String)this.getModel().getValue("billstatus"))) {
            this.getModel().setValue("yem_newtemplate", (Object)false);
            DynamicObjectCollection entryRow = this.getModel().getEntryEntity("yem_cn_htmb_httk");
            for (int i = 0; i < entryRow.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryRow.get(i);
                this.getModel().setValue("yem_contentbefore", (Object)entity.getString("yem_clausescontent_tag"), i);
                this.getModel().setValue("yem_contentbefore_tag", (Object)entity.getString("yem_clausescontent_tag"), i);
                this.getModel().setValue("yem_adjust", (Object)false, i);
            }
        }
    }
}

