/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.contemp.opplugin.op;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.wm.base.com.change.business.ChangeModelHelper;

public class ContractTemplateAuditPlugin
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key = e.getOperationKey();
        if ("audit".equals(key)) {
            DynamicObject[] dataEntity;
            for (DynamicObject data : dataEntity = e.getDataEntities()) {
                String name = data.getDataEntityType().getName();
                data = BusinessDataServiceHelper.loadSingleFromCache((Object)data.getPkValue(), (String)name);
                this.updateContractTermData(data);
                if (ChangeModelHelper.getChangeModel4SrcBill((String)name) || !ChangeModelHelper.getChangeModel4XBill((String)name)) continue;
                if (data.getBoolean("yem_newtemplate")) {
                    this.createTemplate(data);
                    continue;
                }
                OperationServiceHelper.executeOperate((String)"bizvalid", (String)name, (DynamicObject[])new DynamicObject[]{data}, (OperateOption)OperateOption.create());
                DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)data.getLong("yem_xsourcebillid"), (String)data.getString("yem_sourcebillentity"));
                bill.set("billstatus", (Object)"C");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            }
        }
    }

    private void createTemplate(DynamicObject data) {
        DynamicObject newDynamicObject;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("yem_templatename", "=", (Object)data.getString("yem_templatename")));
        String name = data.getDataEntityType().getName();
        if (!ChangeModelHelper.getChangeModel4SrcBill((String)name) && ChangeModelHelper.getChangeModel4XBill((String)name)) {
            qFilters.add(new QFilter("id", "!=", (Object)data.getLong("yem_xsourcebillid")));
        } else {
            qFilters.add(new QFilter("id", "!=", data.getPkValue()));
        }
        DynamicObject contracttemplate = BusinessDataServiceHelper.loadSingle((String)"yem_cn_conttemplate", (String)"id,billno", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (contracttemplate == null) {
            newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"yem_cn_conttemplate");
            DynamicObjectUtil.copyDynamicObject((DynamicObject)data, (DynamicObject)newDynamicObject);
            newDynamicObject.set("billstatus", (Object)"C");
            String number = CodeRuleServiceHelper.getNumber((String)"yem_cn_conttemplate", (DynamicObject)newDynamicObject, null);
            newDynamicObject.set("billno", (Object)number);
            newDynamicObject.set("yem_version", (Object)1);
            newDynamicObject.set("yem_xsourcebillid", null);
            newDynamicObject.set("yem_newtemplate", (Object)false);
            DynamicObjectCollection entryRows = newDynamicObject.getDynamicObjectCollection("yem_cn_htmb_httk");
            for (DynamicObject entity : entryRows) {
                entity.set("yem_adjust", (Object)false);
            }
        } else {
            throw new KDBizException("\u5408\u540c\u6a21\u677f\u5ba1\u6838\u751f\u6210\u65b0\u7684\u5408\u540c\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u8bf7\u53d8\u66f4\u6a21\u677f\u540d\u79f0\u3002");
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"yem_cn_conttemplate", (DynamicObject[])new DynamicObject[]{newDynamicObject}, (OperateOption)OperateOption.create());
        data.set("yem_activestatus", (Object)"B");
        data.set("yem_changedate", (Object)new Date());
        data.set("yem_activedate", (Object)new Date());
        data.set("yem_changer", (Object)UserServiceHelper.getCurrentUserId());
        data.set("yem_active", (Object)UserServiceHelper.getCurrentUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)data.getLong("yem_xsourcebillid"), (String)data.getString("yem_sourcebillentity"));
        bill.set("yem_version", (Object)data.getBigDecimal("yem_version"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }

    private void updateContractTermData(DynamicObject data) {
        String amend = data.getString("yem_amend");
        if (StringUtils.isNotEmpty((CharSequence)amend)) {
            DynamicObjectCollection entryRows = data.getDynamicObjectCollection("yem_cn_htmb_httk");
            for (DynamicObject entity : entryRows) {
                boolean tpv_adjust = entity.getBoolean("yem_adjust");
                if (!tpv_adjust) continue;
                if (amend.equals("A")) {
                    this.termData(data, entity, true);
                    continue;
                }
                if (!amend.equals("B")) continue;
                this.termData(data, entity, false);
                this.updateHistoryTemplate(data, entity);
            }
        }
    }

    private void updateHistoryTemplate(DynamicObject data, DynamicObject entity) {
        DynamicObject termname = entity.getDynamicObject("yem_termname");
        if (termname != null) {
            DynamicObject[] cn_conttemplate;
            long termnameId = termname.getLong("id");
            termname = BusinessDataServiceHelper.loadSingleFromCache((Object)termnameId, (String)termname.getDynamicObjectType().getName());
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("yem_cn_htmb_httk.yem_termname", "=", (Object)termnameId));
            qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
            qFilters.add(new QFilter("id", "!=", (Object)data.getLong("id")));
            for (DynamicObject conttemplate : cn_conttemplate = BusinessDataServiceHelper.load((String)"yem_cn_conttemplate", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]))) {
                conttemplate = BusinessDataServiceHelper.loadSingleFromCache((Object)conttemplate.getPkValue(), (String)conttemplate.getDynamicObjectType().getName());
                DynamicObjectCollection entityRow = conttemplate.getDynamicObjectCollection("yem_cn_htmb_httk");
                for (DynamicObject oldEntity : entityRow) {
                    DynamicObject oldtermname = oldEntity.getDynamicObject("yem_termname");
                    if (oldtermname == null || oldtermname.getLong("id") != termnameId) continue;
                    DynamicObject clausetype = termname.getDynamicObject("yem_clausetype");
                    oldEntity.set("yem_clausetype", (Object)clausetype);
                    LocaleString locStr = new LocaleString();
                    locStr.setLocaleValue_zh_CN(termname.getString("yem_clausechina"));
                    oldEntity.set("yem_clausename", (Object)locStr);
                    oldEntity.set("yem_termbillno", (Object)clausetype.getString("yem_clausename"));
                    String clacontchina = termname.getString("yem_clacontchina_tag");
                    oldEntity.set("yem_clausescontent", (Object)clacontchina);
                    oldEntity.set("yem_clausescontent_tag", (Object)clacontchina);
                    oldEntity.set("yem_contentbefore", (Object)clacontchina);
                    oldEntity.set("yem_contentbefore_tag", (Object)clacontchina);
                }
            }
            SaveServiceHelper.save((DynamicObject[])cn_conttemplate);
        }
    }

    private void termData(DynamicObject data, DynamicObject entity, boolean iscreate) {
        DynamicObject termname = entity.getDynamicObject("yem_termname");
        if (termname != null) {
            termname = BusinessDataServiceHelper.loadSingleFromCache((Object)termname.getPkValue(), (String)termname.getDynamicObjectType().getName());
        }
        if (iscreate) {
            termname = BusinessDataServiceHelper.newDynamicObject((String)"yem_cn_contractterms");
        }
        if (termname != null) {
            termname.set("org", (Object)data.getDynamicObject("org"));
            termname.set("yem_department", (Object)data.getDynamicObject("yem_department"));
            String tpv_tradetype = data.getString("yem_tradetype");
            termname.set("yem_foreigntrade", (Object)tpv_tradetype);
            termname.set("yem_clausetype", (Object)entity.getDynamicObject("yem_clausetype"));
            String clausescontent = entity.getString("yem_clausescontent_tag");
            termname.set("yem_clacontchina", (Object)clausescontent);
            termname.set("yem_clausechina", (Object)entity.getString("yem_clausename"));
            termname.set("yem_clacontchina_tag", (Object)clausescontent);
            termname.set("billstatus", (Object)"C");
            OperationServiceHelper.executeOperate((String)"save", (String)"yem_cn_contractterms", (DynamicObject[])new DynamicObject[]{termname}, (OperateOption)OperateOption.create());
            entity.set("yem_termname", (Object)termname);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
        }
    }
}

