/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.contemp.utils;

import cn.hutool.core.date.DateUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import yem.base.common.utils.YEM;

public class ContractTemplateUtil {
    public static String cutOutString(String key, List<String> scoopField) {
        String str = "";
        if (key.contains("\u3010")) {
            String substring = key.substring(key.indexOf("\u3010") + 1, key.indexOf("\u3011"));
            str = key.substring(0, key.indexOf("\u3010")) + key.substring(key.indexOf("\u3011") + 1);
            if (!scoopField.contains(substring)) {
                scoopField.add(substring);
            }
        }
        return str;
    }

    public static void hollowFieldHasOrNo(String field, List<String> scoopFieldNew, IFormView view, DynamicObject clausecontrast) {
        String name = view.getEntityId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)name);
        if (clausecontrast != null) {
            String fieldkey = clausecontrast.getString("yem_fieldkey");
            if (StringUtils.isNotEmpty((CharSequence)fieldkey)) {
                boolean whether = false;
                ArrayList<IDataEntityType> entryTypes = new ArrayList<IDataEntityType>();
                for (IDataEntityProperty item : entityType.getProperties()) {
                    String fieldname;
                    if (item instanceof EntryProp && !(item instanceof LinkEntryProp)) {
                        entryTypes.add(((EntryProp)item).getItemType());
                    }
                    if (!(fieldname = item.getName()).equals(fieldkey)) continue;
                    whether = true;
                }
                if (entryTypes.size() > 0) {
                    for (IDataEntityType iDataEntityType : entryTypes) {
                        for (IDataEntityProperty property : iDataEntityType.getProperties()) {
                            String fieldname = property.getName();
                            if (!fieldname.equals(fieldkey)) continue;
                            whether = true;
                        }
                    }
                }
                if (!whether) {
                    scoopFieldNew.add(field);
                }
            } else {
                scoopFieldNew.add(field);
            }
        } else {
            scoopFieldNew.add(field);
        }
    }

    public static void createHollowEntry(IFormView parentView, DynamicObject entity) {
        IDataModel model = parentView.getModel();
        if (entity != null) {
            int row = model.createNewEntryRow("yem_cn_dynacfieldentry");
            model.setValue("yem_fieldname", (Object)entity.getString("name"), row);
            model.setValue("yem_fieldkey", (Object)entity.getString("yem_clausekey"), row);
            DynamicObject yem_fieldtype = entity.getDynamicObject("yem_fieldtype");
            String fieldtype = yem_fieldtype != null ? BusinessDataServiceHelper.loadSingleFromCache((Object)yem_fieldtype.getLong("id"), (String)yem_fieldtype.getDataEntityType().getName()).getString("yem_keytype") : "";
            model.setValue("yem_fieldtypef7", (Object)yem_fieldtype, row);
            model.setValue("yem_fieldtype", (Object)fieldtype, row);
        }
    }

    public static void setEntryBillkey(Map<String, DynamicObject> map, String key, IFormView compView, IFormView view) {
        IDataModel model = compView.getModel();
        DynamicObject clausecontrast = map.get(key);
        clausecontrast = BusinessDataServiceHelper.loadSingleFromCache((Object)clausecontrast.getPkValue(), (String)clausecontrast.getDataEntityType().getName());
        int row = model.createNewEntryRow("yem_cn_outfiledentry");
        String yem_field = clausecontrast.getString("yem_field");
        String field = "";
        String fieldaf = "";
        if (yem_field.contains(".")) {
            field = yem_field.substring(0, yem_field.indexOf("."));
            fieldaf = yem_field.substring(yem_field.indexOf(".") + 1);
            model.setValue("yem_bill", (Object)fieldaf, row);
        } else {
            model.setValue("yem_bill", (Object)yem_field, row);
        }
        if (field.equals("")) {
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)view.getEntityId()).getProperty(yem_field);
            model.setValue("yem_billfieldname", (Object)property.getDisplayName(), row);
        } else {
            DynamicObjectCollection coll = view.getModel().getDataEntity(true).getDynamicObjectCollection(field);
            DynamicProperty property = coll.getDynamicObjectType().getProperty(fieldaf);
            model.setValue("yem_billfieldname", (Object)property.getDisplayName(), row);
        }
        model.setValue("yem_clausekey", (Object)clausecontrast.getString("yem_clausekey"), row);
        model.setValue("yem_entrykey", (Object)field, row);
        model.setValue("yem_format_bdwk", (Object)clausecontrast.getString("yem_format"), row);
    }

    public static Map<String, DynamicObject> getKey(IFormView view) {
        DynamicObjectCollection entryRows = view.getModel().getEntryEntity("yem_cn_outfiledentry");
        return entryRows.stream().collect(Collectors.toMap(x -> x.getString("yem_clausekey"), y -> y));
    }

    public static Map<String, String> getScoopValue(String entrykey, DynamicObject bill, IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        Object fieldValue = null;
        String yem_bill = bill.getString("yem_bill");
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)entrykey)) {
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(entrykey);
            if (entryEntity.size() > 0) {
                fieldValue = ((DynamicObject)entryEntity.get(0)).get(yem_bill);
            }
        } else {
            fieldValue = dataEntity.get(yem_bill);
        }
        String value = "";
        String englishValue = "";
        String format = bill.getString("yem_format_bdwk");
        if (StringUtils.isNotEmpty((CharSequence)format) && fieldValue != null) {
            switch (format) {
                case "PriceProp": 
                case "QtyProp": 
                case "AmountProp": 
                case "DecimalProp": {
                    BigDecimal bigvalue = (BigDecimal)fieldValue;
                    if (bigvalue.compareTo(BigDecimal.ZERO) <= 0) break;
                    bigvalue = bigvalue.setScale(2, RoundingMode.HALF_UP);
                    value = bigvalue + "";
                    englishValue = bigvalue + "";
                    break;
                }
                case "BasedataProp": 
                case "UserProp": 
                case "OrgProp": 
                case "CurrencyProp": 
                case "UnitProp": {
                    DynamicObject basevalue = (DynamicObject)fieldValue;
                    value = basevalue.getLocaleString("name").getLocaleValue_zh_CN();
                    englishValue = basevalue.getLocaleString("name").getLocaleValue_en();
                    englishValue = englishValue == null ? value : englishValue;
                    break;
                }
                case "BooleanProp": {
                    Boolean boolValue = (Boolean)fieldValue;
                    if (boolValue.booleanValue()) {
                        value = "\u662f";
                        englishValue = "true";
                        break;
                    }
                    value = "\u5426";
                    englishValue = "false";
                    break;
                }
                case "ComboProp": {
                    String comvalue = (String)fieldValue;
                    if (!StringUtils.isNotEmpty((CharSequence)comvalue)) break;
                    MainEntityType type = MetadataServiceHelper.getDataEntityType((String)dataEntity.getDataEntityType().getName());
                    ComboProp ComboProp2 = (ComboProp)type.findProperty(yem_bill);
                    List comboItems = ComboProp2.getComboItems();
                    for (ValueMapItem comboItem : comboItems) {
                        if (!comboItem.getValue().equals(comvalue)) continue;
                        value = comboItem.getName().getLocaleValue_zh_CN();
                        englishValue = comboItem.getName().getLocaleValue_en();
                    }
                    break;
                }
                case "TextProp": {
                    if (!StringUtils.isNotEmpty((CharSequence)((String)fieldValue))) break;
                    value = (String)fieldValue;
                    englishValue = (String)fieldValue;
                    break;
                }
                case "MuliLangTextProp": {
                    value = ((ILocaleString)fieldValue).getLocaleValue_zh_CN();
                    englishValue = ((ILocaleString)fieldValue).getLocaleValue_en();
                    break;
                }
                case "DateTimeProp": 
                case "DateProp": {
                    Date date = (Date)fieldValue;
                    ZoneId zoneId = ZoneId.systemDefault();
                    ZonedDateTime zonedDateTime = date.toInstant().atZone(zoneId);
                    LocalDate localDate = zonedDateTime.toLocalDate();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
                    value = localDate.format(formatter);
                    englishValue = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
                    break;
                }
                case "MulBasedataProp": {
                    DynamicObjectCollection dycollValue = (DynamicObjectCollection)fieldValue;
                    ArrayList<String> chineseValue = new ArrayList<String>();
                    ArrayList<String> engValue = new ArrayList<String>();
                    for (DynamicObject dycoll : dycollValue) {
                        String cnValue = dycoll.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue_zh_CN();
                        String enValue = dycoll.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue_en();
                        if (!chineseValue.contains(cnValue)) {
                            chineseValue.add(cnValue);
                        }
                        if (engValue.contains(enValue)) continue;
                        engValue.add(enValue);
                    }
                    value = String.join((CharSequence)"\u3001", chineseValue);
                    englishValue = String.join((CharSequence)"\u3001", engValue);
                    break;
                }
                case "IntegerProp": {
                    Integer integer = (Integer)fieldValue;
                    if (integer == 0) break;
                    value = integer + "";
                    englishValue = integer + "";
                }
            }
        }
        map.put("value", value);
        map.put("englishValue", englishValue);
        return map;
    }

    public static String setupdateValue(String value, String updateafter, String clausekey) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            updateafter = updateafter.replace("\u3010" + clausekey + "\u3011", value);
        }
        return updateafter;
    }

    public static Map<String, DynamicObject> getDynamicKey(IFormView parentView) {
        DynamicObjectCollection entryRows = parentView.getModel().getEntryEntity("yem_cn_dynacfieldentry");
        return entryRows.stream().collect(Collectors.toMap(x -> x.getString("yem_fieldkey"), y -> y));
    }

    public static void backgroundColor(DynamicObject entity, String color, IFormView view) {
        String billKey = entity.getString("yem_bill");
        String idByNumber = MetadataDao.getIdByNumber((String)view.getEntityId(), (MetaCategory)MetaCategory.Entity);
        EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Entity);
        List items = meta.getItems();
        for (EntityItem entityItem : items) {
            if (!(entityItem instanceof DateRangeField)) continue;
            DateRangeField item = (DateRangeField)entityItem;
            String startDateFieldKey = item.getStartDateFieldKey();
            String endDateFieldKey = item.getEndDateFieldKey();
            if (!billKey.equals(startDateFieldKey) && !billKey.equals(endDateFieldKey)) continue;
            billKey = item.getKey();
        }
        String entrykey = entity.getString("yem_entrykey");
        if (!"".equals(entrykey)) {
            YEM.changeCellColor((IFormView)view, (String)entrykey, (String)billKey, (int)0, (String)color);
        } else {
            YEM.changeCtlColor((IFormView)view, (String)billKey, (String)color);
        }
    }

    public static void getFieldValue2UpdateAfter(IFormView view, IFormView compView) {
        IDataModel compModel = compView.getModel();
        DynamicObject dataEntity = compModel.getDataEntity(true);
        DynamicObjectCollection yem_clauseimport = dataEntity.getDynamicObjectCollection("yem_cn_termsentry");
        for (int i = 0; i < yem_clauseimport.size(); ++i) {
            DynamicObject clauseimport = (DynamicObject)yem_clauseimport.get(i);
            String yem_updateafter = clauseimport.getString("yem_updateafter");
            ArrayList<String> list = new ArrayList<String>();
            Map<String, DynamicObject> map = ContractTemplateUtil.getKey(compView);
            Map<String, DynamicObject> dynamicKey = ContractTemplateUtil.getDynamicKey(compView);
            String updatebefore = yem_updateafter;
            for (int j = 0; j < updatebefore.length(); ++j) {
                updatebefore = ContractTemplateUtil.cutOutString(updatebefore, list);
            }
            String context = yem_updateafter;
            for (String key : list) {
                String contentvalue;
                DynamicObject bill;
                if (map.containsKey(key)) {
                    bill = map.get(key);
                    String yem_clausekey = bill.getString("yem_clausekey");
                    String yem_entrykey = bill.getString("yem_entrykey");
                    Map<String, String> scoopValue = ContractTemplateUtil.getScoopValue(yem_entrykey, bill, view);
                    String value = scoopValue.get("value");
                    context = ContractTemplateUtil.setupdateValue(value, context, yem_clausekey);
                    if (map.containsKey(key)) {
                        compModel.setValue("yem_billcontent", (Object)value, map.get(key).getInt("seq") - 1);
                    }
                }
                if (!dynamicKey.containsKey(key) || !YEM.isNotEmpty((Object)(contentvalue = (bill = dynamicKey.get(key)).getString("yem_contentvalue")))) continue;
                context = ContractTemplateUtil.setupdateValue(contentvalue, context, key);
            }
            compModel.setValue("yem_printclause", (Object)context, i);
            compModel.setValue("yem_printclause_tag", (Object)context, i);
        }
    }

    public static void setLockContent(int rowIndex, IFormView view) {
        DynamicObject fieldtypef7 = (DynamicObject)view.getModel().getValue("yem_fieldtypef7", rowIndex);
        if (fieldtypef7 != null) {
            fieldtypef7 = BusinessDataServiceHelper.loadSingleFromCache((Object)fieldtypef7.getLong("id"), (String)fieldtypef7.getDynamicObjectType().getName());
            String yem_keytype = fieldtypef7.getString("yem_keytype");
            List<String> keytype = Arrays.asList("ComboProp", "BasedataProp", "UnitProp", "UserProp", "OrgProp", "CurrencyProp", "MulBasedataProp", "DateTimeProp");
            view.setEnable(Boolean.valueOf(!keytype.contains(yem_keytype)), rowIndex, new String[]{"yem_contentvalue"});
        }
    }

    public static void changeColourSetting(int rowIndex, IFormView view) {
        String[] fieldList;
        Boolean change = (Boolean)view.getModel().getValue("yem_change", rowIndex);
        for (String field : fieldList = new String[]{"yem_termtype", "yem_updatebefore", "yem_change", "yem_clausename", "yem_printclause"}) {
            if (change.booleanValue()) {
                YEM.changeCellColor((IFormView)view, (String)"yem_cn_termsentry", (String)field, (int)rowIndex, (String)"rgba(240,232,229,0.8)");
                continue;
            }
            YEM.changeCellColor((IFormView)view, (String)"yem_cn_termsentry", (String)field, (int)rowIndex, (String)"rgba(240,232,229,0.8)");
        }
    }

    public static void updateTemplateColor(String color, IFormView view, IDataModel model) {
        DynamicObjectCollection yem_billentrykey = model.getEntryEntity("yem_cn_outfiledentry");
        for (DynamicObject billentrykey : yem_billentrykey) {
            ContractTemplateUtil.backgroundColor(billentrykey, color, view);
        }
    }

    public static void buildDynamicEntry(Map<String, DynamicObject> map, IFormView compView, IFormView view) {
        compView.getModel().deleteEntryData("yem_cn_outfiledentry");
        List<String> scoopField = ContractTemplateUtil.getHollowFieldList(compView.getModel());
        ArrayList<String> scoopFieldNew = new ArrayList<String>();
        if (scoopField.size() > 0) {
            for (String field : scoopField) {
                if (!map.containsKey(field)) break;
                ContractTemplateUtil.hollowFieldHasOrNo(field, scoopFieldNew, view, map.get(field));
            }
        }
        compView.getModel().deleteEntryData("yem_cn_dynacfieldentry");
        if (scoopFieldNew.size() > 0) {
            for (String field : scoopFieldNew) {
                if (!map.containsKey(field)) continue;
                ContractTemplateUtil.createHollowEntry(compView, map.get(field));
            }
        }
        HashMap<String, DynamicObject> mapList = new HashMap<String, DynamicObject>();
        for (String field : scoopField) {
            if (scoopFieldNew.contains(field) || !map.containsKey(field) || map.get(field) == null) continue;
            mapList.put(field, map.get(field));
        }
        compView.getModel().deleteEntryData("yem_cn_outfiledentry");
        if (mapList.size() > 0) {
            for (String key : mapList.keySet()) {
                ContractTemplateUtil.setEntryBillkey(mapList, key, compView, view);
            }
        }
    }

    private static List<String> getHollowFieldList(IDataModel model) {
        DynamicObject template = (DynamicObject)model.getValue("yem_template");
        ArrayList<String> scoopField = new ArrayList<String>();
        if (template != null) {
            template = BusinessDataServiceHelper.loadSingleFromCache((Object)template.getPkValue(), (String)template.getDynamicObjectType().getName());
            DynamicObjectCollection entryRows = template.getDynamicObjectCollection("yem_cn_htmb_httk");
            for (DynamicObject entity : entryRows) {
                String clausescontent;
                DynamicObject termname = entity.getDynamicObject("yem_termname");
                if (termname == null || !StringUtils.isNotEmpty((CharSequence)(clausescontent = entity.getString("yem_clausescontent")))) continue;
                for (int i = 0; i < clausescontent.length(); ++i) {
                    if (!clausescontent.contains("\u3010")) continue;
                    clausescontent = ContractTemplateUtil.cutOutString(clausescontent, scoopField);
                }
            }
        }
        return scoopField;
    }

    public static void bringOutContractTerm(IDataModel model, IFormView parentView, IFormView view) {
        DynamicObject template = (DynamicObject)model.getValue("yem_template");
        model.deleteEntryData("yem_cn_termsentry");
        if (template != null) {
            template = BusinessDataServiceHelper.loadSingleFromCache((Object)template.getPkValue(), (String)template.getDynamicObjectType().getName());
            DynamicObjectCollection entryRows = template.getDynamicObjectCollection("yem_cn_htmb_httk");
            for (DynamicObject entity : entryRows) {
                int row = model.createNewEntryRow("yem_cn_termsentry");
                model.setValue("yem_termtype", (Object)entity.getString("yem_termbillno"), row);
                model.setValue("yem_clausenameeng", (Object)entity.getString("yem_termbillno"), row);
                DynamicObject termname = entity.getDynamicObject("yem_termname");
                if (termname != null) {
                    termname = BusinessDataServiceHelper.loadSingleFromCache((Object)termname.getPkValue(), (String)termname.getDynamicObjectType().getName());
                    String clausechina = termname.getString("yem_clausechina");
                    LocaleString locStr = new LocaleString();
                    locStr.setLocaleValue_zh_CN(clausechina);
                    model.setValue("yem_clausename", (Object)locStr, row);
                    model.setValue("yem_clausetype", (Object)termname.getString("yem_clausechina"), row);
                }
                String clausescontent = entity.getString("yem_clausescontent");
                model.setValue("yem_updatebefore", (Object)clausescontent, row);
                model.setValue("yem_updatebefore_tag", (Object)clausescontent, row);
                model.setValue("yem_updateafter", (Object)clausescontent, row);
                model.setValue("yem_updateafter_tag", (Object)clausescontent, row);
                model.setValue("yem_printclause", (Object)clausescontent, row);
                model.setValue("yem_printclause_tag", (Object)clausescontent, row);
            }
        }
        ContractTemplateUtil.getFieldValue2UpdateAfter(parentView, view);
    }

    public static void changAdjustTrue(int rowIndex, IDataModel model) {
        String updateafter;
        String updatebefore = (String)model.getValue("yem_updatebefore", rowIndex);
        Boolean ischange = !updatebefore.equals(updateafter = (String)model.getValue("yem_updateafter", rowIndex));
        model.setValue("yem_change", (Object)ischange, rowIndex);
    }

    public static void updateBeforeValue(int rowIndex, String updateafter, IFormView view, IFormView parentView) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, DynamicObject> map = ContractTemplateUtil.getKey(view);
        String updatebefore = updateafter;
        DynamicObjectCollection entryRows = view.getModel().getEntryEntity("yem_cn_dynacfieldentry");
        Map<String, DynamicObject> collect = entryRows.stream().collect(Collectors.toMap(x -> x.getString("yem_fieldkey"), y -> y));
        for (int j = 0; j < updatebefore.length(); ++j) {
            updatebefore = ContractTemplateUtil.cutOutString(updatebefore, list);
        }
        updateafter = ContractTemplateUtil.setContentValue(updateafter, list, map, collect, parentView);
        view.getModel().setValue("yem_printclause", (Object)updateafter, rowIndex);
        view.getModel().setValue("yem_printclause_tag", (Object)updateafter, rowIndex);
    }

    public static String setContentValue(String updateafter, List<String> list, Map<String, DynamicObject> map, Map<String, DynamicObject> collect, IFormView parentView) {
        for (String key : list) {
            String value;
            DynamicObject bill;
            if (map.containsKey(key)) {
                bill = map.get(key);
                String clausekey = bill.getString("yem_clausekey");
                String entrykey = bill.getString("yem_entrykey");
                Map<String, String> scoopValue = ContractTemplateUtil.getScoopValue(entrykey, bill, parentView);
                String value2 = scoopValue.get("value");
                updateafter = ContractTemplateUtil.setupdateValue(value2, updateafter, clausekey);
            }
            if (!collect.containsKey(key) || !YEM.isNotEmpty((Object)(value = (bill = collect.get(key)).getString("yem_contentvalue")))) continue;
            updateafter = ContractTemplateUtil.setupdateValue(value, updateafter, key);
        }
        return updateafter;
    }

    public static void updateAfterValue(int rowIndex, IFormView view, IFormView parentView) {
        DynamicObject entity = view.getModel().getEntryRowEntity("yem_cn_dynacfieldentry", rowIndex);
        String content = entity.getString("yem_contentvalue");
        String fieldkey = entity.getString("yem_fieldkey");
        DynamicObjectCollection entryRows = view.getModel().getEntryEntity("yem_cn_termsentry");
        for (int i = 0; i < entryRows.size(); ++i) {
            DynamicObject clauseimport = (DynamicObject)entryRows.get(i);
            String updateafter = clauseimport.getString("yem_updateafter");
            ContractTemplateUtil.replaceContent(content, fieldkey, i, updateafter, view, parentView);
        }
    }

    public static void replaceContent(String captionCn, String fieldkey, int i, String yem_updatebefore, IFormView view, IFormView parentView) {
        if (yem_updatebefore.contains(fieldkey)) {
            ArrayList<String> list = new ArrayList<String>();
            Map<String, DynamicObject> map = ContractTemplateUtil.getKey(view);
            Map<String, DynamicObject> dynamicKey = ContractTemplateUtil.getDynamicKey(view);
            String updatebefore = yem_updatebefore;
            for (int j = 0; j < updatebefore.length(); ++j) {
                updatebefore = ContractTemplateUtil.cutOutString(updatebefore, list);
            }
            String context = yem_updatebefore;
            context = ContractTemplateUtil.setContentValue(context, list, map, dynamicKey, parentView);
            context = ContractTemplateUtil.setupdateValue(captionCn, context, fieldkey);
            view.getModel().setValue("yem_printclause", (Object)context, i);
            view.getModel().setValue("yem_printclause_tag", (Object)context, i);
        }
    }

    public static void skipControlForm(AbstractBillPlugIn plugin) {
        String keytype;
        IFormView view = plugin.getView();
        int index = view.getModel().getEntryCurrentRowIndex("yem_cn_dynacfieldentry");
        DynamicObject entity = view.getModel().getEntryRowEntity("yem_cn_dynacfieldentry", index);
        DynamicObject fieldtypef7 = entity.getDynamicObject("yem_fieldtypef7");
        if (fieldtypef7 != null && StringUtils.isNotEmpty((CharSequence)(keytype = (fieldtypef7 = BusinessDataServiceHelper.loadSingleFromCache((Object)fieldtypef7.getPkValue(), (String)fieldtypef7.getDynamicObjectType().getName())).getString("yem_keytype")))) {
            switch (keytype) {
                case "ComboProp": {
                    ContractTemplateUtil.skipPullDownList(fieldtypef7, plugin);
                    break;
                }
                case "BasedataProp": 
                case "UnitProp": 
                case "UserProp": 
                case "OrgProp": 
                case "CurrencyProp": 
                case "MulBasedataProp": {
                    ContractTemplateUtil.skipInitialValue(fieldtypef7, plugin);
                    break;
                }
                case "DateTimeProp": {
                    ContractTemplateUtil.skipDateControl("md_forexquote_date", "", plugin);
                    break;
                }
            }
        }
    }

    private static void skipInitialValue(DynamicObject fieldtypef7, AbstractBillPlugIn plugin) {
        DynamicObject yem_billkey = fieldtypef7.getDynamicObject("yem_billkey");
        if (yem_billkey != null) {
            ContractTemplateUtil.skipDateControl("yem_cn_basedata", yem_billkey.getString("number"), plugin);
        }
    }

    private static void skipPullDownList(DynamicObject fieldtypef7, AbstractBillPlugIn plugin) {
        DynamicObjectCollection entryRows = fieldtypef7.getDynamicObjectCollection("yem_cn_zdle_xlfl");
        ArrayList list = new ArrayList();
        for (DynamicObject entity : entryRows) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("EnName", entity.getLocaleString("yem_fcaption").getLocaleValue_en());
            map.put("CnName", entity.getLocaleString("yem_fcaption").getLocaleValue_zh_CN());
            map.put("Value", entity.getString("yem_fvalue"));
            map.put("ImageKey", "");
            list.add(map);
        }
        if (list.size() > 0) {
            ContractTemplateUtil.skipDateControl("yem_cn_comboitemssel", list, plugin);
        }
    }

    private static void skipDateControl(String formKey, Object param, AbstractBillPlugIn plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(formKey);
        if (YEM.isNotEmpty((Object)param)) {
            showParameter.setCustomParam("comboProp", param);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, formKey));
        plugin.getView().showForm(showParameter);
    }

    public static void showForm(String itemKey, AbstractBillPlugIn plugin) {
        IFormView view = plugin.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> map = new HashMap<String, String>();
        EntryGrid entryGrid = (EntryGrid)view.getControl("yem_cn_termsentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1) {
            view.showTipNotification("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
            return;
        }
        DynamicObjectCollection entity = view.getModel().getDataEntity(true).getDynamicObjectCollection("yem_cn_termsentry");
        String updatebefore = ((DynamicObject)entity.get(selectRows[0])).getString("yem_updatebefore");
        String printclause = ((DynamicObject)entity.get(selectRows[0])).getString("yem_printclause");
        map.put("updatebefore", updatebefore);
        map.put("printclause", printclause);
        parameter.setCustomParams(map);
        parameter.setFormId("yem_cn_contracts");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, itemKey));
        view.showForm(parameter);
    }

    public static void backBasedValue(Object returnData, int index, IFormView view, IFormView parentView) {
        List list = (List)returnData;
        if (list != null) {
            ArrayList<String> CnValue = new ArrayList<String>();
            ArrayList<String> EnValue = new ArrayList<String>();
            for (DynamicObject bill : list) {
                CnValue.add(bill.getLocaleString("yem_fcaption").getLocaleValue_zh_CN());
                EnValue.add(bill.getLocaleString("yem_fcaption").getLocaleValue_en());
            }
            LocaleString local = new LocaleString();
            local.setLocaleValue_zh_CN(String.join((CharSequence)"\u3001", CnValue));
            local.setLocaleValue_en(String.join((CharSequence)"\u3001", EnValue));
            DynamicObject entity = view.getModel().getEntryRowEntity("yem_cn_dynacfieldentry", index);
            entity.set("yem_contentvalue", (Object)local);
            view.updateView("yem_cn_dynacfieldentry");
            view.setEnable(Boolean.valueOf(false), index, new String[]{"yem_contentvalue"});
            ContractTemplateUtil.updateCasule(entity, String.join((CharSequence)"\u3001", CnValue), view, parentView);
        }
    }

    public static void updateCasule(DynamicObject entity, String captionCn, IFormView view, IFormView parentView) {
        String fieldkey = entity.getString("yem_fieldkey");
        DynamicObjectCollection entryRows = view.getModel().getEntryEntity("yem_cn_termsentry");
        for (int i = 0; i < entryRows.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryRows.get(i);
            String yem_updatebefore = entry.getString("yem_updatebefore");
            ContractTemplateUtil.replaceContent(captionCn, fieldkey, i, yem_updatebefore, view, parentView);
        }
    }

    public static void backDateValue(Object returnData, int index, IFormView view, IFormView parentView) {
        Date data = (Date)returnData;
        if (data != null) {
            LocaleString local = new LocaleString();
            ZoneId zoneId = ZoneId.systemDefault();
            ZonedDateTime zonedDateTime = data.toInstant().atZone(zoneId);
            LocalDate localDate = zonedDateTime.toLocalDate();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
            String fcaptionCn = localDate.format(formatter);
            local.setLocaleValue_zh_CN(fcaptionCn);
            DynamicObject entity = view.getModel().getEntryRowEntity("yem_cn_dynacfieldentry", index);
            entity.set("yem_contentvalue", (Object)local);
            view.updateView("yem_cn_dynacfieldentry");
            view.setEnable(Boolean.valueOf(false), index, new String[]{"yem_contentvalue"});
            ContractTemplateUtil.updateCasule(entity, fcaptionCn, view, parentView);
        }
    }

    public static void backPullDownValue(Object returnData, int index, IFormView view, IFormView parentView) {
        DynamicObject data = (DynamicObject)returnData;
        if (data != null) {
            LocaleString local = new LocaleString();
            String yem_fcaptionCn = data.getLocaleString("yem_fcaption").getLocaleValue_zh_CN();
            local.setLocaleValue_zh_CN(yem_fcaptionCn);
            DynamicObject entity = view.getModel().getEntryRowEntity("yem_cn_dynacfieldentry", index);
            entity.set("yem_contentvalue", (Object)local);
            view.updateView("yem_cn_dynacfieldentry");
            view.setEnable(Boolean.valueOf(false), index, new String[]{"yem_contentvalue"});
            ContractTemplateUtil.updateCasule(entity, yem_fcaptionCn, view, parentView);
        }
    }
}

