/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.contemp.utils;

import kd.bos.dataentity.utils.StringUtils;
import yem.wm.cn.weboffice.contemp.utils.ChineseUnit;

public class NumberChineseUtil {
    private static final char[] DIGITS = new char[]{'\u96f6', '\u4e00', '\u58f9', '\u4e8c', '\u8d30', '\u4e09', '\u53c1', '\u56db', '\u8086', '\u4e94', '\u4f0d', '\u516d', '\u9646', '\u4e03', '\u67d2', '\u516b', '\u634c', '\u4e5d', '\u7396'};
    private static final ChineseUnit[] CHINESE_NAME_VALUE = new ChineseUnit[]{new ChineseUnit(' ', 1, false), new ChineseUnit('\u5341', 10, false), new ChineseUnit('\u62fe', 10, false), new ChineseUnit('\u767e', 100, false), new ChineseUnit('\u4f70', 100, false), new ChineseUnit('\u5343', 1000, false), new ChineseUnit('\u4edf', 1000, false), new ChineseUnit('\u4e07', 10000, true), new ChineseUnit('\u4ebf', 100000000, true)};
    public static final String NULL = "null";

    public static int chineseToNumber(String chinese) {
        int length = chinese.length();
        int result = 0;
        int section = 0;
        int number = 0;
        ChineseUnit unit = null;
        for (int i = 0; i < length; ++i) {
            char c = chinese.charAt(i);
            int num = NumberChineseUtil.chineseToNumber(c);
            if (num >= 0) {
                if (num == 0) {
                    if (number > 0 && null != unit) {
                        section += number * (unit.value / 10);
                    }
                    unit = null;
                }
                number = num;
                continue;
            }
            unit = NumberChineseUtil.chineseToUnit(c);
            if (null == unit) break;
            if (unit.isSecUnit()) {
                section = (section + number) * unit.getValue();
                result += section;
                section = 0;
            } else {
                int unitNumber = number;
                if (0 == number && 0 == i) {
                    unitNumber = 1;
                }
                section += unitNumber * unit.value;
            }
            number = 0;
        }
        if (number > 0 && null != unit) {
            number *= unit.value / 10;
        }
        return result + section + number;
    }

    private static ChineseUnit chineseToUnit(char chinese) {
        for (ChineseUnit chineseNameValue : CHINESE_NAME_VALUE) {
            if (chineseNameValue.name != chinese) continue;
            return chineseNameValue;
        }
        return null;
    }

    private static int chineseToNumber(char chinese) {
        int i;
        if ('\u4e24' == chinese) {
            chinese = (char)20108;
        }
        return (i = NumberChineseUtil.indexOf(DIGITS, chinese)) > 0 ? (i + 1) / 2 : i;
    }

    public static int indexOf(char[] array, char value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        return NumberChineseUtil.format(amount, isUseTraditional, isMoneyMode, "\u8d1f", "\u5143");
    }

    private static String format(double amount, boolean isUseTraditional, boolean isMoneyMode, String negativeName, String unitName) {
        if (0.0 == amount) {
            return "\u96f6";
        }
        StringBuilder chineseStr = new StringBuilder();
        if (amount < 0.0) {
            chineseStr.append(NumberChineseUtil.isNullOrUndefined(negativeName) ? "\u8d1f" : negativeName);
            amount = -amount;
        }
        long yuan = Math.round(amount * 100.0);
        int fen = (int)(yuan % 10L);
        int jiao = (int)((yuan /= 10L) % 10L);
        if (!isMoneyMode || 0L != (yuan /= 10L)) {
            chineseStr.append(NumberChineseUtil.longToChinese(yuan, isUseTraditional));
            if (isMoneyMode) {
                chineseStr.append(NumberChineseUtil.isNullOrUndefined(unitName) ? "\u5143" : unitName);
            }
        }
        if (0 == jiao && 0 == fen) {
            if (isMoneyMode) {
                chineseStr.append("\u6574");
            }
            return chineseStr.toString();
        }
        if (!isMoneyMode) {
            chineseStr.append("\u70b9");
        }
        if (0L == yuan && 0 == jiao) {
            if (!isMoneyMode) {
                chineseStr.append("\u96f6");
            }
        } else {
            chineseStr.append(NumberChineseUtil.numberToChinese(jiao, isUseTraditional));
            if (isMoneyMode && 0 != jiao) {
                chineseStr.append("\u89d2");
            }
        }
        if (0 != fen) {
            chineseStr.append(NumberChineseUtil.numberToChinese(fen, isUseTraditional));
            if (isMoneyMode) {
                chineseStr.append("\u5206");
            }
        }
        return chineseStr.toString();
    }

    private static char numberToChinese(int number, boolean isUseTraditional) {
        if (0 == number) {
            return DIGITS[0];
        }
        return DIGITS[number * 2 - (isUseTraditional ? 0 : 1)];
    }

    private static String longToChinese(long amount, boolean isUseTraditional) {
        String partChinese;
        if (0L == amount) {
            return "\u96f6";
        }
        int[] parts = new int[4];
        int i = 0;
        while (amount != 0L) {
            parts[i] = (int)(amount % 10000L);
            amount /= 10000L;
            ++i;
        }
        StringBuilder chineseStr = new StringBuilder();
        int partValue = parts[0];
        if (partValue > 0) {
            partChinese = NumberChineseUtil.thousandToChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese);
            if (partValue < 1000) {
                NumberChineseUtil.addPreZero(chineseStr);
            }
        }
        if ((partValue = parts[1]) > 0) {
            if (partValue % 10 == 0 && parts[0] > 0) {
                NumberChineseUtil.addPreZero(chineseStr);
            }
            partChinese = NumberChineseUtil.thousandToChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4e07");
            if (partValue < 1000) {
                NumberChineseUtil.addPreZero(chineseStr);
            }
        } else {
            NumberChineseUtil.addPreZero(chineseStr);
        }
        if ((partValue = parts[2]) > 0) {
            if (partValue % 10 == 0 && parts[1] > 0) {
                NumberChineseUtil.addPreZero(chineseStr);
            }
            partChinese = NumberChineseUtil.thousandToChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4ebf");
            if (partValue < 1000) {
                NumberChineseUtil.addPreZero(chineseStr);
            }
        } else {
            NumberChineseUtil.addPreZero(chineseStr);
        }
        if ((partValue = parts[3]) > 0) {
            if (parts[2] == 0) {
                chineseStr.insert(0, "\u4ebf");
            }
            partChinese = NumberChineseUtil.thousandToChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4e07");
        }
        if (StringUtils.isNotEmpty((CharSequence)chineseStr) && '\u96f6' == chineseStr.charAt(0)) {
            return chineseStr.substring(1);
        }
        return chineseStr.toString();
    }

    private static void addPreZero(StringBuilder chineseStr) {
        if (StringUtils.isEmpty((CharSequence)chineseStr)) {
            return;
        }
        char c = chineseStr.charAt(0);
        if ('\u96f6' != c) {
            chineseStr.insert(0, '\u96f6');
        }
    }

    private static String thousandToChinese(int amountPart, boolean isUseTraditional) {
        if (amountPart == 0) {
            return String.valueOf(DIGITS[0]);
        }
        int temp = amountPart;
        StringBuilder chineseStr = new StringBuilder();
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr.insert(0, "\u96f6");
                }
                lastIsZero = true;
            } else {
                if (String.valueOf(NumberChineseUtil.numberToChinese(digit, isUseTraditional)).equals("\u4e00") && NumberChineseUtil.getUnitName(i, isUseTraditional).equals("\u5341")) {
                    chineseStr.insert(0, NumberChineseUtil.getUnitName(i, isUseTraditional));
                } else {
                    chineseStr.insert(0, NumberChineseUtil.numberToChinese(digit, isUseTraditional) + NumberChineseUtil.getUnitName(i, isUseTraditional));
                }
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr.toString();
    }

    private static String getUnitName(int index, boolean isUseTraditional) {
        if (0 == index) {
            return "";
        }
        return String.valueOf(NumberChineseUtil.CHINESE_NAME_VALUE[index * 2 - (isUseTraditional ? 0 : 1)].name);
    }

    public static boolean isNullOrUndefined(CharSequence str) {
        if (null == str) {
            return true;
        }
        return NumberChineseUtil.isNullOrUndefinedStr(str);
    }

    private static boolean isNullOrUndefinedStr(CharSequence str) {
        String strString = str.toString().trim();
        return NULL.equals(strString) || "undefined".equals(strString);
    }
}

