/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.utils;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import yem.wm.cn.weboffice.utils.HttpHelper;

public class FileViewUitl {
    private static final Log log = LogFactory.getLog(FileViewUitl.class);
    public static final String KEY_URL_CONVERT = "yunpan.previewUrl";
    public static final String tenantId = RequestContext.get().getTenantId();
    public static final String accountId = RequestContext.get().getAccountId();
    public static final String language = "zh_CN";

    public static ByteArrayInputStream saveAsPdf(String docFileId, long attId) throws Exception {
        String attachmentFullUrl = UrlService.getAttachmentFullUrl((String)docFileId);
        String encryptUrl = EncreptSessionUtils.encryptSession((String)attachmentFullUrl);
        String convertUrl = FileViewUitl.getCovertUrl();
        String httpUrl = String.format("%s/api/officeToPdf?download_url=%s&id=%s&ext=docx", convertUrl, FileViewUitl.getEncodeUrl(encryptUrl), attId);
        byte[] httpGet = HttpHelper.httpGet2(httpUrl, null);
        if (httpGet != null) {
            return new ByteArrayInputStream(httpGet);
        }
        throw new RuntimeException("\u6587\u4ef6\u8f6c\u6362PDF\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u89c8\u8f6c\u6362\u670d\u52a1\u662f\u5426\u6b63\u5e38\u3002");
    }

    public static String getEncodeUrl(String redirectUrl) {
        try {
            return URLEncoder.encode(redirectUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
            return redirectUrl;
        }
    }

    private static String getCovertUrl() {
        return System.getProperty(KEY_URL_CONVERT);
    }

    public static String getDefaultPath(String fileName) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String dateStr = new SimpleDateFormat("yyyyMM").format(new Date());
        return String.format("/%s/%s/%s/%s/%s/%s", tenantId, accountId, dateStr, uuid, "word2pdf", fileName);
    }
}

