/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice.form;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class WebOfficeBillEdit
extends AbstractBillPlugIn {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "webofficeconfig": {
                this.open(true);
                break;
            }
            case "webofficeprint": {
                this.open(false);
                break;
            }
        }
    }

    private void open(boolean isEdit) {
        DynamicObject bill = this.getModel().getDataEntity(true);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> entryInfo = new HashMap<String, Object>();
        entryInfo.put("yem_billId", bill.getLong("id"));
        entryInfo.put("yem_bill", bill.getDynamicObjectType().getName());
        entryInfo.put("isEdit", isEdit);
        entryInfo.put("attachmentpanel", "attachmentpanel");
        if (bill.containsProperty("yem_materialcomtable")) {
            entryInfo.put("yem_ismaterialcomtableid", true);
            entryInfo.put("yem_materialcomtableid", bill.getDynamicObject("yem_materialcomtable") == null ? 0L : bill.getDynamicObject("yem_materialcomtable").getLong("id"));
        }
        fsp.setCustomParams(entryInfo);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "yem_webofficemodelchoice");
        fsp.setCloseCallBack(callBack);
        fsp.setFormId("yem_webofficemodelchoice");
        IFormView view = this.getView();
        view.showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("yem_webofficemodelchoice".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public static class WebOfficeModelEdit
    extends AbstractBillPlugIn {
        public void afterCreateNewData(EventObject e) {
            super.afterCreateNewData(e);
            String tp_bill = (String)this.getView().getFormShowParameter().getCustomParam("tp_bill");
            this.getModel().setValue("tp_bill", (Object)tp_bill);
            IDataModel model = this.getModel();
            DynamicObject createorg = (DynamicObject)model.getValue("createorg");
            model.setValue("useorg", (Object)createorg);
            model.setValue("org", (Object)createorg);
        }

        public void afterBindData(EventObject e) {
            super.afterBindData(e);
        }

        public void afterDoOperation(AfterDoOperationEventArgs e) {
            String operateKey;
            super.afterDoOperation(e);
            boolean isSuccess = false;
            if (e.getOperationResult() != null) {
                isSuccess = e.getOperationResult().isSuccess();
            }
            if ("deletenew".equals(operateKey = e.getOperateKey())) {
                this.doDelete();
            }
        }

        private void doDelete() {
            long tp_billid = (Long)this.getModel().getValue("id");
            DynamicObject webofficemodel = BusinessDataServiceHelper.loadSingle((Object)tp_billid, (String)"tp_webofficemodel");
            String status = webofficemodel.getString("status");
            if ("B".equals(status)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (String)"WebOfficeBillEdit_0", (String)"yem-base", (Object[])new Object[0]));
                return;
            }
            if ("C".equals(status)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (String)"WebOfficeBillEdit_1", (String)"yem-base", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter1 = new QFilter("id", "=", webofficemodel.getPkValue());
            DeleteServiceHelper.delete((String)"tp_webofficemodel", (QFilter[])new QFilter[]{qFilter1});
            HashMap map = new HashMap();
            this.getView().returnDataToParent(map);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f!", (String)"WebOfficeBillEdit_2", (String)"yem-base", (Object[])new Object[0]));
            this.getView().close();
        }
    }
}

