/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice2.bill;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.YEM;
import yem.wm.cn.weboffice.utils.WebOfficeShowHelper;
import yem.wm.cn.weboffice.weboffice2.common.WebOfficeParam;
import yem.wm.cn.weboffice.weboffice2.common.wo.BasedataWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.EntityWO;
import yem.wm.cn.weboffice.weboffice2.utils.WebOfficeUtil;

public class WebOfficeBillPlugin
extends AbstractBillPlugIn
implements Plugin,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_fieldinput_d"});
        BasedataEdit weboffice = (BasedataEdit)this.getView().getControl("yem_weboffice");
        if (weboffice != null) {
            weboffice.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        String name = e.getProperty().getName();
        if ("yem_weboffice".equals(name)) {
            DynamicObject type = (DynamicObject)model.getValue("yem_modeltype");
            if (type != null) {
                DynamicObject dataEntity = model.getDataEntity(true);
                DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
                String entityKey = dynamicObjectType.getName();
                QFilter qFilter = new QFilter("yem_modeltype", "=", type.getPkValue());
                QFilter qFilter1 = new QFilter("yem_bill", "=", (Object)entityKey);
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter1);
            } else {
                this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5408\u540c\u6a21\u677f\u7c7b\u578b\u3002");
                e.setCancel(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.webOfficeVisibleInit();
        this.webOfficeEnableInit();
        this.webOfficeVisibleFileds();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int rowIndex = changeData[0].getRowIndex();
        switch (key) {
            case "yem_weboffice": {
                WebOfficeUtil.webofficeTplSelect((AbstractFormPlugin)this, false, rowIndex, null);
                this.webOfficeEnableInit();
                break;
            }
            case "yem_fieldinput_d": {
                WebOfficeUtil.webofficeTplSelect((AbstractFormPlugin)this, true, rowIndex, null);
                break;
            }
        }
    }

    private void webOfficeEnableInit() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
        if (dynamicObjectType.getProperties().containsKey((Object)"yem_webofficedyfields")) {
            DynamicObjectCollection entry = model.getEntryEntity("yem_webofficedyfields");
            for (int i = 0; i < entry.size(); ++i) {
                EntityWO entityWO;
                DynamicObject row = (DynamicObject)entry.get(i);
                String markJson = row.getString("yem_markjson_d_tag");
                if (StringUtils.isNotEmpty((String)markJson) && !((entityWO = EntityWO.get(markJson)) instanceof BasedataWO) && entityWO.isDynamic()) continue;
            }
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("yem_webofficedyfields");
            treeEntryGrid.setCollapse(false);
        }
    }

    private void webOfficeVisibleInit() {
        String[] webOfficeCtrlKeys = new String[]{"yem_webofficetabpage", "yem_webofficeflex", "yem_modeltype", "yem_weboffice", "yem_webofficedyfields", "yem_webofficeprint"};
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
        String entityKey = dynamicObjectType.getName();
        QFilter qFilter = new QFilter("yem_bill", "=", (Object)entityKey);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        DynamicObject modelBill = BusinessDataServiceHelper.loadSingleFromCache((String)"yem_webofficemodel2", (QFilter[])qFilter.toArray());
        view.setVisible(Boolean.valueOf(modelBill != null), webOfficeCtrlKeys);
    }

    private void webOfficeVisibleFileds() {
        String[] webOfficeCtrlKeys = new String[]{"yem_modeltype", "yem_weboffice"};
        IFormView view = this.getView();
        QFilter qFilter = new QFilter("yem_bill", "=", (Object)view.getEntityId());
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        DynamicObject[] modelBill = BusinessDataServiceHelper.load((String)"yem_webofficemodel2", (String)"id,yem_displaytype", (QFilter[])qFilter.toArray());
        List displaytype = Arrays.stream(modelBill).filter(x -> YEM.isNotEmpty((Object)x.getString("yem_displaytype"))).map(x -> x.getString("yem_displaytype")).distinct().collect(Collectors.toList());
        view.setVisible(Boolean.valueOf(displaytype.size() == 1 && ((String)displaytype.get(0)).equals("A") || displaytype.size() == 0), webOfficeCtrlKeys);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_fieldinput_d": {
                WebOfficeUtil.dynamicFieldInput((AbstractFormPlugin)this, key, "yem_webofficedyfields", "yem_markjson_d_tag", "yem_fieldinput_d", "yem_basedatatype_d", true);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (actionId != null) {
            switch (actionId) {
                case "yem_webofficemodelselect2": 
                case "yem_allweboffice": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "yem_fieldinput_d": 
                case "webofficeop_d": {
                    WebOfficeUtil.dynamicFieldCallBack((AbstractFormPlugin)this, event, "yem_webofficedyfields", "yem_markjson_d_tag", "yem_fieldinput_d", true);
                    this.webOfficeEnableInit();
                    break;
                }
                case "yem_webofficemodelselect": {
                    this.selectWebOffice(event);
                    break;
                }
            }
        }
    }

    private void selectWebOffice(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (returnData != null) {
            this.getModel().setValue("yem_weboffice", returnData.get("webofficeid"));
            DynamicObject webofficeid = BusinessDataServiceHelper.loadSingleFromCache(returnData.get("webofficeid"), (String)"yem_webofficemodel2");
            this.getModel().setValue("yem_weboffice", (Object)webofficeid.getDynamicObject("yem_modeltype"));
            WebOfficeUtil.webofficeTplSelect((AbstractFormPlugin)this, false, 0, null);
            this.webOfficeEnableInit();
            OperationResult result = this.getView().invokeOperation("save", YEM.getOptionNoMsg());
            if (!result.isSuccess()) {
                this.getView().showMessage("\u81ea\u52a8\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002\u539f\u56e0\uff1a" + YEM.getOpMsg((OperationResult)result));
                return;
            }
            DynamicObject bill = this.getModel().getDataEntity(true);
            long billId = bill.getLong("id");
            String billKey = bill.getDynamicObjectType().getName();
            String pageId = this.getView().getPageId();
            WebOfficeParam webOfficeParam = new WebOfficeParam(webofficeid.getLong("id"), billKey, billId, pageId, (Boolean)returnData.get("isEdit"));
            WebOfficeShowHelper.showEditForm((AbstractFormPlugin)this, webOfficeParam);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "webofficeop_d": {
                WebOfficeUtil.dynamicFieldInput((AbstractFormPlugin)this, key, "yem_webofficedyfields", "yem_markjson_d_tag", "yem_fieldinput_d", "yem_basedatatype_d", true);
                break;
            }
            case "webofficeop_c": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("yem_webofficedyfields");
                this.getModel().setValue("yem_fieldinput_d", (Object)"", rowIndex);
                break;
            }
            case "webofficeprint": {
                this.showWebOffice(false);
                break;
            }
            case "webofficeconfig": {
                this.showWebOffice(true);
                break;
            }
        }
    }

    private void showWebOffice(boolean isEdit) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        QFilter qFilter = new QFilter("yem_bill", "=", (Object)view.getEntityId());
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        DynamicObject[] modelBill = BusinessDataServiceHelper.load((String)"yem_webofficemodel2", (String)"id,yem_displaytype", (QFilter[])qFilter.toArray());
        List displaytype = Arrays.stream(modelBill).map(x -> x.getString("yem_displaytype")).distinct().collect(Collectors.toList());
        if (displaytype.size() != 1) {
            view.showTipNotification("\u6b64\u5355\u636e\u5173\u8054\u7684\u6a21\u677f\u663e\u793a\u5f62\u5f0f\u4e0d\u7edf\u4e00\uff0c\u8bf7\u68c0\u67e5\u3002");
            return;
        }
        DynamicObject bill = this.getModel().getDataEntity(true);
        long billId = bill.getLong("id");
        String billKey = bill.getDynamicObjectType().getName();
        String pageId = view.getPageId();
        if ("A".equals(displaytype.get(0))) {
            OperationResult result;
            DynamicObject webofficeTpl = (DynamicObject)model.getValue("yem_weboffice");
            if (webofficeTpl == null) {
                view.showTipNotification("\u8bf7\u5148\u9009\u62e9\u6a21\u677f\uff01");
                return;
            }
            DynamicObject entity = webofficeTpl.getDynamicObject("yem_bill");
            if (entity == null) {
                view.showTipNotification("\u6a21\u677f\u672a\u5173\u8054\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u3002");
                return;
            }
            BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
            BillOperationStatus billStatus = billShowParameter.getBillStatus();
            if (!(billStatus != BillOperationStatus.EDIT && billStatus != BillOperationStatus.ADDNEW || (result = view.invokeOperation("save", YEM.getOptionNoMsg())).isSuccess())) {
                view.showMessage("\u81ea\u52a8\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002\u539f\u56e0\uff1a" + YEM.getOpMsg((OperationResult)result));
                return;
            }
            WebOfficeParam webOfficeParam = new WebOfficeParam(webofficeTpl.getLong("id"), billKey, billId, pageId, isEdit);
            WebOfficeShowHelper.showEditForm((AbstractFormPlugin)this, webOfficeParam);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId("yem_webofficemodelselect2");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("yem_bill", billKey);
            customParams.put("isEdit", isEdit);
            showParameter.setCustomParams(customParams);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "yem_webofficemodelselect");
            showParameter.setCloseCallBack(callBack);
            view.showForm(showParameter);
        }
    }
}

