/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice2.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.ShowType;
import kd.bos.form.control.util.AttachmentParamUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.SystemParamUtil;

public class WebOfficeParam
implements Serializable {
    private boolean defaultView;
    private boolean yemOfficeView;
    private String yemOfficeAddr;
    private String yemOfficeAppId;
    private String yemOfficeAppSecret;
    private Long modelId;
    private Long billId;
    private String billKey;
    private boolean edit;
    private String pageId;
    private String fileName;
    private String fileId;
    private String saveAttachPanelKey;
    private int formShowType;
    private boolean showForm;
    private String showFormKey;

    public WebOfficeParam() {
        this.initSysParam();
    }

    public WebOfficeParam(Long modelId, String billKey, Long billId, String pageId, boolean isEdit) {
        this.initSysParam();
        this.modelId = modelId;
        this.billKey = billKey;
        this.billId = billId;
        this.edit = isEdit;
        this.pageId = pageId;
        if (modelId > 0L) {
            DynamicObject modelBill = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"yem_webofficemodel2");
            QFilter qFilter = new QFilter("finterid", "=", (Object)modelBill.getString("id"));
            qFilter.and("fbilltype", "=", (Object)"yem_webofficemodel2");
            qFilter.and("fattachmentpanel", "=", (Object)"yem_attachmentpanelap");
            DynamicObject attachment = BusinessDataServiceHelper.loadSingle((String)"bos_attachment", (String)"id,fattachmentname,ffileid,finterid", (QFilter[])qFilter.toArray());
            if (attachment != null) {
                this.fileName = attachment.getString("fattachmentname");
                this.fileId = attachment.getString("ffileid");
            }
            this.saveAttachPanelKey = modelBill.getString("yem_saveattachpanelkey");
            this.showFormKey = isEdit ? "yem_webofficenew2" : "yem_webofficepreview2";
        }
    }

    private void initSysParam() {
        Map appParams = SystemParamUtil.getAppParams((String)"yem_cn");
        String viewType = appParams.getOrDefault("yem_officeviewtype", "0");
        this.yemOfficeAddr = (String)appParams.get("yem_officeaddr");
        this.yemOfficeAppId = (String)appParams.get("yem_officeappid");
        this.yemOfficeAppSecret = (String)appParams.get("yem_officeappsecret");
        if ("1".equals(viewType)) {
            this.yemOfficeView = true;
            this.showForm = true;
            this.formShowType = ShowType.MainNewTabPage.getValue();
        } else {
            String editType;
            this.defaultView = true;
            switch (editType = AttachmentParamUtil.getEditType()) {
                case "11": 
                case "12": {
                    this.formShowType = ShowType.NewWindow.getValue();
                    break;
                }
                case "21": 
                case "22": {
                    this.showForm = true;
                    this.formShowType = ShowType.MainNewTabPage.getValue();
                    break;
                }
                default: {
                    this.formShowType = ShowType.NewWindow.getValue();
                }
            }
        }
    }

    public String toJSONString() {
        SerializerFeature[] serializerFeatures = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.PrettyFormat};
        return JSONObject.toJSONString((Object)this, (SerializerFeature[])serializerFeatures);
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public boolean isDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(boolean defaultView) {
        this.defaultView = defaultView;
    }

    public boolean isYemOfficeView() {
        return this.yemOfficeView;
    }

    public void setYemOfficeView(boolean yemOfficeView) {
        this.yemOfficeView = yemOfficeView;
    }

    public String getYemOfficeAddr() {
        return this.yemOfficeAddr;
    }

    public void setYemOfficeAddr(String yemOfficeAddr) {
        this.yemOfficeAddr = yemOfficeAddr;
    }

    public String getYemOfficeAppId() {
        return this.yemOfficeAppId;
    }

    public void setYemOfficeAppId(String yemOfficeAppId) {
        this.yemOfficeAppId = yemOfficeAppId;
    }

    public String getYemOfficeAppSecret() {
        return this.yemOfficeAppSecret;
    }

    public void setYemOfficeAppSecret(String yemOfficeAppSecret) {
        this.yemOfficeAppSecret = yemOfficeAppSecret;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getBillId() {
        return this.billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public String getBillKey() {
        return this.billKey;
    }

    public void setBillKey(String billKey) {
        this.billKey = billKey;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSaveAttachPanelKey() {
        return this.saveAttachPanelKey;
    }

    public void setSaveAttachPanelKey(String saveAttachPanelKey) {
        this.saveAttachPanelKey = saveAttachPanelKey;
    }

    public int getFormShowType() {
        return this.formShowType;
    }

    public void setFormShowType(int formShowType) {
        this.formShowType = formShowType;
    }

    public boolean isShowForm() {
        return this.showForm;
    }

    public void setShowForm(boolean showForm) {
        this.showForm = showForm;
    }

    public String getShowFormKey() {
        return this.showFormKey;
    }

    public void setShowFormKey(String showFormKey) {
        this.showFormKey = showFormKey;
    }
}

