/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice2.common.wo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.wm.cn.weboffice.weboffice2.common.wo.EntityWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.MuliLangTextWO;

public class BasedataWO
extends EntityWO {
    private String langType;
    private String baseDataType;
    private List<String> realValue = new ArrayList<String>();

    @Override
    public void dataEntity(DynamicObject dataEntity) {
        super.dataEntity(dataEntity);
        this.langType = dataEntity.getString("yem_langtype");
        DynamicObject baseData = dataEntity.getDynamicObject("yem_basedatatype_d");
        this.baseDataType = baseData != null ? baseData.getString("number") : "";
    }

    @Override
    public Map<String, Object> prepareConfigFields() {
        Map<String, Object> configFields = super.prepareConfigFields();
        configFields.put("yem_langtype", this.langType);
        configFields.put("yem_basedatatype_d", BasedataWO.getBaseDataType(this.baseDataType));
        return configFields;
    }

    public static DynamicObject getBaseDataType(String baseDataType) {
        QFilter qFilter = new QFilter("number", "=", (Object)baseDataType);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"yem_webofficebasedata2", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getRelBaseData(String relBaseData) {
        QFilter qFilter = new QFilter("number", "=", (Object)relBaseData);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"yem_webofficebasecobo2", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getBaseData(Object baseDataId) {
        QFilter qFilter = new QFilter("id", "=", baseDataId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"yem_webofficebasecobo2", (QFilter[])qFilter.toArray());
    }

    @Override
    public String formatValue(Object value) {
        value = MuliLangTextWO.getMuliLangText(value, this.langType);
        return super.formatValue(value);
    }

    public String getBaseDataType() {
        return this.baseDataType;
    }

    public void setBaseDataType(String baseDataType) {
        this.baseDataType = baseDataType;
    }

    public String getLangType() {
        return this.langType;
    }

    public void setLangType(String langType) {
        this.langType = langType;
    }

    public List<String> getRealValue() {
        return this.realValue;
    }

    public void setRealValue(List<String> realValue) {
        this.realValue = realValue;
    }
}

