/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice2.common.wo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import yem.base.common.utils.DateUtil;
import yem.wm.cn.weboffice.weboffice2.common.wo.EntityWO;

public class DateWO
extends EntityWO {
    private String dateformat;

    @Override
    public void dataEntity(DynamicObject dataEntity) {
        super.dataEntity(dataEntity);
        this.dateformat = dataEntity.getString("yem_dateformat");
    }

    @Override
    public Map<String, Object> prepareConfigFields() {
        Map<String, Object> configFields = super.prepareConfigFields();
        configFields.put("yem_dateformat", this.dateformat);
        return configFields;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)this.dateformat)) {
            this.dateformat = "yyyy-MM-dd";
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            switch (this.dateformat) {
                case "A": {
                    value = DateWO.date2ChineseYMD(date);
                    break;
                }
                case "B": {
                    value = DateWO.date2ChineseYM(date);
                    break;
                }
                case "C": {
                    value = DateWO.date2EnglishYMD(date);
                    break;
                }
                case "D": {
                    value = DateWO.date2EnglishYM(date);
                    break;
                }
                default: {
                    value = DateUtil.formatDate((Date)date, (String)this.dateformat);
                }
            }
        }
        return super.formatValue(value);
    }

    public static String date2ChineseYMD(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        return String.format("%s\u5e74%s\u6708%s\u65e5", year, month + 1, day);
    }

    public static String date2ChineseYM(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        return String.format("%s\u5e74%s\u6708", year, month + 1);
    }

    public static String date2EnglishYMD(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        String enMonth = DateWO.getEnMonth(month);
        return day + " " + enMonth + " ," + year;
    }

    public static String date2EnglishYM(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        String enMonth = DateWO.getEnMonth(month);
        return enMonth + "," + year;
    }

    private static String getEnMonth(int month) {
        ArrayList<String> months = new ArrayList<String>();
        months.add("January");
        months.add("February");
        months.add("March");
        months.add("April");
        months.add("May");
        months.add("June");
        months.add("July");
        months.add("August");
        months.add("September");
        months.add("October");
        months.add("November");
        months.add("December");
        return (String)months.get(month);
    }

    public String getDateformat() {
        return this.dateformat;
    }

    public void setDateformat(String dateformat) {
        this.dateformat = dateformat;
    }
}

