/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice2.common.wo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.CnUpperCaser;
import yem.wm.cn.weboffice.utils.NumberParserUtils;
import yem.wm.cn.weboffice.weboffice2.common.wo.EntityWO;

public class DecimalWO
extends EntityWO {
    private String mathtype;
    private int scale;

    @Override
    public void dataEntity(DynamicObject dataEntity) {
        super.dataEntity(dataEntity);
        this.mathtype = dataEntity.getString("yem_mathtype");
        this.scale = dataEntity.getInt("yem_scale");
    }

    @Override
    public Map<String, Object> prepareConfigFields() {
        Map<String, Object> configFields = super.prepareConfigFields();
        configFields.put("yem_mathtype", this.mathtype);
        configFields.put("yem_scale", this.scale);
        return configFields;
    }

    @Override
    public String formatValue(Object value) {
        BigDecimal bigDecimal = BigDecimalUtils.toBigDecimal((Object)value);
        bigDecimal = bigDecimal.setScale(this.scale, RoundingMode.HALF_UP);
        if (StringUtils.isEmpty((String)this.mathtype)) {
            this.mathtype = "A";
        }
        switch (this.mathtype) {
            case "A": {
                String zeroStr = "";
                if (this.scale != 0) {
                    zeroStr = "." + String.format("%0" + this.scale + "d", 0);
                }
                String pattern = "###,##0" + zeroStr;
                DecimalFormat df1 = new DecimalFormat(pattern);
                value = df1.format(bigDecimal);
                break;
            }
            case "ZH": {
                value = CnUpperCaser.getCnString((String)bigDecimal.toString());
                break;
            }
            case "EN": {
                String engNumber = NumberParserUtils.parse2(bigDecimal.toString());
                value = engNumber.toUpperCase();
                break;
            }
        }
        return super.formatValue(value);
    }

    public String getMathtype() {
        return this.mathtype;
    }

    public void setMathtype(String mathtype) {
        this.mathtype = mathtype;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }
}

