/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice2.common.wo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import yem.wm.cn.weboffice.weboffice2.common.wo.BasedataWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.DateWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.DecimalWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.EntryWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.MulBasedataWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.MuliLangTextWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.TextWO;

public class EntityWO
implements Serializable {
    protected static Log log = LogFactory.getLog(EntryWO.class);
    private String number;
    private String name;
    private String fullNumber;
    private String fullName;
    private String dataTypeNumber;
    private String dataTypeName;
    private String className = this.getClass().getSimpleName();
    private String bookmark;
    private boolean mustInput;
    private String defValue;
    private boolean writeBack;
    private boolean dynamic;
    private String relBaseData;

    public void dataEntity(DynamicObject dataEntity) {
        this.mustInput = dataEntity.getBoolean("yem_mustinput");
        this.writeBack = dataEntity.getBoolean("yem_writeback");
        this.defValue = dataEntity.getString("yem_fieldinput");
        DynamicObject baseData = dataEntity.getDynamicObject("yem_relbasedata_d");
        this.relBaseData = baseData != null ? baseData.getString("number") : "";
    }

    public Map<String, Object> prepareConfigFields() {
        HashMap<String, Object> configFields = new HashMap<String, Object>();
        configFields.put("yem_datatype", this.dataTypeNumber);
        configFields.put("yem_datatype_d", this.dataTypeNumber);
        configFields.put("yem_entitywo", this.className);
        configFields.put("yem_mustinput", this.mustInput);
        configFields.put("yem_fieldinput", this.defValue);
        configFields.put("yem_writeback", this.writeBack);
        configFields.put("yem_relbasedata_d", BasedataWO.getRelBaseData(this.relBaseData));
        return configFields;
    }

    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String checkConfig() {
        return "B";
    }

    public String toString() {
        return this.fullName + "\uff0c" + this.dataTypeName;
    }

    public static EntityWO get(String jsonString) {
        EntityWO entityWO;
        try {
            JSONObject jsonObject = JSON.parseObject((String)jsonString);
            String className = jsonObject.getString("className");
            if (StringUtils.isNotEmpty((String)className)) {
                JSONObject entityClass = EntityWO.getEntityClass();
                String classPath = entityClass.getString(className);
                entityWO = (EntityWO)JSON.parseObject((String)jsonString, Class.forName(classPath));
            } else {
                entityWO = (EntityWO)JSON.parseObject((String)jsonString, EntityWO.class);
            }
        }
        catch (Exception e) {
            log.error("parse EntityWO wrong: " + e.getMessage(), (Throwable)e);
            throw new KDBizException(new ErrorCode("", "parse EntityWO wrong: " + e.getMessage()), new Object[]{e});
        }
        return entityWO;
    }

    private static JSONObject getEntityClass() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(EntityWO.class.getSimpleName(), (Object)EntityWO.class.getName());
        jsonObject.put(EntryWO.class.getSimpleName(), (Object)EntryWO.class.getName());
        jsonObject.put(TextWO.class.getSimpleName(), (Object)TextWO.class.getName());
        jsonObject.put(MuliLangTextWO.class.getSimpleName(), (Object)MuliLangTextWO.class.getName());
        jsonObject.put(DecimalWO.class.getSimpleName(), (Object)DecimalWO.class.getName());
        jsonObject.put(DateWO.class.getSimpleName(), (Object)DateWO.class.getName());
        jsonObject.put(BasedataWO.class.getSimpleName(), (Object)BasedataWO.class.getName());
        jsonObject.put(MulBasedataWO.class.getSimpleName(), (Object)MulBasedataWO.class.getName());
        return jsonObject;
    }

    private static JSONObject getPropertyClass() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(TextProp.class.getSimpleName(), (Object)TextProp.class.getName());
        jsonObject.put(DecimalProp.class.getSimpleName(), (Object)DecimalProp.class.getName());
        jsonObject.put(IntegerProp.class.getSimpleName(), (Object)IntegerProp.class.getName());
        jsonObject.put(DateProp.class.getSimpleName(), (Object)DateProp.class.getName());
        jsonObject.put(BasedataProp.class.getSimpleName(), (Object)BasedataProp.class.getName());
        jsonObject.put(MulBasedataProp.class.getSimpleName(), (Object)MulBasedataProp.class.getName());
        return jsonObject;
    }

    public static EntityWO getByClassName(String className) {
        IDataEntityProperty prop;
        JSONObject jsonObject = EntityWO.getPropertyClass();
        String classPath = jsonObject.getString(className);
        if (StringUtils.isEmpty((String)classPath)) {
            classPath = TextProp.class.getName();
        }
        try {
            prop = (IDataEntityProperty)Class.forName(classPath).newInstance();
        }
        catch (Exception e) {
            log.error("get prop object wrong: " + e.getMessage(), (Throwable)e);
            throw new KDBizException(new ErrorCode("", "get prop object wrong: " + e.getMessage()), new Object[]{e});
        }
        return EntityWO.get(prop);
    }

    public static EntityWO get(IDataEntityProperty property) {
        if (property instanceof TextProp) {
            if (property instanceof MuliLangTextProp) {
                return new MuliLangTextWO();
            }
            return new TextWO();
        }
        if (property instanceof DecimalProp) {
            if (property instanceof PriceProp) {
                return new DecimalWO();
            }
            if (property instanceof AmountProp) {
                return new DecimalWO();
            }
            if (property instanceof IntegerProp) {
                return new DecimalWO();
            }
            return new DecimalWO();
        }
        if (property instanceof DateTimeProp) {
            return new DateWO();
        }
        if (property instanceof BooleanProp) {
            return new EntityWO();
        }
        if (property instanceof ComboProp) {
            return new EntityWO();
        }
        if (property instanceof PictureProp) {
            return new EntityWO();
        }
        if (property instanceof EntryProp) {
            return new EntryWO();
        }
        if (property instanceof BasedataProp) {
            return new BasedataWO();
        }
        if (property instanceof MulBasedataProp) {
            return new MulBasedataWO();
        }
        return new EntityWO();
    }

    public String toJSONString() {
        SerializerFeature[] serializerFeatures = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.PrettyFormat};
        return JSONObject.toJSONString((Object)this, (SerializerFeature[])serializerFeatures);
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullNumber() {
        return this.fullNumber;
    }

    public void setFullNumber(String fullNumber) {
        this.fullNumber = fullNumber;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getDataTypeNumber() {
        return this.dataTypeNumber;
    }

    public void setDataTypeNumber(String dataTypeNumber) {
        this.dataTypeNumber = dataTypeNumber;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public void setDataTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    public boolean isMustInput() {
        return this.mustInput;
    }

    public void setMustInput(boolean mustInput) {
        this.mustInput = mustInput;
    }

    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    public boolean isWriteBack() {
        return this.writeBack;
    }

    public void setWriteBack(boolean writeBack) {
        this.writeBack = writeBack;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getRelBaseData() {
        return this.relBaseData;
    }

    public void setRelBaseData(String relBaseData) {
        this.relBaseData = relBaseData;
    }
}

