/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice2.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeCloseListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeAfterClosedEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import yem.base.common.utils.YEM;
import yem.wm.cn.weboffice.utils.FileViewUitl;
import yem.wm.cn.weboffice.weboffice2.common.WebOfficeConstant;
import yem.wm.cn.weboffice.weboffice2.common.WebOfficeParam;
import yem.wm.cn.weboffice.weboffice2.common.wo.BasedataWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.DyEntityWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.EntityWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.EntryWO;
import yem.wm.cn.weboffice.weboffice2.utils.WebOfficeUtil;
import yem.wm.cn.weboffice.yemoffice.utils.YemOfficeCtrl;

public class WebOfficeDocEdit
extends AbstractFormPlugin
implements WebOfficeCloseListener,
WebOfficeDataListener,
RowClickEventListener,
UploadListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(WebOfficeDocEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        WebOffice webOffice = (WebOffice)this.getControl("yem_webofficeap");
        webOffice.addDataListener((WebOfficeDataListener)this);
        webOffice.addUploadListener((UploadListener)this);
        webOffice.addCloseListener((WebOfficeCloseListener)this);
        ((EntryGrid)this.getControl("yem_entryentity")).addRowClickListener((RowClickEventListener)this);
        ((EntryGrid)this.getControl("yem_entryentity1")).addRowClickListener((RowClickEventListener)this);
        ((EntryGrid)this.getControl("yem_webofficedyfields")).addRowClickListener((RowClickEventListener)this);
        ((EntryGrid)this.getControl("yem_webofficepreview")).addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"yem_toolbarap", "yem_toolbarap1", "yem_toolbarap2", "yem_toolbarap3", "yem_toolbarap4"});
        ((Tab)this.getControl("yem_tabap1")).addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"yem_fieldinput_p"});
    }

    private WebOfficeParam getWebOfficeParam() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String param = (String)showParameter.getCustomParam("yem_param");
        WebOfficeParam webOfficeParam = (WebOfficeParam)JSON.parseObject((String)param, WebOfficeParam.class);
        return webOfficeParam == null ? new WebOfficeParam() : webOfficeParam;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_webofficeap", "yem_yemofficeap"});
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        if (YEM.isEmpty((Object)webOfficeParam.getFileId())) {
            view.showMessage("\u672a\u7ef4\u62a4webOffice\u6a21\u677f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return;
        }
        if (webOfficeParam.isYemOfficeView()) {
            view.setVisible(Boolean.valueOf(true), new String[]{"yem_yemofficeap"});
            CustomControl control = (CustomControl)this.getControl("yem_yemofficeap");
            YemOfficeCtrl.init(control).iFrame();
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"yem_webofficeap"});
            String url = WebOfficeUtil.getFullPath(webOfficeParam.getFileId());
            WebOffice webOffice = (WebOffice)this.getControl("yem_webofficeap");
            webOffice.open(url);
            webOffice.setCaption(webOfficeParam.getFileName());
        }
        this.bindMarkData(webOfficeParam);
        if (webOfficeParam.isDefaultView()) {
            WebOffice webOffice = (WebOffice)this.getControl("yem_webofficeap");
            webOffice.sendOpenStatus();
        }
    }

    private void bindMarkData(WebOfficeParam webOfficeParam) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        long modelId = webOfficeParam.getModelId();
        if (modelId > 0L) {
            DynamicObject bill = WebOfficeDocEdit.getBookMarksBill(modelId);
            model.deleteEntryData("yem_entryentity");
            model.deleteEntryData("yem_entryentity1");
            model.deleteEntryData("yem_webofficedyfields");
            WebOfficeUtil.copyEntry(bill.getDynamicObjectCollection("yem_entryentity"), model.getEntryEntity("yem_entryentity"));
            WebOfficeUtil.copyEntry(bill.getDynamicObjectCollection("yem_entryentity1"), model.getEntryEntity("yem_entryentity1"));
            WebOfficeUtil.copyEntry(bill.getDynamicObjectCollection("yem_webofficedyfields"), model.getEntryEntity("yem_webofficedyfields"));
            view.updateView("yem_entryentity");
            view.updateView("yem_entryentity1");
            view.updateView("yem_webofficedyfields");
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("yem_entryentity1");
            treeEntryGrid.setCollapse(false);
            TreeEntryGrid treeEntryGrid1 = (TreeEntryGrid)this.getControl("yem_webofficedyfields");
            treeEntryGrid1.setCollapse(false);
            if (!webOfficeParam.isEdit()) {
                model.deleteEntryData("yem_webofficepreview");
                DynamicObjectCollection entry1 = bill.getDynamicObjectCollection("yem_entryentity");
                for (DynamicObject row : entry1) {
                    int index = model.createNewEntryRow("yem_webofficepreview");
                    String markJson = row.getString("yem_markjson_tag");
                    boolean writeBack = this.isWriteBack(markJson);
                    model.setValue("yem_bookmark_p", row.get("yem_bookmark"), index);
                    model.setValue("yem_writeback_p", (Object)writeBack, index);
                    model.setValue("yem_markjson_p", (Object)row.getString("yem_markjson"), index);
                    model.setValue("yem_markjson_p_tag", (Object)markJson, index);
                }
                DynamicObjectCollection entry2 = bill.getDynamicObjectCollection("yem_webofficedyfields");
                int pIndex = 0;
                for (DynamicObject row : entry2) {
                    int index;
                    long pid = row.getLong("pid");
                    if (pid != 0L) continue;
                    pIndex = index = model.createNewEntryRow("yem_webofficepreview");
                    String markJson = row.getString("yem_markjson_d_tag");
                    boolean writeBack = this.isWriteBack(markJson);
                    model.setValue("yem_bookmark_p", row.get("yem_bookmark_d"), index);
                    model.setValue("yem_writeback_p", (Object)writeBack, index);
                    model.setValue("yem_markjson_p", (Object)row.getString("yem_markjson_d"), index);
                    model.setValue("yem_markjson_p_tag", (Object)markJson, index);
                    model.setValue("yem_basedatatype_p", row.get("yem_basedatatype_d"), index);
                }
                DynamicObjectCollection entry3 = bill.getDynamicObjectCollection("yem_entryentity1");
                for (DynamicObject row : entry3) {
                    long pid = row.getLong("pid");
                    if (pid != 0L) continue;
                    int index = model.createNewEntryRow("yem_webofficepreview");
                    model.setValue("yem_bookmark_p", row.get("yem_bookmark1"), index);
                }
                view.updateView("yem_webofficepreview");
                ((TreeEntryGrid)this.getControl("yem_webofficepreview")).setCollapse(false);
            }
        }
    }

    private boolean isWriteBack(String markJson) {
        EntityWO entityWO;
        boolean writeBack = false;
        if (YEM.isNotEmpty((Object)markJson) && (entityWO = EntityWO.get(markJson)) != null) {
            writeBack = entityWO.isWriteBack();
        }
        return writeBack;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "yem_getallbookmarks": {
                this.getAllBookmarks();
                break;
            }
            case "yem_modifymarks": {
                this.setBookmarkData();
                break;
            }
            case "yem_saveconfig": {
                this.saveBookmarkRelation();
                break;
            }
            case "yem_marktable": {
                this.markTable("yem_entryentity1");
                break;
            }
            case "yem_markdynamic": {
                this.markTable("yem_webofficedyfields");
                break;
            }
            case "yem_marktext": {
                this.markText("yem_entryentity1");
                break;
            }
            case "yem_marktext1": {
                this.markText("yem_webofficedyfields");
                break;
            }
            case "yem_marktablefield": {
                this.markTableField(itemKey, "yem_entryentity1");
                break;
            }
            case "yem_markchildfield": {
                this.markTableField(itemKey, "yem_webofficedyfields");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (operateKey) {
                case "saveattach": {
                    this.saveAttach(true);
                    break;
                }
                case "saveasword": {
                    this.saveAttach(false);
                    break;
                }
                case "savedata": {
                    this.getTextByBookmark();
                    this.saveWordData();
                    break;
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_fieldinput_p": {
                WebOfficeUtil.dynamicFieldInput(this, key, "yem_webofficepreview", "yem_markjson_p_tag", "yem_fieldinput_p", "yem_basedatatype_p", true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int rowIndex = changeData[0].getRowIndex();
        switch (key) {
            case "yem_fieldinput_p": {
                String bookmark = (String)this.getModel().getValue("yem_bookmark_p", rowIndex);
                String value = (String)this.getModel().getValue("yem_fieldinput_p", rowIndex);
                WebOfficeMark webOfficeMark = new WebOfficeMark(bookmark, value);
                ArrayList<WebOfficeMark> billMarks = new ArrayList<WebOfficeMark>();
                billMarks.add(webOfficeMark);
                WebOfficeParam webOfficeParam = this.getWebOfficeParam();
                if (!webOfficeParam.isDefaultView()) break;
                WebOffice webOffice = (WebOffice)this.getControl("yem_webofficeap");
                webOffice.modifyMarks(billMarks);
                break;
            }
        }
    }

    private void getTextByBookmark() {
        IDataModel model = this.getModel();
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        DynamicObjectCollection entry = model.getEntryEntity("yem_webofficepreview");
        for (DynamicObject row : entry) {
            EntityWO entityWO;
            String bookmark_p = row.getString("yem_bookmark_p");
            String markJson = row.getString("yem_markjson_p_tag");
            if (YEM.isNotEmpty((Object)markJson) && (entityWO = EntityWO.get(markJson)) != null && !entityWO.isWriteBack()) continue;
        }
        if (webOfficeParam.isYemOfficeView()) {
            // empty if block
        }
    }

    private void saveWordData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        String yem_bill = webOfficeParam.getBillKey();
        long yem_billId = webOfficeParam.getBillId();
        if (YEM.isNotEmpty((Object)yem_bill) && YEM.isNotEmpty((Object)yem_billId)) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)yem_billId, (String)yem_bill);
            boolean isChanged = false;
            DataEntityPropertyCollection properties = bill.getDynamicObjectType().getProperties();
            DynamicObjectCollection entry = model.getEntryEntity("yem_webofficepreview");
            for (DynamicObject row : entry) {
                EntityWO entityWO;
                String bookmark_p = row.getString("yem_bookmark_p");
                String markJson = row.getString("yem_markjson_p_tag");
                String fieldinput_p = row.getString("yem_fieldinput_p");
                if (!YEM.isNotEmpty((Object)markJson) || (entityWO = EntityWO.get(markJson)) == null || !entityWO.isWriteBack()) continue;
                if (entityWO.isDynamic()) {
                    if (!properties.containsKey((Object)"yem_webofficedyfields")) continue;
                    DynamicObjectCollection dyEntry = bill.getDynamicObjectCollection("yem_webofficedyfields");
                    for (DynamicObject dyRow : dyEntry) {
                        String bookmark_d = dyRow.getString("yem_bookmark_d");
                        if (!bookmark_p.equals(bookmark_d)) continue;
                        dyRow.set("yem_fieldinput_d", (Object)fieldinput_p);
                        isChanged = true;
                    }
                    continue;
                }
                String number = entityWO.getNumber();
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)number);
                if (!(property instanceof TextProp)) continue;
                bill.set(number, (Object)fieldinput_p);
                isChanged = true;
            }
            if (isChanged) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                view.showSuccessNotification("\u652f\u6301\u53cd\u5199\u7684\u5185\u5bb9\u5df2\u66f4\u65b0\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u5237\u65b0\u5355\u636e\u67e5\u770b\u3002");
                this.refreshBill();
            } else {
                view.showTipNotification("\u65e0\u53ef\u53cd\u5199\u5b57\u6bb5\u3002");
            }
        }
    }

    private void refreshBill() {
        IFormView parentView;
        IFormView view = this.getView();
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        String pageId = webOfficeParam.getPageId();
        if (YEM.isNotEmpty((Object)pageId) && (parentView = view.getView(pageId)) != null) {
            parentView.invokeOperation("refresh");
            view.sendFormAction(parentView);
        }
    }

    private void saveAttach(boolean isPdf) {
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        IFormView view = this.getView();
        IPageCache pageCache = view.getPageCache();
        pageCache.put("isPdf", String.valueOf(isPdf));
        pageCache.put("clickSave", String.valueOf(true));
        String fileName = webOfficeParam.getFileName();
        if (StringUtils.isNotEmpty((String)fileName)) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            if (webOfficeParam.isYemOfficeView()) {
                CustomControl control = (CustomControl)this.getControl("yem_yemofficeap");
                YemOfficeCtrl.init(control).saveFile();
            } else {
                WebOffice webOffice = (WebOffice)this.getControl("yem_webofficeap");
                webOffice.save(fileName + "_" + new Date().getTime() + ".docx");
            }
            log.info("WebOffice.save execute");
        } else {
            view.showTipNotification("file name is empty.");
        }
    }

    private void markTable(String entryKey) {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("yem_entryentity");
        DynamicObject row = model.getEntryRowEntity("yem_entryentity", rowIndex);
        int newEntryRow = model.createNewEntryRow(entryKey);
        String key_s = WebOfficeConstant.getKey_s(entryKey);
        model.setValue("yem_bookmark" + key_s, row.get("yem_bookmark"), newEntryRow);
        if ("yem_webofficedyfields".equals(entryKey)) {
            model.setValue("yem_fieldname" + key_s, row.get("yem_bookmark"), newEntryRow);
        }
        model.deleteEntryRow("yem_entryentity", rowIndex);
        this.showFieldConfig("yem_entryentity");
    }

    private void markText(String entryKey) {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex(entryKey);
        DynamicObject row = model.getEntryRowEntity(entryKey, rowIndex);
        int newEntryRow = model.createNewEntryRow("yem_entryentity");
        String key_s = WebOfficeConstant.getKey_s(entryKey);
        model.setValue("yem_bookmark", row.get("yem_bookmark" + key_s), newEntryRow);
        model.deleteEntryRow(entryKey, rowIndex);
        this.showFieldConfig(entryKey);
    }

    private void markTableField(String key, String entryKey) {
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        String msg = "\u8bf7\u9009\u62e91\u7ea7\u4e66\u7b7e\u3002";
        if (selectRows != null && selectRows.length > 0) {
            int selectRow = selectRows[0];
            DynamicObject row = this.getModel().getEntryRowEntity(entryKey, selectRow);
            long pid = row.getLong("pid");
            if (pid == 0L) {
                Map cusMap = this.getView().getFormShowParameter().getCustomParams();
                cusMap.put("rowIndex", selectRow);
                cusMap.put("entryKey", entryKey);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("yem_webofficetablemark2");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                showParameter.setCustomParams(cusMap);
                view.showForm(showParameter);
            } else {
                view.showTipNotification(msg);
            }
        } else {
            view.showTipNotification(msg);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId != null && returnData != null) {
            switch (actionId) {
                case "yem_marktablefield": {
                    this.backTableFields((List)returnData, "yem_entryentity1");
                    break;
                }
                case "yem_markchildfield": {
                    this.backTableFields((List)returnData, "yem_webofficedyfields");
                    break;
                }
                case "yem_fieldinput_p": {
                    WebOfficeUtil.dynamicFieldCallBack(this, closedCallBackEvent, "yem_webofficepreview", "yem_markjson_p_tag", "yem_fieldinput_p", true);
                    break;
                }
            }
        }
    }

    private void backTableFields(List<String> bookmarks, String entryKey) {
        ArrayList<String> toleftmarks = new ArrayList<String>();
        IDataModel model = this.getModel();
        String key_s = WebOfficeConstant.getKey_s(entryKey);
        DynamicObjectCollection entry1 = model.getEntryEntity(entryKey);
        int rowIndex = model.getEntryCurrentRowIndex(entryKey);
        DynamicObject currRow = model.getEntryRowEntity(entryKey, rowIndex);
        long currRowId = currRow.getLong("id");
        for (DynamicObject row : entry1) {
            long pid = row.getLong("pid");
            String bookmark = row.getString("yem_bookmark" + key_s);
            if (pid != currRowId) continue;
            if (!bookmarks.contains(bookmark)) {
                toleftmarks.add(bookmark);
            }
            bookmarks.remove(bookmark);
        }
        int rowCount = model.getEntryRowCount(entryKey);
        for (int i = rowCount - 1; i >= 0; --i) {
            String bookmark = (String)model.getValue("yem_bookmark" + key_s, i);
            if (!toleftmarks.contains(bookmark)) continue;
            model.deleteEntryRow(entryKey, i);
        }
        for (String bookmark : bookmarks) {
            int index = model.insertEntryRow(entryKey, rowIndex);
            model.setValue("yem_bookmark" + key_s, (Object)bookmark, index);
            if (!"yem_webofficedyfields".equals(entryKey)) continue;
            model.setValue("yem_fieldname" + key_s, (Object)bookmark, index);
        }
        int rowCount1 = model.getEntryRowCount("yem_entryentity");
        for (int i = rowCount1 - 1; i >= 0; --i) {
            String bookmark = (String)model.getValue("yem_bookmark", i);
            if (!bookmarks.contains(bookmark)) continue;
            model.deleteEntryRow("yem_entryentity", i);
        }
        for (String bookmark : toleftmarks) {
            int index = model.createNewEntryRow("yem_entryentity");
            model.setValue("yem_bookmark", (Object)bookmark, index);
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(entryKey);
        treeEntryGrid.setCollapse(false);
    }

    private void autoSetBookmarkData() {
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        if (!webOfficeParam.isEdit()) {
            this.setBookmarkData();
        }
    }

    private void getAllBookmarks() {
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        if (webOfficeParam.isYemOfficeView()) {
            CustomControl control = (CustomControl)this.getControl("yem_yemofficeap");
            YemOfficeCtrl.init(control).getAllBookmarks();
        } else {
            WebOffice webOffice = (WebOffice)this.getControl("yem_webofficeap");
            webOffice.getAllBookmarks();
        }
    }

    private void setBookmarkData() {
        EntityWO entityWO;
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        IDataModel model = this.getModel();
        String billKey = webOfficeParam.getBillKey();
        long billId = webOfficeParam.getBillId();
        long modelId = webOfficeParam.getModelId();
        boolean isEdit = webOfficeParam.isEdit();
        DynamicObject tplBill = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"yem_webofficemodel2");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billKey);
        ArrayList<EntityWO> entityWOs = new ArrayList<EntityWO>();
        DynamicObjectCollection entry = model.getEntryEntity("yem_entryentity");
        for (DynamicObject row : entry) {
            String bookmark = row.getString("yem_bookmark");
            String markJson = row.getString("yem_markjson_tag");
            if (!StringUtils.isNotEmpty((String)markJson)) continue;
            EntityWO entityWO2 = EntityWO.get(markJson);
            entityWO2.setBookmark(bookmark);
            entityWOs.add(entityWO2);
        }
        HashMap<Long, EntryWO> pMap = new HashMap<Long, EntryWO>();
        DynamicObjectCollection entry1 = model.getEntryEntity("yem_entryentity1");
        for (DynamicObject row : entry1) {
            EntryWO entryWO;
            long pid = row.getLong("pid");
            long pkId = row.getLong("id");
            String bookmark = row.getString("yem_bookmark1");
            String markJson = row.getString("yem_markjson1_tag");
            if (pid == 0L) {
                if (!StringUtils.isNotEmpty((String)markJson)) continue;
                entryWO = (EntryWO)EntityWO.get(markJson);
                entryWO.setBookmark(bookmark);
                pMap.put(pkId, entryWO);
                continue;
            }
            entryWO = (EntryWO)pMap.get(pid);
            if (entryWO == null) continue;
            List<EntityWO> cells = entryWO.getCells();
            if (cells == null) {
                cells = new ArrayList<EntityWO>();
            }
            entityWO = StringUtils.isNotEmpty((String)markJson) ? EntityWO.get(markJson) : new EntityWO();
            entityWO.setBookmark(bookmark);
            cells.add(entityWO);
            entryWO.setCells(cells);
        }
        HashMap<Long, DyEntityWO> pMap2 = new HashMap<Long, DyEntityWO>();
        DynamicObjectCollection entry2 = model.getEntryEntity("yem_webofficedyfields");
        for (DynamicObject row : entry2) {
            long pid = row.getLong("pid");
            long pkId = row.getLong("id");
            String bookmark = row.getString("yem_bookmark_d");
            String markJson = row.getString("yem_markjson_d_tag");
            if (pid == 0L) {
                if (!StringUtils.isNotEmpty((String)markJson)) continue;
                entityWO = EntityWO.get(markJson);
                entityWO.setBookmark(bookmark);
                DyEntityWO dyEntityWO = new DyEntityWO(entityWO, new ArrayList<EntityWO>());
                pMap2.put(pkId, dyEntityWO);
                continue;
            }
            DyEntityWO dyEntityWO = (DyEntityWO)pMap2.get(pid);
            if (dyEntityWO == null) continue;
            List<EntityWO> cells = dyEntityWO.getEntityWOS();
            if (cells == null) {
                cells = new ArrayList<EntityWO>();
            }
            if (!StringUtils.isNotEmpty((String)markJson)) continue;
            EntityWO entityWO3 = EntityWO.get(markJson);
            entityWO3.setBookmark(bookmark);
            cells.add(entityWO3);
            dyEntityWO.setEntityWOS(cells);
        }
        this.modifyMarks(entityWOs, pMap.values(), pMap2.values(), bill, tplBill, webOfficeParam);
    }

    private void modifyMarks(Collection<EntityWO> entityWOs, Collection<EntryWO> entryWOS, Collection<DyEntityWO> dyEntityWOS, DynamicObject bill, DynamicObject tplBill, WebOfficeParam webOfficeParam) {
        String bookmark;
        String markValue;
        String lockType = tplBill.getString("yem_locktype");
        String password = tplBill.getString("yem_password");
        boolean unLimitDoc = false;
        boolean limitDoc = false;
        if ("B".equals(lockType)) {
            limitDoc = true;
        } else if ("C".equals(lockType)) {
            limitDoc = true;
            unLimitDoc = true;
        }
        if (unLimitDoc && webOfficeParam.isDefaultView()) {
            WebOffice webOffice2 = (WebOffice)this.getControl("yem_webofficeap");
            webOffice2.unLimitDoc(password);
        }
        ArrayList<WebOfficeMark> billMarks = new ArrayList<WebOfficeMark>();
        for (EntityWO entityWO : entityWOs) {
            String bookmark2 = entityWO.getBookmark();
            String fullNumber = entityWO.getFullNumber();
            Object value = this.getFieldValue(fullNumber, bill);
            markValue = entityWO.formatValue(value);
            WebOfficeMark webOfficeMark = new WebOfficeMark(bookmark2, markValue);
            billMarks.add(webOfficeMark);
        }
        for (DyEntityWO dyEntityWO : dyEntityWOS) {
            EntityWO entityWO = dyEntityWO.getEntityWO();
            List<EntityWO> childEntitys = dyEntityWO.getEntityWOS();
            bookmark = entityWO.getBookmark();
            markValue = this.formatDyEntityValue(bill, entityWO, bookmark);
            ArrayList<String> childMarkValues = new ArrayList<String>();
            if (childEntitys != null) {
                List<String> realValue = this.getBasedataSelectValue(bill, entityWO, bookmark);
                for (EntityWO childEntity : childEntitys) {
                    if (WebOfficeUtil.isNotRelBasedata(childEntity, realValue, false)) continue;
                    String bookmark_s = childEntity.getBookmark();
                    String childMarkValue = this.formatDyEntityValue(bill, childEntity, bookmark_s);
                    childMarkValues.add(childMarkValue);
                }
            }
            int count = markValue.split("%s").length - 1;
            for (int i = childMarkValues.size(); i < count; ++i) {
                childMarkValues.add("");
            }
            if (!childMarkValues.isEmpty()) {
                markValue = String.format(markValue, childMarkValues.toArray());
            }
            WebOfficeMark webOfficeMark = new WebOfficeMark(bookmark, markValue);
            billMarks.add(webOfficeMark);
        }
        LinkedHashMap<String, String[][]> tableRows = new LinkedHashMap<String, String[][]>();
        for (EntryWO entryWO : entryWOS) {
            String bookmark3 = entryWO.getBookmark();
            List<List<String>> tableValue = this.getTableValue(entryWO, bill);
            String[][] data = new String[tableValue.size()][entryWO.getCells().size()];
            for (int i = 0; i < tableValue.size(); ++i) {
                List<String> tableRow = tableValue.get(i);
                for (int j = 0; j < tableRow.size(); ++j) {
                    String value;
                    data[i][j] = value = tableRow.get(j);
                }
            }
            billMarks.addAll(entryWO.getBillMarks());
            tableRows.put(bookmark3, data);
        }
        if (!billMarks.isEmpty()) {
            Map<String, List<WebOfficeMark>> map = billMarks.stream().collect(Collectors.groupingBy(WebOfficeMark::getField));
            if (!webOfficeParam.isEdit()) {
                DynamicObjectCollection entry = this.getModel().getEntryEntity("yem_webofficepreview");
                for (int i = 0; i < entry.size(); ++i) {
                    DynamicObject row = (DynamicObject)entry.get(i);
                    String bookmark4 = row.getString("yem_bookmark_p");
                    List<WebOfficeMark> webOfficeMarks = map.get(bookmark4);
                    if (webOfficeMarks == null) continue;
                    String value = webOfficeMarks.get(0).getValue();
                    this.getModel().setValue("yem_fieldinput_p", (Object)value, i);
                    this.getView().updateView("yem_fieldinput_p", i);
                }
            }
        }
        if (webOfficeParam.isYemOfficeView()) {
            CustomControl customControl = (CustomControl)this.getControl("yem_yemofficeap");
            YemOfficeCtrl.init(customControl).modifyAllMarks(billMarks, tableRows);
        } else {
            WebOffice webOffice = (WebOffice)this.getControl("yem_webofficeap");
            if (!billMarks.isEmpty()) {
                webOffice.modifyMarks(billMarks);
                for (Map.Entry entry : tableRows.entrySet()) {
                    bookmark = (String)entry.getKey();
                    String[][] value = (String[][])entry.getValue();
                    webOffice.addTableRows(bookmark, value);
                }
            }
        }
        if (limitDoc && webOfficeParam.isDefaultView()) {
            WebOffice webOffice = (WebOffice)this.getControl("yem_webofficeap");
            webOffice.limitDoc(password);
        }
    }

    private List<String> getBasedataSelectValue(DynamicObject bill, EntityWO entityWO, String bookmark) {
        List<String> realValue = new ArrayList<String>();
        if (entityWO instanceof BasedataWO && entityWO.isDynamic() && bill.getDynamicObjectType().getProperties().containsKey((Object)"yem_webofficedyfields")) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("yem_webofficedyfields");
            for (DynamicObject row : entry) {
                EntityWO entityWO_S;
                String markJson;
                String bookmark_d = row.getString("yem_bookmark_d");
                if (!bookmark_d.equals(bookmark) || !StringUtils.isNotEmpty((String)(markJson = row.getString("yem_markjson_d_tag"))) || !((entityWO_S = EntityWO.get(markJson)) instanceof BasedataWO)) continue;
                BasedataWO basedataWO = (BasedataWO)entityWO_S;
                realValue = basedataWO.getRealValue();
            }
        }
        return realValue;
    }

    private String formatDyEntityValue(DynamicObject bill, EntityWO entityWO, String bookmark) {
        Object value = "";
        if (entityWO.isDynamic()) {
            if (bill.getDynamicObjectType().getProperties().containsKey((Object)"yem_webofficedyfields")) {
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("yem_webofficedyfields");
                for (DynamicObject row : entry) {
                    String bookmark_d = row.getString("yem_bookmark_d");
                    if (!bookmark_d.equals(bookmark)) continue;
                    value = row.get("yem_fieldinput_d");
                }
            }
        } else {
            String fullNumber = entityWO.getFullNumber();
            value = this.getFieldValue(fullNumber, bill);
        }
        return entityWO.formatValue(value);
    }

    private List<List<String>> getTableValue(EntryWO entryWO, DynamicObject bill) {
        DynamicObjectCollection entry;
        int index = 0;
        ArrayList<WebOfficeMark> billMarks = new ArrayList<WebOfficeMark>();
        ArrayList<List<String>> tableRows = new ArrayList<List<String>>();
        String entryNumber = entryWO.getFullNumber();
        List<EntityWO> cells = entryWO.getCells();
        String[] entryKeys = entryNumber.split("\\.");
        if (entryKeys.length == 1) {
            entry = bill.getDynamicObjectCollection(entryKeys[0]);
            for (DynamicObject row : entry) {
                ArrayList<String> tableRow = new ArrayList<String>();
                for (EntityWO cell : cells) {
                    String markValue = "";
                    String fullNumber = cell.getFullNumber();
                    if (StringUtils.isNotEmpty((String)fullNumber)) {
                        Object value;
                        String prefix = entryKeys[0] + ".";
                        if (fullNumber.startsWith(prefix)) {
                            fullNumber = fullNumber.replace(prefix, "");
                            value = this.getFieldValue(fullNumber, row);
                        } else {
                            value = this.getFieldValue(fullNumber, bill);
                        }
                        markValue = cell.formatValue(value);
                    }
                    if (index == 0) {
                        String bookmark = cell.getBookmark();
                        WebOfficeMark webOfficeMark = new WebOfficeMark(bookmark, markValue);
                        billMarks.add(webOfficeMark);
                    }
                    tableRow.add(markValue);
                }
                if (index++ <= 0) continue;
                tableRows.add(tableRow);
            }
        }
        if (entryKeys.length == 2) {
            entry = bill.getDynamicObjectCollection(entryKeys[0]);
            for (DynamicObject row : entry) {
                DynamicObjectCollection subEntry = bill.getDynamicObjectCollection(entryKeys[1]);
                for (DynamicObject subRow : subEntry) {
                    ArrayList<String> tableRow = new ArrayList<String>();
                    for (EntityWO cell : cells) {
                        String markValue = "";
                        String fullNumber = cell.getFullNumber();
                        if (StringUtils.isNotEmpty((String)fullNumber)) {
                            Object value;
                            String prefix = entryKeys[0] + ".";
                            String prefix_sub = entryNumber + ".";
                            if (fullNumber.startsWith(prefix_sub)) {
                                fullNumber = fullNumber.replace(prefix_sub, "");
                                value = this.getFieldValue(fullNumber, subRow);
                            } else if (fullNumber.startsWith(prefix)) {
                                fullNumber = fullNumber.replace(prefix, "");
                                value = this.getFieldValue(fullNumber, row);
                            } else {
                                value = this.getFieldValue(fullNumber, bill);
                            }
                            markValue = cell.formatValue(value);
                        }
                        tableRow.add(markValue);
                        if (index != 0) continue;
                        String bookmark = cell.getBookmark();
                        WebOfficeMark webOfficeMark = new WebOfficeMark(bookmark, markValue);
                        billMarks.add(webOfficeMark);
                    }
                    if (index++ <= 0) continue;
                    tableRows.add(tableRow);
                }
            }
        }
        entryWO.setBillMarks(billMarks);
        return tableRows;
    }

    private Object getFieldValue(String fullNumber, DynamicObject bill) {
        Object value = null;
        String[] fields = fullNumber.split("\\.");
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (i == 0) {
                value = bill.get(field);
                continue;
            }
            if (value == null) {
                return value;
            }
            if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).get(field);
                continue;
            }
            if (!(value instanceof DynamicObjectCollection)) continue;
            DynamicObjectCollection dyObjs = (DynamicObjectCollection)value;
            if (dyObjs.isEmpty()) {
                value = "";
                break;
            }
            value = ((DynamicObject)dyObjs.get(0)).get(field);
        }
        return value;
    }

    private void saveBookmarkRelation() {
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        IDataModel model = this.getModel();
        long modelId = webOfficeParam.getModelId();
        if (modelId > 0L) {
            DynamicObject bill = WebOfficeDocEdit.getBookMarksBill(modelId);
            bill.set("yem_webofficemodel2", (Object)modelId);
            bill.set("status", (Object)"A");
            bill.set("enable", (Object)"1");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("yem_entryentity");
            WebOfficeUtil.copyEntry(model.getEntryEntity("yem_entryentity"), entry);
            WebOfficeUtil.copyEntry(model.getEntryEntity("yem_entryentity1"), bill.getDynamicObjectCollection("yem_entryentity1"));
            WebOfficeUtil.copyEntry(model.getEntryEntity("yem_webofficedyfields"), bill.getDynamicObjectCollection("yem_webofficedyfields"));
            DynamicObjectCollection dyFieldEntry = bill.getDynamicObjectCollection("yem_webofficedyfields");
            String key_s = WebOfficeConstant.getKey_s("yem_webofficedyfields");
            String tag = "_tag";
            for (DynamicObject row : dyFieldEntry) {
                String markJson = row.getString("yem_markjson" + key_s + tag);
                if (!StringUtils.isNotEmpty((String)markJson)) continue;
                EntityWO entityWO = EntityWO.get(markJson);
                row.set("yem_datatype" + key_s, (Object)entityWO.getDataTypeNumber());
                row.set("yem_fieldinput" + key_s, (Object)entityWO.getDefValue());
                if (entityWO instanceof BasedataWO) {
                    BasedataWO basedataWO = (BasedataWO)entityWO;
                    row.set("yem_basedatatype" + key_s, (Object)BasedataWO.getBaseDataType(basedataWO.getBaseDataType()));
                } else {
                    row.set("yem_basedatatype" + key_s, null);
                }
                row.set("yem_mustinput" + key_s, (Object)entityWO.isMustInput());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f\uff01");
        }
    }

    private static DynamicObject getBookMarksBill(long modelId) {
        QFilter qFilter = new QFilter("yem_webofficemodel2", "=", (Object)modelId);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"yem_webofficemarks2", (String)"id", (QFilter[])qFilter.toArray());
        bill = bill != null ? BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"yem_webofficemarks2") : BusinessDataServiceHelper.newDynamicObject((String)"yem_webofficemarks2");
        return bill;
    }

    public void entryRowClick(RowClickEvent evt) {
        String entryKey;
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        switch (entryKey = entryGrid.getEntryKey()) {
            case "yem_entryentity": 
            case "yem_entryentity1": 
            case "yem_webofficedyfields": {
                this.locateMark(entryKey);
                this.showFieldConfig(entryKey);
                break;
            }
            case "yem_webofficepreview": {
                this.locateMark(entryKey);
                break;
            }
        }
    }

    private void locateMark(String entryKey) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            String key_s = WebOfficeConstant.getKey_s(entryKey);
            String bookmark = (String)this.getModel().getValue("yem_bookmark" + key_s, selectRows[0]);
            WebOfficeParam webOfficeParam = this.getWebOfficeParam();
            if (webOfficeParam.isYemOfficeView()) {
                CustomControl control = (CustomControl)this.getControl("yem_yemofficeap");
                YemOfficeCtrl.init(control).locateMark(bookmark);
            } else {
                WebOffice webOffice = (WebOffice)this.getControl("yem_webofficeap");
                webOffice.locateMark(bookmark);
            }
        }
    }

    private void showFieldConfig(String entryKey) {
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            String key_s = WebOfficeConstant.getKey_s(entryKey);
            String bookmark = (String)this.getModel().getValue("yem_bookmark" + key_s, selectRows[0]);
            Map cusMap = this.getView().getFormShowParameter().getCustomParams();
            cusMap.put("entryKey", entryKey);
            cusMap.put("bookmark", bookmark);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("yem_webofficebookmark");
            String formId = "yem_webofficedyfields".equals(entryKey) ? "yem_webofficebookmark2_d" : "yem_webofficebookmark2";
            showParameter.setFormId(formId);
            showParameter.setCustomParams(cusMap);
            view.showForm(showParameter);
        } else {
            String markPageId = (String)this.getModel().getValue("yem_markpageid");
            IFormView subView = view.getView(markPageId);
            if (subView != null) {
                subView.close();
                view.sendFormAction(subView);
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "yem_tabpageap1": {
                this.showFieldConfig("yem_entryentity");
                break;
            }
            case "yem_tabpageap2": {
                this.showFieldConfig("yem_entryentity1");
                break;
            }
            case "yem_tabpageap3": {
                this.showFieldConfig("yem_webofficedyfields");
                break;
            }
        }
    }

    private void onGetAllBookmarks(List<String> bookmarks) {
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.deleteEntryData("yem_entryentity");
        model.deleteEntryData("yem_entryentity1");
        model.deleteEntryData("yem_webofficedyfields");
        long modelId = webOfficeParam.getModelId();
        if (bookmarks != null && modelId > 0L) {
            DynamicObject bill = WebOfficeDocEdit.getBookMarksBill(modelId);
            DynamicObjectCollection fromEntry = bill.getDynamicObjectCollection("yem_entryentity");
            DataEntityPropertyCollection fromProperties = fromEntry.getDynamicObjectType().getProperties();
            DataEntityPropertyCollection toProperties = model.getEntryEntity("yem_entryentity").getDynamicObjectType().getProperties();
            for (DynamicObject fromRow : fromEntry) {
                String bookmark = fromRow.getString("yem_bookmark");
                if (!bookmarks.contains(bookmark)) continue;
                int index = model.createNewEntryRow("yem_entryentity");
                for (IDataEntityProperty property : toProperties) {
                    String key = property.getName();
                    if (!fromProperties.containsKey((Object)key) || !WebOfficeUtil.couldModelSetField(key)) continue;
                    model.setValue(key, fromRow.get(key), index);
                }
                bookmarks.remove(bookmark);
            }
            this.resetTreeMarks(bookmarks, bill, "yem_entryentity1");
            this.resetTreeMarks(bookmarks, bill, "yem_webofficedyfields");
            for (String bookmark : bookmarks) {
                int index = model.createNewEntryRow("yem_entryentity");
                model.setValue("yem_bookmark", (Object)bookmark, index);
            }
        }
    }

    private void resetTreeMarks(List<String> bookmarks, DynamicObject bill, String entryKey) {
        IDataModel model = this.getModel();
        String key_s = WebOfficeConstant.getKey_s(entryKey);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(entryKey);
        treeEntryGrid.setCollapse(false);
        DynamicObjectCollection fromEntry1 = bill.getDynamicObjectCollection(entryKey);
        DataEntityPropertyCollection fromProperties1 = fromEntry1.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection toProperties1 = model.getEntryEntity(entryKey).getDynamicObjectType().getProperties();
        HashMap<Long, Integer> pMap = new HashMap<Long, Integer>();
        for (DynamicObject fromRow : fromEntry1) {
            int index;
            String bookmark = fromRow.getString("yem_bookmark" + key_s);
            long pid = fromRow.getLong("pid");
            if (!bookmarks.contains(bookmark)) continue;
            if (pid == 0L) {
                index = model.createNewEntryRow(entryKey);
                pMap.put(fromRow.getLong("id"), index);
            } else {
                if (!pMap.containsKey(pid)) continue;
                index = model.insertEntryRow(entryKey, ((Integer)pMap.get(pid)).intValue());
            }
            for (IDataEntityProperty property : toProperties1) {
                String key = property.getName();
                if (!fromProperties1.containsKey((Object)key) || !WebOfficeUtil.couldModelSetField(key)) continue;
                model.setValue(key, fromRow.get(key), index);
            }
            bookmarks.remove(bookmark);
        }
    }

    private void saveFile(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        IFormView view = this.getView();
        IPageCache pageCache = view.getPageCache();
        String isPdfParam = pageCache.get("isPdf");
        boolean isPdf = true;
        if (YEM.isNotEmpty((Object)isPdfParam)) {
            isPdf = Boolean.parseBoolean(isPdfParam);
        }
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        String billKey = webOfficeParam.getBillKey();
        long billId = webOfficeParam.getBillId();
        String saveAttachPanelKey = webOfficeParam.getSaveAttachPanelKey();
        String modelFileName = webOfficeParam.getFileName();
        try {
            String fileNameTag = new Date().getTime() + "";
            DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)billKey);
            if (bill != null) {
                DataEntityPropertyCollection properties = bill.getDynamicObjectType().getProperties();
                if (properties.containsKey((Object)"billno")) {
                    fileNameTag = bill.getString("billno");
                } else if (properties.containsKey((Object)"number")) {
                    fileNameTag = bill.getString("number");
                }
            }
            String yem_fileName = modelFileName.substring(0, modelFileName.lastIndexOf("."));
            String fileName = fileNameTag + "_" + yem_fileName;
            String extName = "docx";
            if (modelFileName.endsWith(".doc")) {
                extName = "doc";
            }
            String path = WebOfficeUtil.getFilePath(fileName + "." + extName);
            String fileSipName = fileName;
            fileName = URLEncoder.encode(fileName, "utf-8");
            fileName = fileName + "." + extName;
            FileService service = FileServiceFactory.getAttachmentFileService();
            if (isPdf) {
                FileItem wordFileItem = new FileItem(fileName, path, inputStream);
                wordFileItem.setCreateNewFileWhenExists(true);
                String docFileId = service.upload(wordFileItem);
                long pdfId = ORM.create().genLongId("bos_attachment");
                String pdfFileName = fileSipName + ".pdf";
                ByteArrayInputStream byteInputStream = FileViewUitl.saveAsPdf(docFileId, pdfId);
                int available = byteInputStream.available();
                FileItem pdfFileItem = new FileItem(pdfFileName, WebOfficeUtil.getFilePath(pdfFileName), (InputStream)byteInputStream);
                pdfFileItem.setCreateNewFileWhenExists(true);
                String fileId = service.upload(pdfFileItem);
                WebOfficeDocEdit.saveAttachment(pdfId, billKey, billId, pdfFileName, available, saveAttachPanelKey, fileId, extName);
            } else {
                long wordId = ORM.create().genLongId("bos_attachment");
                int size = inputStream.available();
                FileItem wordFileItem = new FileItem(fileName, path, inputStream);
                wordFileItem.setCreateNewFileWhenExists(true);
                String docFileId = service.upload(wordFileItem);
                WebOfficeDocEdit.saveAttachment(wordId, billKey, billId, fileName, size, saveAttachPanelKey, docFileId, extName);
            }
            view.showMessage("\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff0c\u8bf7\u624b\u52a8\u5237\u65b0\u754c\u9762\u67e5\u770b\u3002");
            log.info("WebOffice saveFile end ");
            this.refreshBill();
        }
        catch (Exception e) {
            view.showErrorNotification(String.format("\u6587\u4ef6\u4fdd\u5b58\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", e.getMessage()));
            log.error("WebOffice saveFile error", (Throwable)e);
        }
    }

    private static void saveAttachment(long attId, String yem_bill, long yem_billId, String pdfFileName, int available, String attachmentpanel, String fileId, String extName) throws UnsupportedEncodingException {
        DynamicObject bos_attachment = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        Date today = new Date();
        bos_attachment.set("id", (Object)attId);
        bos_attachment.set("FNUMBER", (Object)("rc-upload-" + attId));
        bos_attachment.set("FBillType", (Object)yem_bill);
        bos_attachment.set("FInterID", (Object)yem_billId);
        bos_attachment.set("FModifyTime", (Object)today);
        bos_attachment.set("fcreatetime", (Object)today);
        pdfFileName = URLDecoder.decode(pdfFileName, "utf-8");
        bos_attachment.set("FaliasFileName", (Object)pdfFileName);
        bos_attachment.set("FAttachmentName", (Object)pdfFileName);
        bos_attachment.set("FExtName", (Object)extName);
        bos_attachment.set("FATTACHMENTSIZE", (Object)available);
        bos_attachment.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
        bos_attachment.set("fattachmentpanel", (Object)attachmentpanel);
        bos_attachment.set("fdescription", (Object)"");
        bos_attachment.set("FFileId", (Object)fileId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bos_attachment});
    }

    public void onGetAllBookmarks(WebOfficeBookmarkEvent webOfficeBookmarkEvent) {
        log.info("WebOffice onGetAllBookmarks begin : {}", (Object)webOfficeBookmarkEvent);
        List bookmarks = webOfficeBookmarkEvent.getBookmarks();
        this.onGetAllBookmarks(bookmarks);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        log.info("WebOffice upload begin");
        boolean isClickSave = this.isClickSave();
        if (!isClickSave) {
            evt.setCancel(true);
        }
        log.info("WebOffice upload end ,clickSave:{}", (Object)isClickSave);
    }

    private boolean isClickSave() {
        boolean isClickSave = false;
        IPageCache pageCache = this.getView().getPageCache();
        String clickUpload = pageCache.get("clickSave");
        if (YEM.isNotEmpty((Object)clickUpload)) {
            pageCache.remove("clickSave");
            isClickSave = Boolean.parseBoolean(clickUpload);
        }
        return isClickSave;
    }

    public void afterUpload(UploadEvent evt) {
        Map dataMap;
        String url;
        Object[] urls = evt.getUrls();
        log.info("WebOffice afterUpload begin : {}", urls);
        if (null == urls || urls.length == 0) {
            return;
        }
        Object urlData = urls[0];
        InputStream inputStream = null;
        if (urlData instanceof Map && (url = (String)(dataMap = (Map)urlData).get("url")).contains("tempfile")) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            inputStream = cache.getInputStream(url);
        }
        this.saveFile(inputStream);
    }

    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent webOfficeBookmarkCheckEvent) {
        log.info("WebOffice onGetBookmarkCheckResult begin : {}", (Object)webOfficeBookmarkCheckEvent);
    }

    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent webOfficeDocChangeEvent) {
        log.info("WebOffice onGetDocChangeCheckResult begin : {}", (Object)webOfficeDocChangeEvent);
    }

    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent webOfficeBookmarkValueEvent) {
        log.info("WebOffice onGetTextByBookmark begin : {}", (Object)webOfficeBookmarkValueEvent);
        String bookmark = webOfficeBookmarkValueEvent.getBookmark();
        String value = webOfficeBookmarkValueEvent.getValue();
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("yem_webofficepreview");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            String bookmark_p = row.getString("yem_bookmark_p");
            if (!bookmark.equals(bookmark_p)) continue;
            model.setValue("yem_fieldinput_p", (Object)value, i);
        }
    }

    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent webOfficeCheckboxEvent) {
        log.info("WebOffice onGetAllCheckBoxes begin : {}", (Object)webOfficeCheckboxEvent);
    }

    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent webOfficeIsFieldReviseEvent) {
        log.info("WebOffice onIsFieldRevise begin : {}", (Object)webOfficeIsFieldReviseEvent);
    }

    public void onSendOpenStatus(WebOfficeOpenStatusEvent webOfficeOpenStatusEvent) {
        log.info("WebOffice onSendOpenStatus begin : {}", (Object)webOfficeOpenStatusEvent);
        if (webOfficeOpenStatusEvent.isOpen()) {
            this.autoSetBookmarkData();
        }
    }

    public void afterClosed(WebOfficeAfterClosedEvent event) {
        log.info("WebOffice afterClosed begin : {}", (Object)event);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        log.info("YemOffice customEvent begin, eventName : {}", (Object)eventName);
        if ("getMessage".equals(eventName)) {
            String eventArgs = e.getEventArgs();
            JSONObject data = JSONObject.parseObject((String)eventArgs);
            String actionId = data.getString("ActionId");
            log.info("YemOffice action begin : {}", (Object)eventArgs);
            JSONObject payload = data.getJSONObject("Payload");
            switch (actionId) {
                case "WOPIClientReady": {
                    this.openFile();
                    break;
                }
                case "DocumentLoaded": {
                    this.autoSetBookmarkData();
                    break;
                }
                case "QueryAllWithJSON": {
                    ArrayList<String> bookmarks = new ArrayList<String>();
                    if (payload != null) {
                        JSONArray text = payload.getJSONArray("text");
                        for (int i = 0; i < text.size(); ++i) {
                            String key = text.getString(i);
                            bookmarks.add(key);
                        }
                    }
                    this.onGetAllBookmarks(bookmarks);
                    break;
                }
                case "SaveFile": {
                    boolean isClickSave = this.isClickSave();
                    if (!isClickSave) break;
                    String base64 = "";
                    if (payload != null) {
                        base64 = payload.getString("buffer");
                    }
                    byte[] decodedBytes = Base64.getDecoder().decode(base64);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(decodedBytes);
                    this.saveFile(inputStream);
                    break;
                }
            }
        }
    }

    private void openFile() {
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        String fileId = webOfficeParam.getFileId();
        String fileName = webOfficeParam.getFileName();
        if (YEM.isNotEmpty((Object)fileId)) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            try {
                InputStream inputStream = service.getInputStream(fileId);
                int available = inputStream.available();
                byte[] byteArray = WebOfficeUtil.toByteArray(inputStream);
                CustomControl control = (CustomControl)this.getControl("yem_yemofficeap");
                YemOfficeCtrl.init(control).openFile(fileName, available, byteArray);
            }
            catch (Exception ex) {
                throw new KDBizException(String.format("\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", YEM.exceptionToStr((Exception)ex)));
            }
        }
    }
}

