/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice2.form;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import yem.base.common.utils.YEM;
import yem.wm.cn.weboffice.weboffice2.common.WebOfficeConstant;
import yem.wm.cn.weboffice.weboffice2.common.WebOfficeParam;
import yem.wm.cn.weboffice.weboffice2.common.wo.BasedataWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.EntityWO;
import yem.wm.cn.weboffice.weboffice2.utils.WebOfficeUtil;

public class WebOfficeMarkEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "yem_fieldinput"});
        ((BasedataEdit)this.getControl("yem_relbasedata_d")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        switch (name = event.getProperty().getName()) {
            case "yem_relbasedata_d": {
                this.relBasedataF7(event);
                break;
            }
        }
    }

    private void relBasedataF7(BeforeF7SelectEvent event) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map cusMap = showParameter.getCustomParams();
        String entryKey = (String)cusMap.get("entryKey");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotEmpty((String)entryKey)) {
            String baseDataType = "";
            IDataModel parentModel = parentView.getModel();
            int rowIndex = parentModel.getEntryCurrentRowIndex(entryKey);
            DynamicObjectCollection entry = parentModel.getEntryEntity(entryKey);
            DynamicObject parentRow = (DynamicObject)entry.get(rowIndex);
            long pid = parentRow.getLong("pid");
            for (DynamicObject row : entry) {
                long entryId = row.getLong("id");
                if (entryId != pid) continue;
                String markJson = row.getString("yem_markjson_d_tag");
                EntityWO entityWO = EntityWO.get(markJson);
                if (!(entityWO instanceof BasedataWO)) break;
                BasedataWO basedataWO = (BasedataWO)entityWO;
                baseDataType = basedataWO.getBaseDataType();
                break;
            }
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter qFilter = new QFilter("group.number", "=", (Object)baseDataType);
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map cusMap = showParameter.getCustomParams();
        String entryKey = (String)cusMap.get("entryKey");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotEmpty((String)entryKey)) {
            IDataModel parentModel = parentView.getModel();
            IDataModel model = this.getModel();
            String key_s = WebOfficeConstant.getKey_s(entryKey);
            int rowIndex = parentModel.getEntryCurrentRowIndex(entryKey);
            DynamicObjectCollection entry = parentModel.getEntryEntity(entryKey);
            DynamicObject parentRow = (DynamicObject)entry.get(rowIndex);
            DataEntityPropertyCollection properties2 = model.getDataEntityType().getProperties();
            if (parentRow != null) {
                EntityWO entityWO;
                DataEntityPropertyCollection properties = parentRow.getDynamicObjectType().getProperties();
                for (IDataEntityProperty property : properties2) {
                    String tag;
                    String key = property.getName();
                    String fieldKey = key.contains(tag = "_tag") ? key.replace(tag, key_s + tag) : key + key_s;
                    if (!properties.containsKey((Object)fieldKey)) continue;
                    Object value = parentRow.get(fieldKey);
                    model.setValue(key, value);
                }
                String yem_markjson_tag = (String)model.getValue("yem_markjson_tag");
                if (StringUtils.isNotEmpty((String)yem_markjson_tag) && (entityWO = EntityWO.get(yem_markjson_tag)) != null) {
                    Map<String, Object> configFields = entityWO.prepareConfigFields();
                    for (Map.Entry<String, Object> objectEntry : configFields.entrySet()) {
                        model.setValue(objectEntry.getKey(), objectEntry.getValue());
                    }
                }
                if ("yem_entryentity".equals(entryKey)) {
                    model.setValue("yem_marktype", (Object)"A");
                } else if ("yem_entryentity1".equals(entryKey)) {
                    long pid = parentRow.getLong("pid");
                    if (pid == 0L) {
                        model.setValue("yem_marktype", (Object)"B");
                    } else {
                        model.setValue("yem_marktype", (Object)"C");
                    }
                } else if ("yem_webofficedyfields".equals(entryKey)) {
                    long pid = parentRow.getLong("pid");
                    if (pid == 0L) {
                        model.setValue("yem_marktype", (Object)"D");
                    } else {
                        model.setValue("yem_marktype", (Object)"E");
                        for (DynamicObject row : entry) {
                            long entryId = row.getLong("id");
                            if (entryId != pid) continue;
                            String markJson = row.getString("yem_markjson_d_tag");
                            EntityWO entityWO2 = EntityWO.get(markJson);
                            if (!(entityWO2 instanceof BasedataWO)) break;
                            model.setValue("yem_marktype", (Object)"F");
                            break;
                        }
                    }
                }
            }
            parentModel.setValue("yem_markpageid", (Object)this.getView().getPageId());
            this.getView().sendFormAction(parentView);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initMarkField();
    }

    private void initMarkField() {
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map cusMap = showParameter.getCustomParams();
        String entryKey = (String)cusMap.get("entryKey");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotEmpty((String)entryKey)) {
            IDataModel parentModel = parentView.getModel();
            int rowIndex = parentModel.getEntryCurrentRowIndex(entryKey);
            DynamicObjectCollection entry = parentModel.getEntryEntity(entryKey);
            DynamicObject parentRow = (DynamicObject)entry.get(rowIndex);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)webOfficeParam.getBillKey());
            String key_s = WebOfficeConstant.getKey_s(entryKey);
            if ("yem_entryentity".equals(entryKey)) {
                List<ComboItem> data = WebOfficeUtil.getEntityComboItems((EntityType)entityType, false, "");
                ComboEdit comboEdit = (ComboEdit)this.getControl("yem_fieldkey");
                comboEdit.setComboItems(data);
            } else if ("yem_entryentity1".equals(entryKey)) {
                long pid = parentRow.getLong("pid");
                if (pid == 0L) {
                    List<ComboItem> data = WebOfficeUtil.getEntityComboItems((EntityType)entityType, true, "");
                    ComboEdit comboEdit = (ComboEdit)this.getControl("yem_fieldkey");
                    comboEdit.setComboItems(data);
                } else {
                    for (DynamicObject row : entry) {
                        long entryId = row.getLong("id");
                        if (entryId != pid) continue;
                        String fieldKey = row.getString("yem_fieldkey" + key_s);
                        if (StringUtils.isNotEmpty((String)fieldKey)) {
                            List<ComboItem> data = WebOfficeUtil.getEntityComboItems((EntityType)entityType, false, fieldKey);
                            ComboEdit comboEdit = (ComboEdit)this.getControl("yem_fieldkey");
                            comboEdit.setComboItems(data);
                        }
                        break;
                    }
                }
            } else if ("yem_webofficedyfields".equals(entryKey)) {
                List<ComboItem> data = WebOfficeUtil.getEntityComboItems((EntityType)entityType, false, "");
                ComboEdit comboEdit = (ComboEdit)this.getControl("yem_fieldkey");
                comboEdit.setComboItems(data);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        String dataSource = (String)model.getValue("yem_datasource");
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("yem_markjson");
        keys.add("yem_markjson_tag");
        keys.add("yem_datatype");
        keys.add("yem_entitywo");
        keys.add("yem_status");
        if (!"B".equals(dataSource)) {
            keys.add("yem_fieldname");
        }
        if (!keys.contains(key)) {
            this.setMarkWO();
        }
        this.updateParent(key);
    }

    private void setMarkWO() {
        WebOfficeParam webOfficeParam = this.getWebOfficeParam();
        IFormView view = this.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        Map cusMap = showParameter.getCustomParams();
        String bookmark = (String)cusMap.get("bookmark");
        if (StringUtils.isNotEmpty((String)webOfficeParam.getBillKey())) {
            IDataModel model = this.getModel();
            String dataSource = (String)model.getValue("yem_datasource");
            String fieldKey = (String)model.getValue("yem_fieldkey");
            String markType = (String)model.getValue("yem_marktype");
            if ("B".equals(dataSource)) {
                String dataType = (String)model.getValue("yem_datatype_d");
                String fieldName = (String)model.getValue("yem_fieldname");
                if (StringUtils.isNotEmpty((String)dataType)) {
                    if (StringUtils.isEmpty((String)fieldName)) {
                        fieldName = bookmark;
                        model.setValue("yem_fieldname", (Object)fieldName);
                    }
                    EntityWO entityWO = EntityWO.getByClassName(dataType);
                    DynamicObject dataEntity = model.getDataEntity(true);
                    entityWO.dataEntity(dataEntity);
                    entityWO.setFullName(fieldName);
                    entityWO.setName(fieldName);
                    entityWO.setDataTypeNumber(dataType);
                    entityWO.setDataTypeName(WebOfficeUtil.getDataTypeName(dataType));
                    entityWO.setDynamic(true);
                    if (entityWO instanceof BasedataWO) {
                        EntityWO entityWO1;
                        String markJson = (String)model.getValue("yem_markjson_tag");
                        String fieldInput = (String)model.getValue("yem_fieldinput");
                        if (YEM.isNotEmpty((Object)markJson) && YEM.isNotEmpty((Object)fieldInput) && (entityWO1 = EntityWO.get(markJson)) instanceof BasedataWO) {
                            BasedataWO basedataWO = (BasedataWO)entityWO;
                            BasedataWO basedataWO1 = (BasedataWO)entityWO1;
                            if (basedataWO1.getBaseDataType() != null && basedataWO1.getBaseDataType().equals(basedataWO.getBaseDataType())) {
                                basedataWO.setRealValue(basedataWO1.getRealValue());
                            }
                        }
                    }
                    model.setValue("yem_markjson", (Object)entityWO.toString());
                    model.setValue("yem_markjson_tag", (Object)entityWO.toJSONString());
                    model.setValue("yem_datatype", (Object)entityWO.getDataTypeNumber());
                    model.setValue("yem_entitywo", (Object)entityWO.getClassName());
                    model.setValue("yem_status", (Object)entityWO.checkConfig());
                } else {
                    model.setValue("yem_markjson", null);
                    model.setValue("yem_markjson_tag", null);
                    model.setValue("yem_datatype", null);
                    model.setValue("yem_entitywo", null);
                    model.setValue("yem_status", (Object)"A");
                }
            } else {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)webOfficeParam.getBillKey());
                EntityWO entityWO = WebOfficeUtil.getEntityWO((EntityType)entityType, "B".equals(markType), fieldKey);
                if (StringUtils.isNotEmpty((String)fieldKey) && entityWO != null) {
                    DynamicObject dataEntity = model.getDataEntity(true);
                    entityWO.dataEntity(dataEntity);
                    model.setValue("yem_markjson", (Object)entityWO.toString());
                    model.setValue("yem_markjson_tag", (Object)entityWO.toJSONString());
                    model.setValue("yem_datatype", (Object)entityWO.getDataTypeNumber());
                    model.setValue("yem_fieldname", (Object)entityWO.getFullName());
                    model.setValue("yem_entitywo", (Object)entityWO.getClassName());
                    model.setValue("yem_status", (Object)entityWO.checkConfig());
                } else {
                    model.setValue("yem_markjson", null);
                    model.setValue("yem_markjson_tag", null);
                    model.setValue("yem_datatype", null);
                    model.setValue("yem_fieldname", null);
                    model.setValue("yem_entitywo", null);
                    model.setValue("yem_status", (Object)"A");
                }
            }
        }
    }

    private void updateParent(String key) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map cusMap = showParameter.getCustomParams();
        String entryKey = cusMap.getOrDefault("entryKey", "");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotEmpty((String)entryKey)) {
            String tag;
            String fieldKey;
            DataEntityPropertyCollection properties;
            IDataModel parentModel = parentView.getModel();
            IDataModel model = this.getModel();
            String key_s = WebOfficeConstant.getKey_s(entryKey);
            DynamicObject dataEntity = model.getDataEntity(true);
            int rowIndex = parentModel.getEntryCurrentRowIndex(entryKey);
            DynamicObject parentRow = parentModel.getEntryRowEntity(entryKey, rowIndex);
            if (parentRow != null && (properties = parentRow.getDynamicObjectType().getProperties()).containsKey((Object)(fieldKey = key.contains(tag = "_tag") ? key.replace(tag, key_s + tag) : key + key_s))) {
                parentModel.setValue(fieldKey, dataEntity.get(key), rowIndex);
                this.getView().sendFormAction(parentView);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_fieldinput": {
                WebOfficeUtil.dynamicFieldInput(this, key, "yem_webofficedyfields", "yem_markjson_tag", "yem_fieldinput", "yem_basedatatype_d", false);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (actionId != null) {
            switch (actionId) {
                case "yem_fieldinput": {
                    WebOfficeUtil.dynamicFieldCallBack(this, event, "yem_webofficedyfields", "yem_markjson_tag", "yem_fieldinput", false);
                    break;
                }
            }
        }
    }

    private WebOfficeParam getWebOfficeParam() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String param = (String)showParameter.getCustomParam("yem_param");
        WebOfficeParam webOfficeParam = (WebOfficeParam)JSON.parseObject((String)param, WebOfficeParam.class);
        return webOfficeParam == null ? new WebOfficeParam() : webOfficeParam;
    }
}

