/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.weboffice2.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.attachment.FilePathService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import yem.base.common.de.utils.ShowFormUtil;
import yem.base.common.utils.YEM;
import yem.wm.cn.weboffice.weboffice2.common.wo.BasedataWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.DateWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.EntityWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.MulBasedataWO;
import yem.wm.cn.weboffice.weboffice2.common.wo.MuliLangTextWO;

public class WebOfficeUtil {
    private static final List<String> noPropNames = new ArrayList<String>();

    public static String getFullPath(String path) {
        try {
            path = new FilePathService().getRealPath(path);
            if (StringUtils.isNotEmpty((String)path) && !path.startsWith(UrlService.getDomainContextUrl())) {
                path = UrlService.getAttachmentFullUrl((String)URLEncoder.encode(path, "utf-8"));
            }
            return path;
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException("\u5730\u5740\u83b7\u53d6\u5f02\u5e38\uff1a" + YEM.exceptionToStr((Exception)e));
        }
    }

    public static String getFilePath(String fileName) {
        RequestContext context = RequestContext.get();
        Calendar calendar = Calendar.getInstance();
        String year = String.valueOf(calendar.get(1));
        int tempMonth = calendar.get(2) + 1;
        String month = tempMonth >= 10 ? String.valueOf(tempMonth) : "0" + tempMonth;
        int date = calendar.get(5);
        String currentUserId = YEM.getCurrentUserId() + "";
        String currentTimeMillis = System.currentTimeMillis() + "";
        return String.format("/%s/%s/%s%s/%s/%s/%s/%s", context.getTenantId(), context.getAccountId(), year, month, currentUserId, date, currentTimeMillis, fileName);
    }

    public static byte[] toByteArray(InputStream inputStream) throws Exception {
        int bytesRead;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void dynamicFieldInput(AbstractFormPlugin plugin, String callBackKey, String entryKey, String markJsonKey, String fieldInputKey, String baseTypeKey, boolean isEntry) {
        DynamicObject entity;
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        if (isEntry) {
            int rowIndex = model.getEntryCurrentRowIndex(entryKey);
            entity = model.getEntryRowEntity(entryKey, rowIndex);
        } else {
            entity = model.getDataEntity(true);
        }
        String markJson = entity.getString(markJsonKey);
        boolean isPreview = "yem_webofficepreview".equals(entryKey);
        if (StringUtils.isNotEmpty((String)markJson)) {
            EntityWO entityWO = EntityWO.get(markJson);
            if (!entityWO.isDynamic() && !isPreview) {
                view.showTipNotification("\u5b9e\u4f53\u6570\u636e\u6e90\u8bf7\u76f4\u63a5\u5728\u5355\u636e\u5bf9\u5e94\u5b57\u6bb5\u7ef4\u62a4\u3002");
                return;
            }
            if (entityWO instanceof BasedataWO) {
                boolean isMultiSelect = entityWO instanceof MulBasedataWO;
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"yem_webofficebasecobo_f7", (boolean)isMultiSelect, (int)0);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callBackKey));
                DynamicObject baseDataType = entity.getDynamicObject(baseTypeKey);
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                if (baseDataType != null) {
                    qFilter.and("group", "=", baseDataType.getPkValue());
                } else {
                    qFilter.and("group", "=", null);
                }
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                view.showForm((FormShowParameter)showParameter);
            } else if (entityWO instanceof DateWO) {
                ShowFormUtil.editDate((AbstractFormPlugin)plugin, (String)callBackKey, null);
            } else {
                ShowFormUtil.editText((AbstractFormPlugin)plugin, (String)callBackKey, (String)entity.getString(fieldInputKey));
            }
        }
    }

    public static void dynamicFieldCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent event, String entryKey, String markJsonKey, String fieldInputKey, boolean isEntry) {
        DynamicObject entity;
        Object returnData = event.getReturnData();
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        int rowIndex = 0;
        if (isEntry) {
            rowIndex = model.getEntryCurrentRowIndex(entryKey);
            entity = model.getEntryRowEntity(entryKey, rowIndex);
        } else {
            entity = model.getDataEntity(true);
        }
        String markJson = entity.getString(markJsonKey);
        if (StringUtils.isNotEmpty((String)markJson)) {
            Object value = isEntry ? model.getValue(fieldInputKey, rowIndex) : model.getValue(fieldInputKey);
            EntityWO entityWO = EntityWO.get(markJson);
            if (entityWO instanceof BasedataWO) {
                BasedataWO basedataWO = (BasedataWO)entityWO;
                if (returnData instanceof ListSelectedRowCollection) {
                    ArrayList<String> realValue = new ArrayList<String>();
                    ListSelectedRowCollection selectData = (ListSelectedRowCollection)returnData;
                    if (selectData.size() == 1) {
                        ListSelectedRow selectedRow = selectData.get(0);
                        Object pkValue = selectedRow.getPrimaryKeyValue();
                        DynamicObject baseData = BasedataWO.getBaseData(pkValue);
                        if (baseData != null) {
                            value = baseData.getLocaleString("name");
                        }
                        value = entityWO.formatValue(value);
                        realValue.add(selectedRow.getNumber());
                    } else {
                        ArrayList<String> strList = new ArrayList<String>();
                        for (ListSelectedRow selectedRow : selectData) {
                            Object pkValue = selectedRow.getPrimaryKeyValue();
                            DynamicObject baseData = BasedataWO.getBaseData(pkValue);
                            if (baseData != null) {
                                ILocaleString baseDataName = baseData.getLocaleString("name");
                                String muliLangText = MuliLangTextWO.getMuliLangText(baseDataName, basedataWO.getLangType());
                                strList.add(muliLangText);
                            }
                            realValue.add(selectedRow.getNumber());
                        }
                        if (entityWO instanceof MulBasedataWO) {
                            MulBasedataWO mulBasedataWO = (MulBasedataWO)entityWO;
                            value = mulBasedataWO.getValueByStrList(strList);
                        } else {
                            value = String.join((CharSequence)"\r\n", strList);
                        }
                    }
                    basedataWO.setRealValue(realValue);
                    if (isEntry) {
                        model.setValue(markJsonKey, (Object)basedataWO.toJSONString(), rowIndex);
                        model.setValue(fieldInputKey, value, rowIndex);
                        WebOfficeUtil.webofficeTplSelect(plugin, true, rowIndex, selectData);
                    } else {
                        model.setValue(markJsonKey, (Object)basedataWO.toJSONString());
                        model.setValue(fieldInputKey, value);
                    }
                }
            } else if (entityWO instanceof DateWO) {
                if (returnData instanceof Date) {
                    Date date = (Date)returnData;
                    value = entityWO.formatValue(date);
                    if (isEntry) {
                        model.setValue(fieldInputKey, value, rowIndex);
                    } else {
                        model.setValue(fieldInputKey, value);
                    }
                }
            } else if (returnData != null) {
                value = entityWO.formatValue(returnData);
                if (isEntry) {
                    model.setValue(fieldInputKey, value, rowIndex);
                } else {
                    model.setValue(fieldInputKey, value);
                }
            }
        }
    }

    public static void webofficeTplSelect(AbstractFormPlugin plugin, boolean isParentDyFieldChanged, int rowIndex, ListSelectedRowCollection selectData) {
        block9: {
            DataEntityPropertyCollection fromProperties;
            DynamicObjectCollection dyFieldEntry;
            DataEntityPropertyCollection toProperties;
            IDataModel model;
            block10: {
                EntityWO entityWO;
                QFilter qFilter;
                DynamicObject bill;
                DynamicObject webOfficeModel;
                IFormView view = plugin.getView();
                model = view.getModel();
                DynamicObject dataEntity = model.getDataEntity(true);
                if (!dataEntity.getDynamicObjectType().getProperties().containsKey((Object)"yem_webofficedyfields")) break block9;
                if (!isParentDyFieldChanged) {
                    model.deleteEntryData("yem_webofficedyfields");
                }
                if ((webOfficeModel = (DynamicObject)model.getValue("yem_weboffice")) == null || (bill = BusinessDataServiceHelper.loadSingle((String)"yem_webofficemarks2", (QFilter[])(qFilter = new QFilter("yem_webofficemodel2", "=", webOfficeModel.getPkValue())).toArray())) == null) break block9;
                DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("yem_webofficedyfields");
                toProperties = entryEntity.getDynamicObjectType().getProperties();
                dyFieldEntry = bill.getDynamicObjectCollection("yem_webofficedyfields");
                fromProperties = dyFieldEntry.getDynamicObjectType().getProperties();
                if (!isParentDyFieldChanged) break block10;
                DynamicObject entryRowEntity = model.getEntryRowEntity("yem_webofficedyfields", rowIndex);
                String fieldInput = entryRowEntity.getString("yem_fieldinput_d");
                long entryId = entryRowEntity.getLong("id");
                String markJson = entryRowEntity.getString("yem_markjson_d_tag");
                String bookmark = entryRowEntity.getString("yem_bookmark_d");
                if (!StringUtils.isNotEmpty((String)markJson) || !((entityWO = EntityWO.get(markJson)) instanceof BasedataWO)) break block9;
                DynamicObjectCollection entry = model.getEntryEntity("yem_webofficedyfields");
                for (int i = entry.size() - 1; i >= 0; --i) {
                    DynamicObject row = (DynamicObject)entry.get(i);
                    long pid = row.getLong("pid");
                    if (pid != entryId) continue;
                    model.deleteEntryRow("yem_webofficedyfields", i);
                }
                List<Object> numbers = selectData != null ? selectData.stream().map(ListSelectedRow::getNumber).collect(Collectors.toList()) : new ArrayList();
                BasedataWO basedataWO = (BasedataWO)entityWO;
                basedataWO.setRealValue(numbers);
                model.setValue("yem_markjson_d_tag", (Object)basedataWO.toJSONString(), rowIndex);
                if (!StringUtils.isNotEmpty((String)fieldInput)) break block9;
                long pBookId = 0L;
                for (int i = 0; i < dyFieldEntry.size(); ++i) {
                    EntityWO entityWO_S;
                    DynamicObject row = (DynamicObject)dyFieldEntry.get(i);
                    long pid = row.getLong("pid");
                    String markJson_s = row.getString("yem_markjson_d_tag");
                    String bookmark_s = row.getString("yem_bookmark_d");
                    if (bookmark.equals(bookmark_s)) {
                        pBookId = row.getLong("id");
                    }
                    if (!StringUtils.isNotEmpty((String)markJson_s) || pid <= 0L || pBookId != pid || WebOfficeUtil.isNotRelBasedata(entityWO_S = EntityWO.get(markJson_s), numbers, true)) continue;
                    int index = model.insertEntryRow("yem_webofficedyfields", rowIndex);
                    for (IDataEntityProperty toProperty : toProperties) {
                        String key = toProperty.getName();
                        if (!fromProperties.containsKey((Object)key) || !WebOfficeUtil.couldModelSetField(key)) continue;
                        model.setValue(key, row.get(key), index);
                    }
                }
                break block9;
            }
            boolean pBaseData = false;
            int pIndex = 0;
            for (DynamicObject row : dyFieldEntry) {
                int index;
                long pid = row.getLong("pid");
                String markJson = row.getString("yem_markjson_d_tag");
                if (!StringUtils.isNotEmpty((String)markJson)) continue;
                EntityWO entityWO = EntityWO.get(markJson);
                if (pid == 0L) {
                    pBaseData = entityWO instanceof BasedataWO;
                    pIndex = index = model.createNewEntryRow("yem_webofficedyfields");
                } else {
                    String fieldInput = (String)model.getValue("yem_fieldinput_d", pIndex);
                    if (pBaseData && StringUtils.isEmpty((String)fieldInput) || !entityWO.isDynamic()) continue;
                    index = model.insertEntryRow("yem_webofficedyfields", pIndex);
                }
                for (IDataEntityProperty toProperty : toProperties) {
                    String key = toProperty.getName();
                    if (!fromProperties.containsKey((Object)key) || !WebOfficeUtil.couldModelSetField(key)) continue;
                    model.setValue(key, row.get(key), index);
                }
            }
        }
    }

    public static boolean isNotRelBasedata(EntityWO entityWO, List<String> numbers, boolean isBill) {
        String relBaseData = entityWO.getRelBaseData();
        if (StringUtils.isNotEmpty((String)relBaseData) && !numbers.contains(relBaseData)) {
            return true;
        }
        return isBill && !entityWO.isDynamic();
    }

    public static List<ComboItem> getEntityComboItems(EntityType entityType, boolean isEntry, String filterKey) {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        if (entityType == null) {
            return data;
        }
        List<EntityWO> entityWOS = WebOfficeUtil.getEntityWOS(entityType, isEntry, filterKey);
        for (EntityWO entityWO : entityWOS) {
            String number = entityWO.getNumber();
            String name = entityWO.getName();
            String fullNumber = entityWO.getFullNumber();
            String fullName = entityWO.getFullName();
            if (StringUtils.isEmpty((String)name)) {
                fullName = fullName + number;
            }
            data.add(new ComboItem(new LocaleString(fullName), fullNumber));
        }
        return data;
    }

    public static List<EntityWO> getEntityWOS(EntityType entityType, boolean isEntry, String filterKey) {
        ArrayList<IMetadata> parents = new ArrayList<IMetadata>();
        ArrayList<EntityWO> entityWOS = new ArrayList<EntityWO>();
        if (isEntry) {
            WebOfficeUtil.initEntrys(entityWOS, (IDataEntityType)entityType, parents, filterKey);
        } else {
            WebOfficeUtil.initProps(entityWOS, (IDataEntityType)entityType, parents, filterKey, false);
        }
        return entityWOS;
    }

    public static EntityWO getEntityWO(EntityType entityType, boolean isEntry, String filterKey) {
        ArrayList<IMetadata> parents = new ArrayList<IMetadata>();
        ArrayList<EntityWO> entityWOS = new ArrayList<EntityWO>();
        if (isEntry) {
            WebOfficeUtil.initEntrys(entityWOS, (IDataEntityType)entityType, parents, filterKey);
        } else {
            WebOfficeUtil.initProps(entityWOS, (IDataEntityType)entityType, parents, filterKey, true);
        }
        return entityWOS.isEmpty() ? null : (EntityWO)entityWOS.get(0);
    }

    private static void initProps(List<EntityWO> entityWOS, IDataEntityType entityType, List<IMetadata> parents, String filterKey, boolean getOne) {
        ArrayList<IDataEntityType> entryTypes = new ArrayList<IDataEntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            String number = property.getName();
            String classSimpleName = property.getClass().getSimpleName();
            if (property instanceof EntryProp && !(property instanceof LinkEntryProp)) {
                List keys;
                if (StringUtils.isNotEmpty((String)filterKey) && !(keys = Stream.of(filterKey.split("\\.")).collect(Collectors.toList())).contains(number)) continue;
                entryTypes.add(((EntryProp)property).getItemType());
                continue;
            }
            if (noPropNames.contains(classSimpleName)) continue;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                IDataEntityType complexType = basedataProp.getComplexType();
                ArrayList<IMetadata> allParents = new ArrayList<IMetadata>(parents);
                allParents.add((IMetadata)basedataProp);
                WebOfficeUtil.initProps(entityWOS, complexType, allParents, filterKey, getOne);
                continue;
            }
            String displayName = WebOfficeUtil.getDisplayName((IMetadata)property);
            StringBuilder fullnumber = new StringBuilder(number);
            StringBuilder fullname = new StringBuilder(displayName);
            for (int i = parents.size() - 1; i >= 0; --i) {
                IMetadata parent = parents.get(i);
                fullnumber.insert(0, parent.getName() + ".");
                fullname.insert(0, WebOfficeUtil.getDisplayName(parent) + ".");
            }
            String fullNumber = fullnumber.toString();
            String fullName = fullname.toString();
            if (StringUtils.isNotEmpty((String)filterKey) && getOne && !fullNumber.equals(filterKey)) continue;
            EntityWO entityWO = EntityWO.get(property);
            entityWO.setNumber(number);
            entityWO.setFullNumber(fullNumber);
            entityWO.setName(displayName);
            entityWO.setFullName(fullName);
            entityWO.setDataTypeNumber(classSimpleName);
            entityWO.setDataTypeName(WebOfficeUtil.getDataTypeName(classSimpleName));
            entityWOS.add(entityWO);
        }
        for (IDataEntityType entryType : entryTypes) {
            ArrayList<IMetadata> allParents = new ArrayList<IMetadata>(parents);
            allParents.add((IMetadata)entryType);
            WebOfficeUtil.initProps(entityWOS, entryType, allParents, filterKey, getOne);
        }
    }

    public static String getDataTypeName(String dataTypeNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"yem_webofficebookmark2");
        IDataEntityProperty fieldProp = entityType.findProperty("yem_datatype");
        if (fieldProp instanceof ComboProp) {
            List comboItems = ((ComboProp)fieldProp).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                String value = comboItem.getValue();
                if (!dataTypeNumber.equals(value)) continue;
                return comboItem.getName().getLocaleValue();
            }
        }
        return ResManager.loadKDString((String)"\u672a\u77e5", (String)"WebOfficeUtil_0", (String)"yem-base", (Object[])new Object[0]);
    }

    private static void initEntrys(List<EntityWO> entityWOS, IDataEntityType entityType, List<IMetadata> parents, String filterKey) {
        for (IDataEntityProperty property : entityType.getProperties()) {
            String number = property.getName();
            String classSimpleName = property.getClass().getSimpleName();
            if (!(property instanceof EntryProp) || property instanceof LinkEntryProp) continue;
            String displayName = WebOfficeUtil.getDisplayName((IMetadata)property);
            StringBuilder fullnumber = new StringBuilder(number);
            StringBuilder fullname = new StringBuilder(displayName);
            for (int i = parents.size() - 1; i >= 0; --i) {
                IMetadata parent = parents.get(i);
                fullnumber.insert(0, parent.getName() + ".");
                fullname.insert(0, WebOfficeUtil.getDisplayName(parent) + ".");
            }
            String fullNumber = fullnumber.toString();
            String fullName = fullname.toString();
            if (StringUtils.isEmpty((String)filterKey) || fullNumber.equals(filterKey)) {
                EntityWO entityWO = EntityWO.get(property);
                entityWO.setNumber(number);
                entityWO.setFullNumber(fullNumber);
                entityWO.setName(displayName);
                entityWO.setFullName(fullName);
                entityWO.setDataTypeNumber(classSimpleName);
                entityWO.setDataTypeName(WebOfficeUtil.getDataTypeName(classSimpleName));
                entityWOS.add(entityWO);
            }
            IDataEntityType entryType = ((EntryProp)property).getItemType();
            ArrayList<IMetadata> allParents = new ArrayList<IMetadata>(parents);
            allParents.add((IMetadata)entryType);
            WebOfficeUtil.initEntrys(entityWOS, entryType, allParents, filterKey);
        }
    }

    public static String getDisplayName(IMetadata iMetadata) {
        return iMetadata.getDisplayName() != null ? iMetadata.getDisplayName().getLocaleValue() : "";
    }

    public static void copyEntry(DynamicObjectCollection fromEntry, DynamicObjectCollection toEntry) {
        toEntry.clear();
        for (DynamicObject fromRow : fromEntry) {
            DynamicObject toRow = toEntry.addNew();
            WebOfficeUtil.copyRow(fromRow, toRow);
        }
    }

    public static void copyRow(DynamicObject fromRow, DynamicObject toRow) {
        DataEntityPropertyCollection fromProperties = fromRow.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection toProperties = toRow.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : toProperties) {
            String key = property.getName();
            if (!fromProperties.containsKey((Object)key)) continue;
            toRow.set(key, fromRow.get(key));
        }
    }

    public static boolean couldModelSetField(String key) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("id");
        keys.add("seq");
        keys.add("pid");
        keys.add("isGroupNode");
        return !keys.contains(key);
    }

    static {
        noPropNames.add("LongProp");
        noPropNames.add("ModifierIdProp");
        noPropNames.add("LinkEntryProp");
        noPropNames.add("DynamicLocaleProperty");
    }
}

