/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.weboffice.yemoffice.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.IFrameMessage;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.model.WebOfficeMark;
import yem.base.common.utils.HttpHelper;
import yem.base.common.utils.YEM;
import yem.wm.cn.weboffice.weboffice2.common.WebOfficeParam;

public class YemOfficeCtrl {
    private final WebOfficeParam param = new WebOfficeParam();
    private final CustomControl control;
    private static final String iFrameUrl = "/infra/file/bookmark?token=";
    private static final String loginUrl = "/admin-api/system/auth/login";

    public YemOfficeCtrl(CustomControl control) {
        this.control = control;
    }

    public static YemOfficeCtrl init(CustomControl control) {
        return new YemOfficeCtrl(control);
    }

    private void postMessage(Object content) {
        IFrameMessage iFrameMessage = new IFrameMessage();
        iFrameMessage.setOrigin("*");
        iFrameMessage.setContent(content);
        this.control.setData((Object)iFrameMessage);
    }

    public void iFrame() {
        String token;
        String officeAddr = this.param.getYemOfficeAddr();
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("tenant-id", "1");
            HashMap<String, String> loginParam = new HashMap<String, String>();
            loginParam.put("username", this.param.getYemOfficeAppId());
            loginParam.put("password", this.param.getYemOfficeAppSecret());
            String loginResult = HttpHelper.httpPost((String)(officeAddr + loginUrl), header, (String)JSON.toJSONString(loginParam));
            if (YEM.isEmpty((Object)loginResult)) {
                throw new KDBizException("token\u83b7\u53d6\u4e3a\u7a7a");
            }
            JSONObject loginResultObj = JSONObject.parseObject((String)loginResult);
            token = loginResultObj.getJSONObject("data").getString("accessToken");
        }
        catch (Exception e) {
            throw new KDBizException(String.format("token\u83b7\u53d6\u5f02\u5e38\uff0c\u539f\u56e0%s", YEM.exceptionToStr((Exception)e)));
        }
        String url = officeAddr + iFrameUrl + token;
        JSONObject postObject = new JSONObject();
        postObject.put("url", (Object)url);
        this.control.setData((Object)postObject);
    }

    private JSONObject getPostMsg(String actionId, JSONObject payload) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ActionId", (Object)actionId);
        jsonObject.put("Timestamp", (Object)System.currentTimeMillis());
        jsonObject.put("Payload", (Object)payload);
        return jsonObject;
    }

    public void openFile(String fileName, int available, byte[] byteArray) {
        JSONObject payload = new JSONObject();
        payload.put("name", (Object)fileName);
        payload.put("type", (Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        payload.put("size", (Object)available);
        payload.put("buffer", (Object)byteArray);
        this.postMessage(this.getPostMsg("OpenFile", payload));
    }

    public void getAllBookmarks() {
        this.postMessage(this.getPostMsg("QueryAllWithJSON", null));
    }

    public void locateMark(String bookmark) {
        JSONObject payload = new JSONObject();
        payload.put("bookmarkName", (Object)bookmark);
        this.postMessage(this.getPostMsg("LocateBookmark", payload));
    }

    public void modifyMarks(List<WebOfficeMark> marks) {
        JSONObject payload = new JSONObject();
        for (WebOfficeMark mark : marks) {
            String field = mark.getField();
            String value = mark.getValue();
            payload.put(field, (Object)value);
        }
        this.postMessage(this.getPostMsg("ReplaceWithJSON", payload));
    }

    public void addTableRows(String bookmark, String[][] datas) {
        JSONObject payload = new JSONObject();
        payload.put("bookmarkName", (Object)bookmark);
        payload.put("startRowIndex", (Object)-1);
        payload.put("data", (Object)datas);
        this.postMessage(this.getPostMsg("InsertRowWithJSON", payload));
    }

    public void modifyAllMarks(List<WebOfficeMark> marks, Map<String, String[][]> tableRows) {
        JSONObject payload = new JSONObject();
        JSONObject text = new JSONObject();
        for (WebOfficeMark mark : marks) {
            String field = mark.getField();
            String value = mark.getValue();
            text.put(field, (Object)value);
        }
        payload.put("text", (Object)text);
        JSONArray tables = new JSONArray();
        for (Map.Entry<String, String[][]> entry : tableRows.entrySet()) {
            String bookmark = entry.getKey();
            String[][] value = entry.getValue();
            JSONObject table = new JSONObject();
            table.put("bookmarkName", (Object)bookmark);
            table.put("startRowIndex", (Object)-1);
            table.put("data", (Object)value);
            tables.add((Object)table);
        }
        payload.put("table", (Object)tables);
        this.postMessage(this.getPostMsg("ReplaceTextAndInsertTableRow", payload));
    }

    public void saveFile() {
        this.postMessage(this.getPostMsg("SaveFile", null));
    }
}

