/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.code.dynamic;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Matcher;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.HttpHelper;
import yem.base.common.utils.YEM;

public class BillPostCodeFormPlugin
extends AbstractFormPlugin
implements Plugin {
    private static final String KEY_ENGINE = "nashorn";
    private static final String KEY_CTRL = "yem_codeeditap";
    private static final String KEY_EDIT = "setText";

    public static Object getRunResult(String jsCode, String ... jsonParams) {
        return BillPostCodeFormPlugin.getRunResult(jsCode, false, jsonParams);
    }

    public static Object getRunResult(String jsCode, boolean backError, String ... jsonParams) {
        Object resultObj;
        block2: {
            jsCode = BillPostCodeFormPlugin.initCodeParams(jsCode, jsonParams);
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName(KEY_ENGINE);
            resultObj = null;
            try {
                resultObj = engine.eval(jsCode);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!backError) break block2;
                return e.toString();
            }
        }
        return resultObj;
    }

    public static String initCodeParams(String jsCode, String ... jsonParams) {
        for (int i = 0; i < jsonParams.length; ++i) {
            String jsonParam = jsonParams[i];
            jsCode = jsCode.replaceAll("\\$" + (i + 1), Matcher.quoteReplacement(jsonParam));
        }
        return jsCode;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().addClientCallBack(KEY_EDIT);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String key = e.getName();
        if (KEY_EDIT.equals(key)) {
            this.setCodeText();
        }
    }

    private void setCodeText() {
        IDataModel model = this.getModel();
        model.deleteEntryData("yem_params");
        IFormView view = this.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        JSONArray params = (JSONArray)showParameter.getCustomParam("params");
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.size(); ++i) {
            String param = params.getString(i);
            if (i == 0) {
                CodeEdit codeEdit = (CodeEdit)view.getControl(KEY_CTRL);
                if (YEM.isNotEmpty(param)) {
                    codeEdit.setText(param);
                    continue;
                }
                codeEdit.setText("var Long = Packages.java.lang.Long;\nvar bill = $1;\nvar data = $2;\n");
                continue;
            }
            int index = model.createNewEntryRow("yem_params");
            model.setValue("yem_param", (Object)(param.length() > 50 ? "\u70b9\u51fb\u67e5\u770b\u8be6\u60c5" : param), index);
            model.setValue("yem_param_tag", (Object)param, index);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "yem_test"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.okClick();
        }
        if ("yem_test".equals(key)) {
            this.showResult();
        }
    }

    private void okClick() {
        IFormView view = this.getView();
        CodeEdit codeEdit = (CodeEdit)view.getControl(KEY_CTRL);
        String code = codeEdit.getText();
        view.returnDataToParent((Object)code);
        view.close();
    }

    private void showResult() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        CodeEdit codeEdit = (CodeEdit)view.getControl(KEY_CTRL);
        String jsCode = codeEdit.getText();
        String[] params = (String[])model.getEntryEntity("yem_params").stream().map(x -> x.getString("yem_param_tag")).toArray(String[]::new);
        Boolean apiexcute = (Boolean)model.getValue("yem_apiexcute");
        Object result = apiexcute != false ? this.getApiRunResult(jsCode, params) : BillPostCodeFormPlugin.getRunResult(jsCode, true, params);
        view.showMessage(String.format("\u7c7b\u578b\uff1a%s\r\n\u7ed3\u679c\uff1a%s", result == null ? null : result.getClass().getName(), result));
    }

    private Object getApiRunResult(String jsCode, String[] params) {
        String requestData;
        String codeNew = BillPostCodeFormPlugin.initCodeParams(jsCode, params);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("access_token", "");
        JSONObject paramCode = new JSONObject();
        paramCode.put("code", (Object)codeNew);
        paramCode.put("backError", (Object)true);
        String url = "";
        try {
            requestData = HttpHelper.httpPost(url, header, paramCode.toJSONString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return String.format("\u63a5\u53e3\u5f02\u5e38\uff1a%s\u3002", ex);
        }
        if (YEM.isNotEmpty(requestData)) {
            JSONObject data = JSONObject.parseObject((String)requestData);
            if (data.getBoolean("success").booleanValue()) {
                return data.get((Object)"data");
            }
            return String.format("\u63a5\u53e3\u5931\u8d25\uff1a%s\u3002", data.getString("message"));
        }
        return null;
    }
}

