/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.code.utils;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import yem.base.common.utils.BigDecimalUtils;

public class NashornScript {
    private static final Log log = LogFactory.getLog(NashornScript.class);
    private static final String KEY_ENGINE = "nashorn";

    public static ScriptEngine getEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        return manager.getEngineByName(KEY_ENGINE);
    }

    public static ScriptEngine getEngineAll() {
        ScriptEngine engine = NashornScript.getEngine();
        try {
            engine.eval(NashornScript.round());
            engine.eval(NashornScript.div());
        }
        catch (ScriptException e) {
            log.error("NashornScript Error", (Throwable)e);
        }
        return engine;
    }

    public static String round() {
        String packages = NashornScript.getPackages(BigDecimalUtils.class);
        return "function round(a, b) {" + packages + "return BigDecimalUtils.toBigDecimal(a).setScale(b, 4);}";
    }

    public static String div() {
        String packages = NashornScript.getPackages(BigDecimalUtils.class);
        return "function div(a, b) {" + packages + "return BigDecimalUtils.div(a, b, 10);}";
    }

    private static String getPackages(Class<?> clazz) {
        return "var " + clazz.getSimpleName() + "=Packages." + clazz.getName() + ";";
    }

    public static void main(String[] args) throws ScriptException {
        ScriptEngine engineAll = NashornScript.getEngineAll();
        Object eval = engineAll.eval("round(1.1111 + div(3,0), 2)");
        System.out.println(eval);
    }
}

