/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.meta.api;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.de.meta.report.DataDictionaryRptListPlugin;
import yem.base.common.utils.YEM;

public class BillDataGetApi
extends AbstractBillWebApiPlugin
implements Plugin {
    public ApiResult doCustomService(Map<String, Object> params) {
        String billKey = (String)params.get("billKey");
        Long billId = (Long)params.get("billId");
        String billno = (String)params.get("billno");
        Boolean attach = (Boolean)params.getOrDefault("attach", false);
        Boolean token = (Boolean)params.getOrDefault("token", true);
        Boolean base64 = (Boolean)params.getOrDefault("base64", false);
        String attachKey = (String)params.getOrDefault("attachKey", "attachmentpanel");
        if (YEM.isEmpty(billKey)) {
            return ApiResult.fail((String)"\u3010billKey\u3011\u5355\u636e\u6807\u8bc6\u53c2\u6570\u672a\u4f20");
        }
        if (YEM.isNotEmpty(billno) || YEM.isNotEmpty(billId)) {
            DynamicObject bill;
            if (YEM.isNotEmpty(billId) && billId > 0L) {
                bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billKey);
            } else {
                bill = BusinessDataServiceHelper.loadSingle((String)billKey, (String)"id", (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
                if (bill != null) {
                    bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)billKey);
                }
            }
            if (bill != null) {
                if (attach.booleanValue()) {
                    List attachments = AttachmentServiceHelper.getAttachments((String)billKey, (Object)bill.getPkValue(), (String)attachKey, (boolean)token);
                    if (base64.booleanValue()) {
                        for (Map attachment : attachments) {
                            String url = (String)attachment.get("url");
                            String base64Str = this.getBase64Str(url);
                            attachment.put("base64", base64Str);
                        }
                    }
                    return ApiResult.success((Object)attachments);
                }
                String billJson = SerializationUtils.toJsonString((Object)bill);
                return ApiResult.success((Object)JSONObject.parseObject((String)billJson));
            }
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        DataSet dataSet = DataDictionaryRptListPlugin.queryDataBill(billKey);
        DynamicObjectCollection dynamicObjects = ORM.create().toPlainDynamicObjectCollection(dataSet);
        ArrayList allData = new ArrayList();
        for (DynamicObject obj : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DataEntityPropertyCollection properties = obj.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                String key = property.getName();
                map.put(key, obj.get(key));
            }
            allData.add(map);
        }
        return ApiResult.success(allData);
    }

    private String getBase64Str(String url) {
        String base64Str = "";
        if (YEM.isNotEmpty(url)) {
            try {
                int length;
                URLConnection urlConnection = new URL(url).openConnection();
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                httpURLConnection.setConnectTimeout(5000);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                httpURLConnection.connect();
                InputStream inputStream = httpURLConnection.getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, length);
                }
                byte[] bytes = outputStream.toByteArray();
                base64Str = Base64.getEncoder().encodeToString(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return base64Str;
    }
}

