/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.meta.dynamic;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.sdk.plugin.Plugin;
import org.apache.commons.collections.CollectionUtils;
import yem.base.common.utils.YEM;

public class SelectFieldFormPlugin
extends AbstractFormPlugin
implements Plugin,
TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public static final String FormId_SelectField = "yem_de_selectfield";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_IsMulti = "ismulti";
    public static final String CustParamKey_SelectedNodeIds = "nodeids";
    public static final String CustParamKey_EntityNumber = "entitynumber";
    private static final String CACHEKEY_SELECTE_DNODEIDS = "nodeids";
    private static final String CACHEKEY_SELECTE_DNODENAMES = "nodenames";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";
    public static final String Key_SearchField = "searchfield";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getView().getControl(Key_SearchField);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
        this.fillTreeNodes(entityNumber);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get("nodeids");
            String currNodeName = this.getPageCache().get(CACHEKEY_SELECTE_DNODENAMES);
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (!this.isMultiSelected()) {
            String currNodeId = (String)e.getNodeId();
            TreeView treeView = (TreeView)e.getSource();
            if ("0".equals(currNodeId)) {
                currNodeId = "";
            }
            Map focusNode = treeView.getTreeState().getFocusNode();
            this.getPageCache().put("nodeids", currNodeId);
            this.getPageCache().put(CACHEKEY_SELECTE_DNODENAMES, new JSONObject(focusNode).toJSONString());
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        if (!this.isMultiSelected()) {
            String currNodeId = (String)e.getNodeId();
            if ("0".equals(currNodeId)) {
                currNodeId = "";
            }
            if (!StringUtils.isBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
                this.getView().close();
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        String cacheNodeIds = "";
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            checkedNodeIds.remove("0");
            cacheNodeIds = StringUtils.join((Object[])checkedNodeIds.toArray(), (String)",");
        }
        this.getPageCache().put("nodeids", cacheNodeIds);
    }

    private void fillTreeNodes(String entityNumber) {
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            rootNode = this.getTreeNode(entityNumber);
        } else {
            this.addTreeRootNode();
        }
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        this.setTreeNodeDisabled(rootNode);
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            this.multiSelect(tree, rootNode);
        }
    }

    private TreeNode getTreeNode(String entityNumber) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        TreeNode rootNode = new TreeNode("", entityNumber, SelectFieldFormPlugin.getDisplayName((IMetadata)type));
        rootNode.setIsOpened(true);
        ArrayList<IMetadata> parents = new ArrayList<IMetadata>();
        SelectFieldFormPlugin.initProps(rootNode, (IDataEntityType)type, parents, "");
        return rootNode;
    }

    private static List<String> getExcludePropNames() {
        ArrayList<String> noPropNames = new ArrayList<String>();
        noPropNames.add("LongProp");
        noPropNames.add("ModifierIdProp");
        noPropNames.add("LinkEntryProp");
        noPropNames.add("DynamicLocaleProperty");
        return noPropNames;
    }

    private static void initProps(TreeNode rootNode, IDataEntityType entityType, List<IMetadata> parents, String filterKey) {
        String number;
        TreeNode parentNode = null;
        if (parents.isEmpty()) {
            TreeNode node = new TreeNode(rootNode.getId(), "billhead", "\u5355\u636e\u5934");
            rootNode.addChild(node);
            parentNode = node;
        } else {
            parentNode = rootNode;
        }
        ArrayList<IDataEntityType> entryTypes = new ArrayList<IDataEntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            number = property.getName();
            String classSimpleName = property.getClass().getSimpleName();
            String displayName = SelectFieldFormPlugin.getDisplayName((IMetadata)property);
            StringBuilder fullnumber = new StringBuilder(number);
            StringBuilder fullname = new StringBuilder(displayName);
            for (int i = parents.size() - 1; i >= 0; --i) {
                IMetadata parent = parents.get(i);
                fullnumber.insert(0, parent.getName() + ".");
                fullname.insert(0, SelectFieldFormPlugin.getDisplayName(parent) + ".");
            }
            String fullNumber = fullnumber.toString();
            String fullName = fullname.toString();
            String parentId = YEM.substringBeforeLast(fullNumber, ".");
            if (property instanceof EntryProp && !(property instanceof LinkEntryProp)) {
                List keys;
                if (kd.bos.util.StringUtils.isNotEmpty((String)filterKey) && !(keys = Stream.of(filterKey.split("\\.")).collect(Collectors.toList())).contains(number)) continue;
                entryTypes.add(((EntryProp)property).getItemType());
                continue;
            }
            if (SelectFieldFormPlugin.getExcludePropNames().contains(classSimpleName)) continue;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                IDataEntityType complexType = basedataProp.getComplexType();
                ArrayList<IMetadata> allParents = new ArrayList<IMetadata>(parents);
                allParents.add((IMetadata)basedataProp);
                TreeNode node = new TreeNode(parentNode.getId(), fullNumber, displayName);
                SelectFieldFormPlugin.initProps(node, complexType, allParents, filterKey);
                parentNode.addChild(node);
                continue;
            }
            TreeNode node = new TreeNode(parentId, fullNumber, displayName);
            parentNode.addChild(node);
        }
        for (IDataEntityType entryType : entryTypes) {
            number = entryType.getName();
            String displayName = SelectFieldFormPlugin.getDisplayName((IMetadata)entryType);
            StringBuilder fullnumber = new StringBuilder(number);
            StringBuilder fullname = new StringBuilder(displayName);
            for (int i = parents.size() - 1; i >= 0; --i) {
                IMetadata parent = parents.get(i);
                fullnumber.insert(0, parent.getName() + ".");
                fullname.insert(0, SelectFieldFormPlugin.getDisplayName(parent) + ".");
            }
            String fullNumber = fullnumber.toString();
            String fullName = fullname.toString();
            ArrayList<IMetadata> allParents = new ArrayList<IMetadata>(parents);
            allParents.add((IMetadata)entryType);
            TreeNode node = new TreeNode(rootNode.getId(), fullNumber, displayName);
            SelectFieldFormPlugin.initProps(node, entryType, allParents, filterKey);
            rootNode.addChild(node);
        }
    }

    private static String getDisplayName(IMetadata iMetadata) {
        return iMetadata.getDisplayName() != null ? iMetadata.getDisplayName().getLocaleValue() : "";
    }

    private void setTreeNodeDisabled(TreeNode rootNode) {
        String string = (String)this.getView().getFormShowParameter().getCustomParam("lockCtrlFields");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            Set lockCtrlFields = (Set)SerializationUtils.fromJsonString((String)string, Set.class);
            for (String s : lockCtrlFields) {
                TreeNode treeNode = rootNode.getTreeNode(s, 16);
                if (treeNode == null) continue;
                treeNode.setDisabled(true);
            }
        }
    }

    private void multiSelect(TreeView tree, TreeNode rootNode) {
        tree.setMulti(true);
        String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam("nodeids");
        if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
            this.getPageCache().put("nodeids", cacheNodeIds);
            String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
            ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
            for (String nodeId : arr) {
                TreeNode node = rootNode.getTreeNode(nodeId, 5);
                if (node == null) continue;
                selectedNodes.add(node);
            }
            if (!selectedNodes.isEmpty()) {
                tree.checkNodes(selectedNodes);
            }
        }
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", "\u5355\u636e\u5b57\u6bb5\u5217\u8868");
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_IsMulti);
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)Key_SearchField, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            rootNode = this.getTreeNode(entityNumber);
        } else {
            this.addTreeRootNode();
        }
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        if (StringUtils.isNotBlank((CharSequence)searchText) && CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
            rootNode.setChildren(this.getContains(rootNode.getChildren(), searchText));
        }
        tree.updateNode(rootNode);
        this.setTreeNodeDisabled(rootNode);
        if (this.isMultiSelected()) {
            this.multiSelect(tree, rootNode);
        }
    }

    private List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                treeNode.setChildren(this.getContains(treeNode.getChildren(), searchText));
            }
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren()) || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }
}

