/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.meta.report;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.de.meta.report.DataDictionaryRptListPlugin;
import yem.base.common.utils.RptUtil;
import yem.base.common.utils.YEM;

public class DataCompareRptListPlugin
extends AbstractReportListDataPlugin
implements Plugin {
    private static final String algoKey = DataCompareRptListPlugin.class.getName();
    private static final Map<String, String> fieldMap = new HashMap<String, String>();

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject yem_fentityobj = filterInfo.getDynamicObject("yem_fentityobj");
        String entityKey = yem_fentityobj == null ? "" : yem_fentityobj.getString("number");
        boolean onlyChanged = filterInfo.getBoolean("yem_onlychanged");
        Object[] pkArray = (Object[])filterInfo.getValue("yem_entryentity");
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)YEM.getDataEntityType(entityKey));
        DataSet dataSet = DataDictionaryRptListPlugin.queryDataBill(entityKey);
        List<String> aliasList = RptUtil.getDataSetAliasList(dataSet);
        aliasList.add("false yem_change");
        fieldMap.clear();
        for (int i = 0; i < bills.length; ++i) {
            String key = "yem_data" + i + 1;
            DynamicObject bill = bills[i];
            String valueKey = bill.containsProperty("billno") ? bill.getString("billno") : (bill.containsProperty("number") ? bill.getString("number") : bill.getString("id"));
            fieldMap.put(key, valueKey);
            aliasList.add("'' " + key);
        }
        dataSet = dataSet.select(aliasList.toArray(new String[0]));
        DynamicObjectCollection dynamicObjects = ORM.create().toPlainDynamicObjectCollection(dataSet);
        for (DynamicObject obj : dynamicObjects) {
            String number = obj.getString("yem_number2");
            String fullnumber = obj.getString("yem_fullnumber2");
            HashSet<Object> values = new HashSet<Object>();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject dyObj = bills[i];
                if (fullnumber.contains(".")) {
                    String[] split;
                    for (String entity : split = fullnumber.split("\\.")) {
                        if (dyObj == null || number.equals(entity)) continue;
                        DynamicObjectCollection entry = dyObj.getDynamicObjectCollection(entity);
                        dyObj = entry.size() > 0 ? (DynamicObject)entry.get(0) : null;
                    }
                }
                Object value = dyObj == null ? null : dyObj.get(number);
                values.add(value);
                obj.set("yem_data" + i + 1, value);
            }
            if (values.size() <= 1) continue;
            obj.set("yem_change", (Object)true);
        }
        dataSet = RptUtil.plainDataSet(algoKey, dataSet, dynamicObjects);
        if (onlyChanged) {
            dataSet = dataSet.where("yem_change = true");
        }
        return dataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        String fdatagroup = "fdatagroup";
        ReportColumnGroup reportColumnGroup = this.createReportColumnGroup(fdatagroup, "\u5b57\u6bb5\u503c");
        for (Map.Entry<String, String> field : fieldMap.entrySet()) {
            reportColumnGroup.getChildren().add(this.createReportColumn(field.getKey(), field.getValue(), "text"));
        }
        columns.add((AbstractReportColumn)reportColumnGroup);
        return super.getColumns(columns);
    }

    private ReportColumnGroup createReportColumnGroup(String fieldkey, String fieldname) {
        ReportColumnGroup rptColumnGroup = new ReportColumnGroup();
        rptColumnGroup.setFieldKey(fieldkey);
        rptColumnGroup.setCaption(new LocaleString(fieldname));
        return rptColumnGroup;
    }

    private ReportColumn createReportColumn(String fieldkey, String fieldname, String fieldtype) {
        ReportColumn rptColumn = new ReportColumn();
        rptColumn.setFieldKey(fieldkey);
        rptColumn.setCaption(new LocaleString(fieldname));
        rptColumn.setFieldType(fieldtype);
        return rptColumn;
    }
}

