/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.meta.report;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import yem.base.common.utils.YEM;

public class DataCompareRptPlugin
extends AbstractReportFormPlugin {
    private static final String entryKey = "yem_entryentity";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection yem_entryentity = this.getModel().getEntryEntity(entryKey);
        Object[] pkArray = yem_entryentity.stream().map(x -> x.get("yem_fdataid")).toArray();
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem(entryKey, (Object)pkArray);
        return super.verifyQuery(queryParam);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_fdata"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("yem_fdata".equals(key)) {
            this.dataClick(key);
        }
    }

    private void dataClick(String key) {
        DynamicObject yem_fentityobj = (DynamicObject)this.getModel().getValue("yem_fentityobj");
        if (yem_fentityobj != null) {
            ListShowParameter createShowListForm = ShowFormHelper.createShowListForm((String)yem_fentityobj.getString("id"), (boolean)true, (int)0);
            createShowListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm((FormShowParameter)createShowListForm);
        } else {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u4e3b\u5b9e\u4f53\u3002");
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (actionId != null && "yem_fdata".equals(actionId)) {
            this.listCallBack(event);
        }
    }

    private void listCallBack(ClosedCallBackEvent event) {
        IDataModel model = this.getModel();
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
        if (selectedRows != null) {
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow info = selectedRows.get(i);
                String billNo = info.getBillNo();
                String number = info.getNumber();
                Object primaryKeyValue = info.getPrimaryKeyValue();
                int index = i == 0 ? model.getEntryCurrentRowIndex(entryKey) : model.createNewEntryRow(entryKey);
                model.setValue("yem_fdata", (Object)(YEM.isNotEmpty(billNo) ? billNo : number), index);
                model.setValue("yem_fdataid", primaryKeyValue, index);
            }
        }
    }
}

