/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.meta.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import yem.base.common.utils.RptUtil;
import yem.base.common.utils.YEM;

public class DataDictionaryRptListPlugin
extends AbstractReportListDataPlugin {
    private static final String algoKey = DataDictionaryRptListPlugin.class.getName();
    private static List<String> fieldKeys1 = new ArrayList<String>();
    private static final List<String> fieldKeys2 = new ArrayList<String>();
    private static final List<String> noPropNames = new ArrayList<String>();

    public static DataSet queryDataBill(String entityKey) {
        Field[] formFields = DataDictionaryRptListPlugin.getFormFields();
        Collection<Object[]> collection = DataDictionaryRptListPlugin.getFormFieldsData(entityKey);
        return Algo.create((String)algoKey).createDataSet(collection, new RowMeta(formFields));
    }

    private static Collection<Object[]> getFormFieldsData(String entityKey) {
        ArrayList<Object[]> collection = new ArrayList<Object[]>();
        if (YEM.isNotEmpty(entityKey)) {
            DataDictionaryRptListPlugin.initMetaData(collection, (IDataEntityType)YEM.getDataEntityType(entityKey));
        }
        return collection;
    }

    private static void initMetaData(Collection<Object[]> collection, IDataEntityType entityType) {
        String localeName = DataDictionaryRptListPlugin.getLocaleName(entityType.getDisplayName());
        String tablename = entityType.getAlias();
        String parentLocaleName = "";
        if (entityType instanceof BillEntityType) {
            parentLocaleName = localeName;
            localeName = "\u5355\u636e\u5934";
        } else if (entityType instanceof EntryType) {
            parentLocaleName = DataDictionaryRptListPlugin.getLocaleName(entityType.getParent().getDisplayName());
        }
        ArrayList<IDataEntityType> entryTypes = new ArrayList<IDataEntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            String number = property.getName();
            String alias = property.getAlias();
            String classSimpleName = property.getClass().getSimpleName();
            if (property instanceof EntryProp && !(property instanceof LinkEntryProp)) {
                entryTypes.add(((EntryProp)property).getItemType());
                continue;
            }
            boolean isId = "id".equals(number);
            if (noPropNames.contains(classSimpleName) && !isId) continue;
            String displayName = isId ? "ID" : DataDictionaryRptListPlugin.getLocaleName(property.getDisplayName());
            String fullnumber = number;
            String fullname = displayName;
            IDataEntityType parent = property.getParent();
            if (parent instanceof SubEntryType) {
                IDataEntityType grandParent = parent.getParent();
                fullnumber = String.format("%s.%s.%s", grandParent.getName(), parent.getName(), fullnumber);
                fullname = String.format("%s.%s.%s", DataDictionaryRptListPlugin.getLocaleName(grandParent.getDisplayName()), DataDictionaryRptListPlugin.getLocaleName(parent.getDisplayName()), fullname);
            } else if (parent instanceof EntryType) {
                fullnumber = String.format("%s.%s", parent.getName(), fullnumber);
                fullname = String.format("%s.%s", DataDictionaryRptListPlugin.getLocaleName(parent.getDisplayName()), fullname);
            }
            String baseEntity = "";
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                String baseEntityId = basedataProp.getBaseEntityId();
                String baseEntityName = DataDictionaryRptListPlugin.getLocaleName(basedataProp.getComplexType().getDisplayName());
                baseEntity = String.format("%s\uff08%s\uff09", baseEntityName, baseEntityId);
            }
            int i = 0;
            Object[] row = new Object[fieldKeys2.size()];
            row[i++] = parentLocaleName;
            row[i++] = localeName;
            row[i++] = number;
            row[i++] = fullnumber;
            row[i++] = alias;
            row[i++] = displayName;
            row[i++] = fullname;
            row[i++] = classSimpleName;
            row[i++] = classSimpleName;
            row[i++] = baseEntity;
            row[i++] = tablename;
            collection.add(row);
        }
        for (IDataEntityType entryType : entryTypes) {
            DataDictionaryRptListPlugin.initMetaData(collection, entryType);
        }
    }

    private static String getLocaleName(LocaleString displayName) {
        return displayName == null ? "" : displayName.getLocaleValue();
    }

    private static Field[] getFormFields() {
        fieldKeys2.clear();
        fieldKeys2.add("yem_parent2");
        fieldKeys2.add("yem_entity2");
        fieldKeys2.add("yem_number2");
        fieldKeys2.add("yem_fullnumber2");
        fieldKeys2.add("yem_alias2");
        fieldKeys2.add("yem_name2");
        fieldKeys2.add("yem_fullname2");
        fieldKeys2.add("yem_datatype2");
        fieldKeys2.add("yem_aliastype2");
        fieldKeys2.add("yem_basedatakey2");
        fieldKeys2.add("yem_tablename");
        ArrayList<Field> fields = new ArrayList<Field>();
        for (String key : fieldKeys2) {
            fields.add(new Field(key, (DataType)DataType.StringType));
        }
        return fields.toArray(new Field[0]);
    }

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        return this.query(param);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        String rptType = filterInfo.getString("yem_type");
        List<String> fieldKeys = "2".equals(rptType) ? fieldKeys2 : fieldKeys1;
        for (int i = 0; i < columns.size(); ++i) {
            ReportColumn column = (ReportColumn)columns.get(i);
            String fieldKey = column.getFieldKey();
            if (fieldKeys.contains(fieldKey)) continue;
            columns.remove(i--);
        }
        return super.getColumns(columns);
    }

    private DataSet query(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        String rptType = filterInfo.getString("yem_type");
        if ("2".equals(rptType)) {
            DynamicObject yem_fentityobj = filterInfo.getDynamicObject("yem_fentityobj");
            String entityKey = yem_fentityobj == null ? "" : yem_fentityobj.getString("number");
            return DataDictionaryRptListPlugin.queryDataBill(entityKey);
        }
        DataSet formmeta = this.queryFormMeta();
        DataSet bizapp = this.queryBizApp();
        DataSet dataSet = formmeta.join(bizapp, JoinType.INNER).on("bizappid", "yem_appid").select(RptUtil.getDataSetFiledAlias(formmeta), RptUtil.getDataSetFiledAlias(bizapp)).finish();
        fieldKeys1 = RptUtil.getDataSetAliasList(dataSet);
        return dataSet.where(this.createWhereStr(param)).orderBy(new String[]{"yem_bizcloud", "yem_appid", "yem_modeltype"});
    }

    private DataSet queryFormMeta() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id yem_entityid");
        fields.add("number yem_entitykey");
        fields.add("name yem_entityname");
        fields.add("bizappid");
        fields.add("modeltype yem_modeltype");
        fields.add("isv yem_isv");
        return ORM.create().queryDataSet(algoKey, "bos_formmeta", String.join((CharSequence)",", fields), null);
    }

    private DataSet queryBizApp() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id yem_appid");
        fields.add("number yem_appkey");
        fields.add("name yem_appname");
        fields.add("bizcloud yem_bizcloud");
        fields.add("bizcloud.name yem_bizcloudname");
        fields.add("bizcloud.number yem_bizcloudkey");
        fields.add("dbroute yem_dbroute");
        return ORM.create().queryDataSet(algoKey, "bos_devportal_bizapp", String.join((CharSequence)",", fields), null);
    }

    private String createWhereStr(ReportQueryParam param) {
        String yem_fext;
        String yem_fisv;
        String yem_fmodeltype;
        String yem_fentity;
        String yem_fapp;
        FilterInfo filterInfo = param.getFilter();
        String whereFilter = "1 = 1";
        String yem_fbizcloud = filterInfo.getString("yem_fbizcloud");
        if (YEM.isNotEmpty(yem_fbizcloud)) {
            whereFilter = String.format("%s and (yem_bizcloudkey like '%%%s%%' or yem_bizcloudname like '%%%s%%')", whereFilter, yem_fbizcloud, yem_fbizcloud);
        }
        if (YEM.isNotEmpty(yem_fapp = filterInfo.getString("yem_fapp"))) {
            whereFilter = String.format("%s and (yem_appkey like '%%%s%%' or yem_appname like '%%%s%%')", whereFilter, yem_fapp, yem_fapp);
        }
        if (YEM.isNotEmpty(yem_fentity = filterInfo.getString("yem_fentity"))) {
            whereFilter = String.format("%s and (yem_entitykey like '%%%s%%' or yem_entityname like '%%%s%%')", whereFilter, yem_fentity, yem_fentity);
        }
        if (YEM.isNotEmpty(yem_fmodeltype = filterInfo.getString("yem_fmodeltype"))) {
            whereFilter = String.format("%s and yem_modeltype = '%s'", whereFilter, yem_fmodeltype);
        }
        if (YEM.isNotEmpty(yem_fisv = filterInfo.getString("yem_fisv"))) {
            whereFilter = String.format("%s and yem_isv = '%s'", whereFilter, yem_fisv);
        }
        if ("B".equals(yem_fext = filterInfo.getString("yem_fext"))) {
            whereFilter = whereFilter + " and yem_entitykey not like '%_ext'";
        } else if ("C".equals(yem_fext)) {
            whereFilter = whereFilter + " and yem_entitykey like '%_ext'";
        }
        return whereFilter;
    }

    static {
        noPropNames.add("LongProp");
        noPropNames.add("LinkEntryProp");
        noPropNames.add("DynamicLocaleProperty");
    }
}

