/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.meta.task;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.de.meta.report.DataDictionaryRptListPlugin;
import yem.base.common.utils.YEM;

public class FieldKeyStoreUpdateTask
extends AbstractTask
implements Plugin {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String[] appkeyArray;
        String bizcloudkey = (String)map.get("bizcloudkey");
        String appkeys = (String)map.get("appkeys");
        if (YEM.isEmpty(bizcloudkey) || YEM.isEmpty(appkeys)) {
            return;
        }
        for (String appkey : appkeyArray = appkeys.split(",")) {
            try {
                this.updateFieldKeyStore(bizcloudkey, appkey);
            }
            catch (Throwable e) {
                throw new KDException(e.getMessage());
            }
        }
    }

    private void updateFieldKeyStore(String bizcloudkey, String appkey) throws Throwable {
        ArrayList<DynamicObject> creatNewList = new ArrayList<DynamicObject>();
        ArrayList<String> billIdList = new ArrayList<String>();
        DataDictionaryRptListPlugin report = new DataDictionaryRptListPlugin();
        ReportQueryParam Param = new ReportQueryParam();
        FilterInfo filters = Param.getFilter();
        filters.addFilterItem("yem_datefilter", (Object)"1");
        filters.addFilterItem("yem_fbizcloud", (Object)bizcloudkey);
        filters.addFilterItem("yem_fapp", (Object)appkey);
        Param.setFilter(filters);
        DataSet entityList = report.query(Param, null);
        entityList = entityList.where(String.format("yem_appkey = '%s'", appkey));
        DynamicObjectCollection entityCollection = ORM.create().toPlainDynamicObjectCollection(entityList);
        for (DynamicObject entity : entityCollection) {
            String yemEntityid = entity.getString("yem_entityid");
            String yemEntitykey = entity.getString("yem_entitykey");
            DataSet entityFields = DataDictionaryRptListPlugin.queryDataBill(yemEntitykey);
            DynamicObjectCollection fieldsCollection = ORM.create().toPlainDynamicObjectCollection(entityFields);
            for (DynamicObject fields : fieldsCollection) {
                DynamicObject addNew = BusinessDataServiceHelper.newDynamicObject((String)"yem_base_fieldkeystore");
                addNew.set("name", (Object)(yemEntitykey + fields.getString("yem_number2")));
                addNew.set("enable", (Object)"1");
                addNew.set("status", (Object)"C");
                addNew.set("yem_bizcloud", (Object)entity.getString("yem_bizcloud"));
                addNew.set("yem_bizcloudkey", (Object)entity.getString("yem_bizcloudkey"));
                addNew.set("yem_bizcloudname", (Object)entity.getString("yem_bizcloudname"));
                addNew.set("yem_appid", (Object)entity.getString("yem_appid"));
                addNew.set("yem_appkey", (Object)entity.getString("yem_appkey"));
                addNew.set("yem_appname", (Object)entity.getString("yem_appname"));
                addNew.set("yem_dbroute", (Object)entity.getString("yem_dbroute"));
                addNew.set("yem_entityid", (Object)yemEntityid);
                addNew.set("yem_entitykey", (Object)yemEntitykey);
                addNew.set("yem_entityname", (Object)entity.getString("yem_entityname"));
                addNew.set("yem_modeltype", (Object)entity.getString("yem_modeltype"));
                addNew.set("yem_isv", (Object)entity.getString("yem_isv"));
                addNew.set("yem_parentname", (Object)fields.getString("yem_parent2"));
                addNew.set("yem_entitysname", (Object)fields.getString("yem_entity2"));
                addNew.set("yem_fieldnumber", (Object)fields.getString("yem_number2"));
                addNew.set("yem_fieldnumbers", (Object)fields.getString("yem_fullnumber2"));
                addNew.set("yem_aliasname", (Object)fields.getString("yem_alias2"));
                addNew.set("yem_datatype", (Object)fields.getString("yem_aliastype2"));
                addNew.set("yem_fieldname", (Object)fields.getString("yem_name2"));
                addNew.set("yem_fieldnames", (Object)fields.getString("yem_fullname2"));
                addNew.set("yem_fieldtype", (Object)fields.getString("yem_datatype2"));
                addNew.set("yem_basedatatype", (Object)fields.getString("yem_basedatakey2"));
                creatNewList.add(addNew);
            }
            billIdList.add(yemEntityid);
        }
        Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
        if (!billIdList.isEmpty()) {
            DeleteServiceHelper.delete((String)"yem_base_fieldkeystore", (QFilter[])new QFilter[]{new QFilter("yem_entityid", "in", billIdList)});
            log.info("\u5b57\u6bb5\u6807\u8bc6\u5e93\u5b9a\u65f6\u66f4\u65b0: \u5386\u53f2\u6570\u636e\u5220\u9664\u6210\u529f-" + billIdList.size() + "\u6761");
        }
        if (!creatNewList.isEmpty()) {
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"save", (String)"yem_base_fieldkeystore", (DynamicObject[])creatNewList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                log.info("\u5b57\u6bb5\u6807\u8bc6\u5e93\u5b9a\u65f6\u66f4\u65b0: \u66f4\u65b0\u6570\u636e\u6210\u529f-\u4e91\u6807\u8bc6\uff1a" + bizcloudkey + "\u5e94\u7528\u6807\u8bc6\uff1a" + appkey + "\u6570\u636e\uff1a" + creatNewList.size() + "\u6761");
            } else {
                log.error("\u5b57\u6bb5\u6807\u8bc6\u5e93\u5b9a\u65f6\u66f4\u65b0: \u66f4\u65b0\u6570\u636e\u5931\u8d25-\u4e91\u6807\u8bc6\uff1a" + bizcloudkey + "\u5e94\u7528\u6807\u8bc6\uff1a" + appkey + "\u6570\u636e\uff1a" + creatNewList.size() + "\u6761; \u5931\u8d25\u539f\u56e0\uff1a" + operationResult.getMessage());
            }
        }
    }
}

