/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.meta.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import yem.base.common.utils.YEM;

public class MetaPropertyHelper {
    private static final String KEY_FORM = "yem_de_metaproperty";

    public static void showPropertySelect(AbstractFormPlugin plugin, String actionId, String formKey, boolean isMulti) {
        MetaPropertyHelper.showPropertySelect(plugin, actionId, formKey, isMulti, null);
    }

    public static void showPropertySelect(AbstractFormPlugin plugin, String actionId, String formKey, boolean isMulti, Collection<String> entityKeys) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId(KEY_FORM);
        fsp.setCustomParam("entityKey", (Object)formKey);
        fsp.setCustomParam("alone", (Object)(entityKeys != null && entityKeys.size() > 0 ? 1 : 0));
        fsp.setCustomParam("showKeys", entityKeys);
        fsp.setCustomParam("isMulti", (Object)isMulti);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(fsp);
    }

    public static void callBackEntryData(IDataModel model, ClosedCallBackEvent e, String entryKey, String colNo, String col, boolean ableExsist) {
        DynamicObjectCollection data = (DynamicObjectCollection)e.getReturnData();
        if (YEM.isNotEmpty(data)) {
            HashSet<String> exsistCols = new HashSet<String>();
            for (DynamicObject row : model.getEntryEntity(entryKey)) {
                exsistCols.add(row.getString(colNo));
            }
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject info = (DynamicObject)data.get(i);
                String fullnumber = info.getString("yem_fullnumber");
                String fullname = info.getString("yem_fullname");
                if (!ableExsist && exsistCols.contains(fullnumber)) continue;
                int index = i == 0 ? model.getEntryCurrentRowIndex(entryKey) : model.createNewEntryRow(entryKey);
                model.setValue(colNo, (Object)fullnumber, index);
                model.setValue(col, (Object)fullname, index);
            }
        }
    }

    public static void callBackEntryDataSample(IDataModel model, ClosedCallBackEvent e, String entryKey, String colNo, String col, boolean ableExsist) {
        DynamicObjectCollection data = (DynamicObjectCollection)e.getReturnData();
        if (YEM.isNotEmpty(data)) {
            HashSet<String> exsistCols = new HashSet<String>();
            for (DynamicObject row : model.getEntryEntity(entryKey)) {
                exsistCols.add(row.getString(colNo));
            }
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject info = (DynamicObject)data.get(i);
                String fullnumber = info.getString("yem_number");
                String fullname = info.getString("yem_name");
                if (!ableExsist && exsistCols.contains(fullnumber)) continue;
                int index = i == 0 ? model.getEntryCurrentRowIndex(entryKey) : model.createNewEntryRow(entryKey);
                model.setValue(colNo, (Object)fullnumber, index);
                model.setValue(col, (Object)fullname, index);
            }
        }
    }

    public static void callBackBillData(IDataModel model, ClosedCallBackEvent e, String colNo, String col) {
        block0: {
            Iterator iterator;
            DynamicObjectCollection data = (DynamicObjectCollection)e.getReturnData();
            if (!YEM.isNotEmpty(data) || !(iterator = data.iterator()).hasNext()) break block0;
            DynamicObject info = (DynamicObject)iterator.next();
            String fullnumber = info.getString("yem_fullnumber");
            String fullname = info.getString("yem_fullname");
            model.setValue(colNo, (Object)fullnumber);
            model.setValue(col, (Object)fullname);
        }
    }

    public static void callBackEntryData(IDataModel model, ClosedCallBackEvent e, String entryKey, String subEntryKey, String colNo, String col, boolean ableExsist) {
        DynamicObjectCollection data = (DynamicObjectCollection)e.getReturnData();
        if (YEM.isNotEmpty(data)) {
            HashSet<String> exsistCols = new HashSet<String>();
            for (DynamicObject row : model.getEntryEntity(entryKey)) {
                DynamicObjectCollection subEntry = row.getDynamicObjectCollection(subEntryKey);
                for (DynamicObject subRow : subEntry) {
                    exsistCols.add(subRow.getString(colNo));
                }
            }
            int entryCurrentRowIndex = model.getEntryCurrentRowIndex(entryKey);
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject info = (DynamicObject)data.get(i);
                String fullnumber = info.getString("yem_fullnumber");
                String fullname = info.getString("yem_fullname");
                if (!ableExsist && exsistCols.contains(fullnumber)) continue;
                int index = i == 0 ? model.getEntryCurrentRowIndex(subEntryKey) : model.createNewEntryRow(subEntryKey);
                model.setValue(colNo, (Object)fullnumber, index, entryCurrentRowIndex);
                model.setValue(col, (Object)fullname, index, entryCurrentRowIndex);
            }
        }
    }

    public static void callBackEntryDataSample(IDataModel model, ClosedCallBackEvent e, String entryKey, String subEntryKey, String colNo, String col, boolean ableExsist) {
        DynamicObjectCollection data = (DynamicObjectCollection)e.getReturnData();
        if (YEM.isNotEmpty(data)) {
            HashSet<String> exsistCols = new HashSet<String>();
            for (DynamicObject row : model.getEntryEntity(entryKey)) {
                DynamicObjectCollection subEntry = row.getDynamicObjectCollection(subEntryKey);
                for (DynamicObject subRow : subEntry) {
                    exsistCols.add(subRow.getString(colNo));
                }
            }
            int entryCurrentRowIndex = model.getEntryCurrentRowIndex(entryKey);
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject info = (DynamicObject)data.get(i);
                String fullnumber = info.getString("yem_number");
                String fullname = info.getString("yem_name");
                if (!ableExsist && exsistCols.contains(fullnumber)) continue;
                int index = i == 0 ? model.getEntryCurrentRowIndex(subEntryKey) : model.createNewEntryRow(subEntryKey);
                model.setValue(colNo, (Object)fullnumber, index, entryCurrentRowIndex);
                model.setValue(col, (Object)fullname, index, entryCurrentRowIndex);
            }
        }
    }

    public static String getEntityLangName(String entityName, String fieldKey) {
        String langName = RequestContext.get().getLang().name();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        return MetaPropertyHelper.getEntityLangName(langName, dt, fieldKey);
    }

    public static String getEntityLangName(String langName, MainEntityType dt, String fieldKey) {
        String[] splitKey = fieldKey.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < splitKey.length; ++i) {
            IDataEntityProperty property;
            String curSplitKey;
            String name = curSplitKey = splitKey[i];
            if (builder.length() != 0) {
                builder.append('.');
            }
            if ((property = dt.findProperty(curSplitKey)) == null && i > 0) {
                IDataEntityProperty preProperty = dt.findProperty(splitKey[i - 1]);
                if (preProperty instanceof BasedataProp) {
                    BasedataProp prop = (BasedataProp)preProperty;
                    MainEntityType baseDt = EntityMetadataCache.getDataEntityType((String)prop.getBaseEntityId());
                    IDataEntityProperty baseProperty = baseDt.findProperty(curSplitKey);
                    name = baseProperty.getDisplayName() != null ? (String)baseProperty.getDisplayName().get((Object)langName) : ("id".equals(baseProperty.getName()) ? "ID" : "");
                }
            } else if (property != null) {
                name = property.getDisplayName() != null ? (String)property.getDisplayName().get((Object)langName) : ("id".equals(property.getName()) ? "ID" : "");
            }
            builder.append(name);
        }
        return builder.toString();
    }

    public static DynamicObject getAndCheckF7Value(IFormView view, String colName) {
        IDataModel model = view.getModel();
        DynamicObject value = model.getDataEntity().getDynamicObject(colName);
        if (value == null) {
            MainEntityType type = model.getDataEntityType();
            DynamicProperty pro = type.getProperty(colName);
            String msg = pro == null ? String.format("\u5b57\u6bb5\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", colName) : String.format("\u8bf7\u5148\u9009\u62e9\u3010%s\u3011\u3002", pro.getDisplayName());
            view.showTipNotification(msg);
        }
        return value;
    }

    public static DynamicObject getAndCheckF7Value(IFormView view, String entryKey, String colName) {
        int index;
        IDataModel model = view.getModel();
        DynamicObject value = (DynamicObject)model.getValue(colName, index = model.getEntryCurrentRowIndex(entryKey));
        if (value == null) {
            MainEntityType type = model.getDataEntityType();
            DynamicProperty pro = type.getProperty(colName);
            String msg = pro == null ? String.format("\u5b57\u6bb5\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", colName) : String.format("\u8bf7\u5148\u9009\u62e9\u3010%s\u3011\u3002", pro.getDisplayName());
            view.showTipNotification(msg);
        }
        return value;
    }
}

