/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.service;

import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import yem.base.common.de.service.TypesContainer;

public class ServiceFactory {
    private static Log log = LogFactory.getLog(ServiceFactory.class);
    private static final ThreadLocal<Map<String, Object>> serviceInstanceMap = new ThreadLocal();

    public static <T> T getService(Class<T> clazz) {
        String key = clazz.getName();
        Map<String, Object> serviceMap = serviceInstanceMap.get();
        return (T)(serviceMap != null && serviceMap.containsKey(key) ? serviceMap.get(key) : ServiceFactory.getService(key));
    }

    public static Object getService(String className) {
        if (className == null) {
            throw new RuntimeException("failed to Get Service, ClassName is Null.");
        }
        return TypesContainer.getOrRegisterSingletonInstance(className);
    }
}

