/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.de.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.Instance;

public class TypesContainer {
    private static final Map<Class<?>, Object> instancesDict = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getOrRegisterSingletonInstance(String type) {
        Class<?> t = TypesContainer.doClassForName(type);
        Object ret = instancesDict.get(t);
        if (ret == null) {
            String string = type.intern();
            synchronized (string) {
                ret = instancesDict.get(t);
                if (ret == null) {
                    ret = TypesContainer.createInstance(t);
                    instancesDict.put(t, ret);
                }
            }
        }
        return ret;
    }

    public static Class<?> getOrRegister(String type) {
        return TypesContainer.doClassForName(type);
    }

    private static Class<?> doClassForName(String type) {
        if (type != null && !type.isEmpty()) {
            try {
                return Class.forName(type.trim());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("%s: %s not find.", Instance.getAppName(), type), e);
            }
        }
        throw new IllegalArgumentException("type");
    }

    public static <T> T createInstance(String className) {
        Class<?> type = TypesContainer.getOrRegister(className);
        return TypesContainer.createInstance(type);
    }

    public static <T> T createInstance(Class<?> cls) {
        if (cls == null) {
            throw new RuntimeException("failed to Create Instance,Class is Null.");
        }
        try {
            return (T)cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("%1$s failed to Create Instance:" + e.getMessage(), cls.getName()), e);
        }
    }
}

