/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.impentryset.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import yem.base.common.de.meta.utils.MetaPropertyHelper;

public class ImpEntrySetForm
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String[] BILL_COLS = new String[]{"yem_billcol", "yem_billcolno"};

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initSettings();
    }

    private void initSettings() {
        this.bindColsMap();
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue("yem_requirebill");
        String entityNumber = "";
        if (entityObj != null) {
            entityNumber = entityObj.getString("number");
        }
        this.fillEntityCombo(entityNumber);
    }

    private void bindColsMap() {
        String yem_colmap = this.getModel().getDataEntity().getString("yem_colmap");
        JSONObject entry = null;
        if (StringUtils.isNotEmpty((String)yem_colmap)) {
            entry = JSON.parseObject((String)yem_colmap);
        }
        this.batchSetEntry("yem_colsmap", entry);
    }

    /*
     * Unable to fully structure code
     */
    private void batchSetEntry(String entryName, JSONObject entry) {
        model = this.getModel();
        model.deleteEntryData(entryName);
        yem_requirebill = (DynamicObject)model.getValue("yem_requirebill");
        if (entry != null && yem_requirebill != null) {
            cols = entry.keySet();
            colValues = null;
            indexs = null;
            iterator = cols.iterator();
            block0: while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                col = (String)iterator.next();
                if ("yem_billcol".equals(col)) continue;
                colValues = entry.getJSONArray(col);
                index = colValues.size();
                if (indexs == null) {
                    indexs = model.batchCreateNewEntryRow(entryName, index);
                }
                i = 0;
                while (true) {
                    if (i < index) ** break;
                    continue block0;
                    key = String.valueOf(colValues.get(i));
                    model.setValue(col, (Object)key, indexs[i]);
                    bill = yem_requirebill.getString("number");
                    model.setValue("yem_billcol", (Object)MetaPropertyHelper.getEntityLangName(bill, key), indexs[i]);
                    ++i;
                }
                break;
            }
        }
    }

    private void fillEntityCombo(String entityNumber) {
        ComboEdit entryEditor = (ComboEdit)this.getView().getControl("yem_selectentity");
        if (!entityNumber.isEmpty()) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List<ComboItem> entryItems = this.buildEntryComboItems(mainType);
            entryEditor.setComboItems(entryItems);
            String yem_selectentity = (String)this.getModel().getValue("yem_selectentity");
            String selectentity = "";
            for (ComboItem comboItem : entryItems) {
                if (!comboItem.getValue().equals(yem_selectentity)) continue;
                selectentity = yem_selectentity;
            }
            this.getModel().setValue("yem_selectentity", (Object)selectentity);
        } else {
            entryEditor.setComboItems(null);
        }
    }

    private List<ComboItem> buildEntryComboItems(MainEntityType mainType) {
        ArrayList<ComboItem> entryItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        entryItems.add(blankItem);
        if (mainType != null) {
            Map entitys = mainType.getAllEntities();
            for (EntityType entity : entitys.values()) {
                if (entity instanceof LinkEntryType || !(entity instanceof EntryType) || entity instanceof SubEntryType) continue;
                ComboItem entryItem = new ComboItem();
                entryItem.setValue(entity.getName());
                entryItem.setCaption(entity.getDisplayName());
                entryItems.add(entryItem);
            }
        }
        return entryItems;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_billcol"});
        ((BasedataEdit)this.getControl("yem_requirebill")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_billcol": {
                this.clickBillCol(evt, key, "yem_requirebill", true, true);
            }
        }
    }

    private void clickBillCol(EventObject evt, String key, String baseCol, boolean isMulti, boolean isAddEntry) {
        DynamicObject requireBill = MetaPropertyHelper.getAndCheckF7Value(this.getView(), baseCol);
        if (requireBill != null) {
            String formKey = requireBill.getString("number");
            String yem_selectentity = (String)this.getModel().getValue("yem_selectentity");
            ArrayList<String> entityKeys = new ArrayList<String>();
            if (isAddEntry) {
                entityKeys.add(yem_selectentity);
            }
            MetaPropertyHelper.showPropertySelect((AbstractFormPlugin)this, key, formKey, isMulti, entityKeys);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "yem_requirebill": {
                this.requireBillChanged(e);
            }
        }
    }

    private void requireBillChanged(PropertyChangedArgs e) {
        this.getView().updateView();
        this.getModel().deleteEntryData("yem_colsmap");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        IDataModel model = this.getModel();
        switch (key) {
            case "yem_billcol": {
                MetaPropertyHelper.callBackEntryDataSample(model, e, "yem_colsmap", "yem_billcolno", "yem_billcol", false);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        IDataEntityProperty p = e.getProperty();
        switch (key = p.getName()) {
            case "yem_requirebill": {
                this.beforeRequireBill(e);
            }
        }
    }

    private void beforeRequireBill(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"});
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.beforeSave(e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.initSettings();
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String yem_colmap = this.parseBillCol2Json(BILL_COLS, "yem_colsmap");
        model.setValue("yem_colmap", (Object)yem_colmap);
    }

    private String parseBillCol2Json(String[] colsName, String entryKey) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryKey);
        if (rows.isEmpty()) {
            return null;
        }
        JSONObject json = new JSONObject(colsName.length);
        JSONArray values = null;
        for (int i = 0; i < colsName.length; ++i) {
            String col = colsName[i];
            values = new JSONArray(rows.size());
            for (DynamicObject row : rows) {
                values.add((Object)row.getString(col));
            }
            json.put(col, (Object)values);
        }
        return json.toJSONString();
    }
}

