/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.amt.utils;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import yem.base.common.module.amt.model.AmountModel;
import yem.base.common.utils.BigDecimalUtils;

public class AmtUtil {
    public static AmountModel calculate(boolean isTax, boolean inputAmt, BigDecimal qty, BigDecimal price, BigDecimal taxPrice, BigDecimal amt, BigDecimal taxAmt, BigDecimal tax, BigDecimal taxRate, int priceUom, int pricePrecision, int amtPrecision) {
        AmountModel amountModel = new AmountModel(isTax, inputAmt, qty, price, taxPrice, amt, taxAmt, tax, taxRate, priceUom, pricePrecision, amtPrecision);
        AmtUtil.calculate(amountModel);
        return amountModel;
    }

    public static void calculate(AmountModel amountModel) {
        BigDecimal tax;
        boolean isTax = amountModel.isTax();
        boolean inputAmt = amountModel.isInputAmt();
        BigDecimal qty = amountModel.getQty();
        BigDecimal price = amountModel.getPrice();
        BigDecimal taxPrice = amountModel.getTaxPrice();
        BigDecimal amt = amountModel.getAmt();
        BigDecimal taxAmt = amountModel.getTaxAmt();
        BigDecimal taxRate = amountModel.getTaxRate();
        int pricePrecision = amountModel.getPricePrecision();
        int amtPrecision = amountModel.getAmtPrecision();
        int priceUom = amountModel.getPriceUom();
        if (priceUom == 0) {
            priceUom = 1;
        }
        BigDecimal realRate = BigDecimalUtils.div(taxRate, BigDecimalUtils.one_handred, 10).add(BigDecimal.ONE);
        if (inputAmt) {
            if (isTax) {
                amt = BigDecimalUtils.div(taxAmt, realRate, amtPrecision);
                tax = taxAmt.subtract(amt);
                taxPrice = BigDecimalUtils.multiply((Object)BigDecimalUtils.div(taxAmt, qty, 10), priceUom, 10);
                price = BigDecimalUtils.multiply((Object)BigDecimalUtils.div(BigDecimalUtils.div(taxAmt, realRate, 10), qty, 10), priceUom, 10);
            } else {
                taxAmt = BigDecimalUtils.multiply(amt, realRate, amtPrecision);
                tax = taxAmt.subtract(amt);
                price = BigDecimalUtils.multiply((Object)BigDecimalUtils.div(amt, qty, 10), priceUom, 10);
                taxPrice = BigDecimalUtils.multiply((Object)BigDecimalUtils.div(amt.multiply(realRate), qty, 10), priceUom, 10);
            }
        } else if (isTax) {
            price = BigDecimalUtils.div(taxPrice, realRate, 10);
            taxAmt = BigDecimalUtils.div((Object)qty.multiply(taxPrice), priceUom, pricePrecision);
            amt = BigDecimalUtils.div(taxAmt, realRate, pricePrecision);
            tax = taxAmt.subtract(amt);
        } else {
            taxPrice = BigDecimalUtils.multiply(price, realRate, 10);
            amt = BigDecimalUtils.div((Object)qty.multiply(price), priceUom, pricePrecision);
            taxAmt = BigDecimalUtils.multiply(amt, realRate, pricePrecision);
            tax = taxAmt.subtract(amt);
        }
        amountModel.setPrice(price);
        amountModel.setTaxPrice(taxPrice);
        amountModel.setAmt(amt);
        amountModel.setTaxAmt(taxAmt);
        amountModel.setTax(tax);
    }

    public static void calculateAndSetEntryValue(boolean isTax, boolean inputAmt, String qtyKey, String priceKey, String taxPriceKey, String price_uomKey, String taxRateKey, String amtKey, String taxAmtKey, String taxKey, int pricePrecision, int amtPrecision, DynamicObject entity, IFormView view, int rowIndex) {
        IDataModel model = view.getModel();
        DataEntityPropertyCollection properties = entity.getDynamicObjectType().getProperties();
        BigDecimal qty = entity.getBigDecimal(qtyKey);
        BigDecimal price = entity.getBigDecimal(priceKey);
        BigDecimal taxPrice = entity.getBigDecimal(taxPriceKey);
        BigDecimal taxRate = entity.getBigDecimal(taxRateKey);
        BigDecimal amt = entity.getBigDecimal(amtKey);
        BigDecimal taxAmt = entity.getBigDecimal(taxAmtKey);
        int priceUom = properties.containsKey((Object)price_uomKey) ? entity.getInt(price_uomKey) : 1;
        AmountModel amountModel = AmtUtil.calculate(isTax, inputAmt, qty, price, taxPrice, amt, taxAmt, null, taxRate, priceUom, pricePrecision, amtPrecision);
        if (inputAmt) {
            if (isTax) {
                model.setValue(amtKey, (Object)amountModel.getAmt(), rowIndex);
            } else {
                model.setValue(taxAmtKey, (Object)amountModel.getTaxAmt(), rowIndex);
            }
            model.setValue(priceKey, (Object)amountModel.getPrice(), rowIndex);
            model.setValue(taxPriceKey, (Object)amountModel.getTaxPrice(), rowIndex);
            model.setValue(taxKey, (Object)amountModel.getTax(), rowIndex);
        } else {
            if (isTax) {
                model.setValue(priceKey, (Object)amountModel.getPrice(), rowIndex);
            } else {
                model.setValue(taxPriceKey, (Object)amountModel.getTaxPrice(), rowIndex);
            }
            model.setValue(amtKey, (Object)amountModel.getAmt(), rowIndex);
            model.setValue(taxAmtKey, (Object)amountModel.getTaxAmt(), rowIndex);
            model.setValue(taxKey, (Object)amountModel.getTax(), rowIndex);
        }
    }
}

