/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.attach.form;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.BeforeAttachmentRemoveEvent;
import kd.bos.form.control.events.BeforeAttachmentRemoveListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import yem.base.common.module.attach.util.AccessoryToolsUtil;
import yem.base.common.utils.YEM;

public class AccessoryToolsBillPlugin
extends AbstractBillPlugIn
implements UploadListener,
BeforeAttachmentRemoveListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        String formName = this.getView().getModel().getDataEntity(true).getDynamicObjectType().getName();
        Set<String> attachmentkey = AccessoryToolsUtil.getAttachControl(formName).keySet();
        if (YEM.isEmpty(attachmentkey)) {
            return;
        }
        for (String attachment : attachmentkey) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(attachment);
            if (null == attachmentPanel) {
                return;
            }
            attachmentPanel.addUploadListener((UploadListener)this);
            attachmentPanel.addBeforeRemoveListener((BeforeAttachmentRemoveListener)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        switch (operateKey = e.getOperateKey()) {
            case "save": 
            case "submit": {
                String formName = this.getView().getModel().getDataEntity(true).getDynamicObjectType().getName();
                Set<String> attachmentkey = AccessoryToolsUtil.getAttachControl(formName).keySet();
                this.attachmentForm("yem_attachmentinfo_e", attachmentkey);
                DynamicObjectCollection attachmentinfo_e = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("yem_attachmentinfo_e");
                for (int i = 0; i < attachmentinfo_e.size(); ++i) {
                    model.setValue("yem_billid", model.getValue("id"), i);
                }
                break;
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        String formName = this.getView().getModel().getDataEntity(true).getDynamicObjectType().getName();
        Set<String> attachmentkey = AccessoryToolsUtil.getAttachControl(formName).keySet();
        this.attachmentForm("yem_attachmentinfo_e", attachmentkey);
    }

    public void beforeAttachmentRemove(BeforeAttachmentRemoveEvent e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String status = showParameter.getStatus().toString();
        if (!status.equals("ADDNEW")) {
            long userId = UserServiceHelper.getCurrentUserId();
            DynamicObject bos_user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
            Map map = e.getAttachemnt();
            AttachmentPanel attachmentPanel = (AttachmentPanel)e.getSource();
            String uid = (String)map.get("uid");
            List attachmentData = attachmentPanel.getAttachmentData();
            for (Map data : attachmentData) {
                String creator;
                String uidAttachment = (String)data.get("uid");
                if (StringUtils.isEmpty((CharSequence)uidAttachment) || !uidAttachment.equals(uid) || (creator = data.get("creator").toString()).contains(bos_user.getString("name"))) continue;
                e.setMsg("\u4e0d\u80fd\u5220\u9664\u522b\u4eba\u4e0a\u4f20\u7684\u9644\u4ef6!!!");
                e.setCancel(true);
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        super.afterRemove(evt);
        String formName = this.getView().getModel().getDataEntity(true).getDynamicObjectType().getName();
        Map<String, String> attachControl = AccessoryToolsUtil.getAttachControl(formName);
        Set<String> attachControlkey = attachControl.keySet();
        this.removeAttachmentContext(attachControlkey, formName);
    }

    private void attachmentForm(String yemAttachmentdetail, Set<String> attachmentkey) {
        Map<String, Map<String, Object>> attachmentMap = this.buildAttachmentMap(attachmentkey);
        DynamicObjectCollection attachmentDetail = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection(yemAttachmentdetail);
        String formName = this.getView().getModel().getDataEntity(true).getDynamicObjectType().getName();
        Set existingUids = attachmentDetail.stream().map(detail -> detail.getString("yem_attachedid")).collect(Collectors.toSet());
        attachmentMap.forEach((uid, value) -> {
            if (existingUids.contains(uid)) {
                this.updateExistingAttachment(attachmentDetail, (String)uid, (Map<String, Object>)value, (String)value.get("attachmentpanelKey"));
            } else {
                this.createNewAttachment(yemAttachmentdetail, (String)uid, (Map<String, Object>)value, (String)value.get("attachmentpanelKey"));
            }
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            if (!showParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
                OperationServiceHelper.executeOperate((String)"save", (String)formName, (DynamicObject[])new DynamicObject[]{this.getView().getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
            }
        });
    }

    private void updateExistingAttachment(DynamicObjectCollection attachmentDetail, String uid, Map<String, Object> data, String attachmentpanelKey) {
        for (DynamicObject attachment : attachmentDetail) {
            if (!uid.equals(attachment.getString("yem_attachedid"))) continue;
            int rowIndex = attachmentDetail.indexOf((Object)attachment);
            AccessoryToolsBillPlugin.setAttachmentValues(this, rowIndex, uid, data, attachmentpanelKey, 0L);
            break;
        }
    }

    private void createNewAttachment(String entityName, String uid, Map<String, Object> data, String attachmentpanelKey) {
        int newRow = this.getView().getModel().createNewEntryRow(entityName);
        AccessoryToolsBillPlugin.setAttachmentValues(this, newRow, uid, data, attachmentpanelKey, 1L);
    }

    private static void setAttachmentValues(AbstractBillPlugIn form, int row, String uid, Map<String, Object> data, String attachmentpanelKey, Long attachmenttypeId) {
        DynamicObject dataEntity = form.getView().getModel().getDataEntity(true);
        String billName = dataEntity.getDataEntityType().getName();
        String modeltype = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter("number", "=", (Object)billName).toArray()).getString("modeltype");
        String billno = "";
        if (modeltype.equals("BaseFormModel")) {
            billno = (String)form.getView().getModel().getValue("number");
        } else if (modeltype.equals("BillFormModel")) {
            billno = (String)form.getView().getModel().getValue("billno");
        }
        String str = (String)data.get("createTime");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.parse(str, formatter);
        Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        form.getView().getModel().setValue("yem_attachmentname", data.get("name"), row);
        form.getView().getModel().setValue("yem_atturl", data.get("url"), row);
        form.getView().getModel().setValue("yem_panel", (Object)attachmentpanelKey, row);
        form.getView().getModel().setValue("yem_billno", (Object)billno, row);
        form.getView().getModel().setValue("yem_docid", (Object)billName, row);
        String id = MetadataDao.getIdByNumber((String)billName, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        String docname = formMeta.getName().getLocaleValue();
        form.getView().getModel().setValue("yem_docname", (Object)docname, row);
        form.getView().getModel().setValue("yem_billid", form.getView().getModel().getValue("id"), row);
        form.getView().getModel().setValue("yem_attachedid", (Object)uid, row);
        form.getView().getModel().setValue("yem_uploaddate", (Object)date, row);
        if (attachmenttypeId == 1L) {
            Long currentUserId = UserServiceHelper.getCurrentUserId();
            form.getView().getModel().setValue("yem_attacheduser", (Object)currentUserId, row);
        } else if (attachmenttypeId == 0L) {
            // empty if block
        }
    }

    private Map<String, Map<String, Object>> buildAttachmentMap(Set<String> attachmentkey) {
        HashMap<String, Map<String, Object>> attachmentMap = new HashMap<String, Map<String, Object>>();
        for (String sattachmentinfo : attachmentkey) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(sattachmentinfo);
            List attachmentDatas = attachmentPanel.getAttachmentData();
            for (Map attachmentData : attachmentDatas) {
                String uid = (String)attachmentData.get("uid");
                String name = (String)attachmentData.get("name");
                String url = (String)attachmentData.get("url");
                Long createTime = (Long)attachmentData.get("createdate");
                String formattedTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(createTime));
                Map creator = (Map)attachmentData.get("creator");
                String creatorName = creator != null ? (String)creator.get("zh_CN") : null;
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("name", name);
                dataMap.put("url", url);
                dataMap.put("createTime", formattedTime);
                dataMap.put("creator", creatorName);
                dataMap.put("attachmentpanelKey", sattachmentinfo);
                attachmentMap.put(uid, dataMap);
            }
        }
        return attachmentMap;
    }

    private void removeAttachmentContext(Set<String> attachmentpanelKey, String formName) {
        FormShowParameter showParameter;
        HashSet<String> urlSet = new HashSet<String>();
        for (String attachmentpanel : attachmentpanelKey) {
            AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl(attachmentpanel);
            List attachmentDatas = attachment.getAttachmentData();
            for (Map attachmentData : attachmentDatas) {
                urlSet.add((String)attachmentData.get("uid"));
            }
        }
        DynamicObjectCollection attachmentDetail = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("yem_attachmentinfo_e");
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        for (int i = 0; i < attachmentDetail.size(); ++i) {
            DynamicObject attachment = (DynamicObject)attachmentDetail.get(i);
            if (urlSet.contains(attachment.getString("yem_attachedid"))) continue;
            toDelete.add(i);
        }
        if (!toDelete.isEmpty()) {
            int[] array = toDelete.stream().mapToInt(Integer::intValue).toArray();
            this.getView().getModel().deleteEntryRows("yem_attachmentinfo_e", array);
        }
        if (!(showParameter = this.getView().getFormShowParameter()).getStatus().equals((Object)OperationStatus.ADDNEW)) {
            OperationServiceHelper.executeOperate((String)"save", (String)formName, (DynamicObject[])new DynamicObject[]{this.getView().getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
        }
    }
}

