/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.attach.opplugin.op;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.url.UrlService;
import yem.base.common.module.attach.util.AccessoryToolsUtil;

public class SetfightattachOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SetfightattachOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            this.upLoadPrint(dataEntity, operationKey);
        }
    }

    private void upLoadPrint(DynamicObject dataEntity, String operationKey) {
        String name = dataEntity.getDataEntityType().getName();
        QFilter qFilter = new QFilter("yem_invoices.number", "=", (Object)name);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("yem_operate", "=", (Object)operationKey);
        DynamicObject yemComSetfightattach = BusinessDataServiceHelper.loadSingle((String)"yem_com_setfightattach", (QFilter[])qFilter.toArray());
        if (null == yemComSetfightattach) {
            return;
        }
        try {
            this.printFile(name, dataEntity, yemComSetfightattach);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        OperationServiceHelper.executeOperate((String)"save", (String)name, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
    }

    private void printFile(String name, DynamicObject printtemp, DynamicObject yemComSetfightattach) throws IOException {
        String accessorypanel = yemComSetfightattach.getString("yem_accessorypanel");
        DynamicObject yemPrinttemplates = yemComSetfightattach.getDynamicObject("yem_printtemplates");
        DynamicObject attachmenttype = yemComSetfightattach.getDynamicObject("yem_attachmenttype");
        String number = null != attachmenttype ? attachmenttype.getString("number") : "";
        String typeName = null != attachmenttype ? attachmenttype.getString("name") : "";
        String id = String.valueOf(yemPrinttemplates.getPkValue());
        ArrayList<Object> pkIds = new ArrayList<Object>();
        pkIds.add(printtemp.getPkValue());
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>();
        PrintTask printTask = new PrintTask();
        printTask.setTplId(id);
        printTask.setPkIds(pkIds);
        printTask.setPrintType("billForm");
        printTask.setFormId("src_project");
        taskList.add(printTask);
        PrintWork printWork = new PrintWork();
        printWork.setPrintLang("zh_CN");
        printWork.setExpType("pdf");
        printWork.setTaskList(taskList);
        PrtAttach doPrint = BosPrintServiceHelper.doPrint((PrintWork)printWork);
        List attachDetails = doPrint.getAttachDetail();
        PrtAttach.AttachDetail attachDetail = (PrtAttach.AttachDetail)attachDetails.get(0);
        String path = attachDetail.getFilePath();
        ArrayList<Map<String, Object>> atts = new ArrayList<Map<String, Object>>();
        StringBuilder fileName = new StringBuilder();
        fileName.append(typeName);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String currentDate = dateFormat.format(new Date());
        fileName.append(currentDate);
        String attachmentFullUrl = UrlService.getAttachmentFullUrl((String)attachDetail.getFilePath());
        Map<String, Object> map = SetfightattachOpPlugin.createAttInfo(attachDetail, fileName.toString(), path);
        atts.add(map);
        Map<String, Map<String, Object>> attachmentMap = AccessoryToolsUtil.buildAttachmentMap(atts, accessorypanel);
        attachmentMap.forEach((uid, value) -> AccessoryToolsUtil.setAttachmentValues(printtemp, uid, value, (String)value.get("attachmentpanelKey"), number));
        AttachmentServiceHelper.upload((String)name, (Object)printtemp.getPkValue(), (String)accessorypanel, atts);
    }

    public static Map<String, Object> createAttInfo(PrtAttach.AttachDetail attachDetail, String fileName, String path) {
        HashMap<String, Object> att = new HashMap<String, Object>();
        long time = new Date().getTime();
        long l = System.currentTimeMillis();
        att.put("createdate", time);
        att.put("lastModified", time);
        att.put("status", "success");
        String attType = attachDetail.getFileType();
        att.put("type", attType);
        SimpleDateFormat format = new SimpleDateFormat("HHmmss");
        att.put("name", fileName + ".pdf");
        FileService fs = FileServiceFactory.getAttachmentFileService();
        InputStream in = fs.getInputStream(path);
        try {
            byte[] attByte = SetfightattachOpPlugin.InputStreamToByte(in);
            att.put("size", attByte.length);
        }
        catch (IOException e1) {
            log.error((Throwable)e1);
        }
        String uid = "rc-upload-" + time + "-1";
        att.put("uid", uid);
        att.put("url", attachDetail.getFilePath());
        return att;
    }

    public static byte[] InputStreamToByte(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] imgdata = bytestream.toByteArray();
        bytestream.close();
        return imgdata;
    }
}

